/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ADictBasedColGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.io.CompressUnwrap;
import org.apache.sysds.runtime.compress.io.CompressedWriteBlock;
import org.apache.sysds.runtime.compress.io.DictWritable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.HDFSTool;
import scala.Tuple2;

public interface ReaderSparkCompressed {
    public static final Log LOG = LogFactory.getLog((String)ReaderSparkCompressed.class.getName());

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> getRDD(JavaSparkContext sc, String fileName) {
        String dictName = fileName + ".dict";
        JavaPairRDD<MatrixIndexes, MatrixBlock> cmbRdd = sc.hadoopFile(fileName, SequenceFileInputFormat.class, MatrixIndexes.class, CompressedWriteBlock.class).mapValues(new CompressUnwrap());
        if (HDFSTool.existsFileOnHDFS(dictName)) {
            JavaPairRDD<DictWritable.K, DictWritable> dictsRdd = sc.hadoopFile(dictName, SequenceFileInputFormat.class, DictWritable.K.class, DictWritable.class);
            return ReaderSparkCompressed.combineRdds(cmbRdd, dictsRdd);
        }
        return cmbRdd;
    }

    private static JavaPairRDD<MatrixIndexes, MatrixBlock> combineRdds(JavaPairRDD<MatrixIndexes, MatrixBlock> cmbRdd, JavaPairRDD<DictWritable.K, DictWritable> dictsRdd) {
        JavaPairRDD dictsUnpacked = dictsRdd.mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)(((DictWritable.K)t._1).id + 1), ((DictWritable)t._2).dicts));
        JavaPairRDD mbrddC = cmbRdd.mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)((int)((MatrixIndexes)t._1).getColumnIndex()), (Object)new Tuple2((Object)new MatrixIndexes((MatrixIndexes)t._1), (Object)((MatrixBlock)t._2))));
        return mbrddC.join(dictsUnpacked).mapToPair(ReaderSparkCompressed::combineTuples);
    }

    private static Tuple2<MatrixIndexes, MatrixBlock> combineTuples(Tuple2<Integer, Tuple2<Tuple2<MatrixIndexes, MatrixBlock>, List<IDictionary>>> e) {
        MatrixIndexes kOut = (MatrixIndexes)((Tuple2)((Tuple2)e._2)._1)._1;
        MatrixBlock mbIn = (MatrixBlock)((Tuple2)((Tuple2)e._2)._1)._2;
        List dictsIn = (List)((Tuple2)e._2)._2;
        MatrixBlock ob = ReaderSparkCompressed.combineMatrixBlockAndDict(mbIn, dictsIn);
        return new Tuple2((Object)new MatrixIndexes(kOut), (Object)ob);
    }

    private static MatrixBlock combineMatrixBlockAndDict(MatrixBlock mb, List<IDictionary> dicts) {
        if (mb instanceof CompressedMatrixBlock) {
            CompressedMatrixBlock cmb = (CompressedMatrixBlock)mb;
            List<AColGroup> gs = cmb.getColGroups();
            if (dicts.size() == gs.size()) {
                for (int i = 0; i < dicts.size(); ++i) {
                    AColGroup g = gs.get(i);
                    if (!(g instanceof ADictBasedColGroup)) continue;
                    gs.set(i, ((ADictBasedColGroup)g).copyAndSet(dicts.get(i)));
                }
            } else {
                int gis = 0;
                for (int i = 0; i < gs.size(); ++i) {
                    AColGroup g = gs.get(i);
                    if (!(g instanceof ADictBasedColGroup)) continue;
                    ADictBasedColGroup dg = (ADictBasedColGroup)g;
                    gs.set(i, dg.copyAndSet(dicts.get(gis)));
                    ++gis;
                }
            }
            return new CompressedMatrixBlock(cmb.getNumRows(), cmb.getNumColumns(), cmb.getNonZeros(), cmb.isOverlapping(), gs);
        }
        return mb;
    }
}

