/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.util.Assert;

class BeanOverrideRegistry {
    static final String BEAN_NAME = "org.springframework.test.context.bean.override.internalBeanOverrideRegistry";
    private static final Log logger = LogFactory.getLog(BeanOverrideRegistry.class);
    private final Map<BeanOverrideHandler, String> handlerToBeanNameMap = new LinkedHashMap<BeanOverrideHandler, String>();
    private final Map<String, BeanOverrideHandler> wrappingBeanOverrideHandlers = new LinkedHashMap<String, BeanOverrideHandler>();
    private final ConfigurableBeanFactory beanFactory;
    @Nullable
    private final BeanOverrideRegistry parent;

    BeanOverrideRegistry(ConfigurableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ConfigurableBeanFactory must not be null");
        this.beanFactory = beanFactory;
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        this.parent = parentBeanFactory != null && parentBeanFactory.containsBean(BEAN_NAME) ? (BeanOverrideRegistry)parentBeanFactory.getBean(BEAN_NAME, BeanOverrideRegistry.class) : null;
    }

    void registerBeanOverrideHandler(BeanOverrideHandler handler, String beanName) {
        Assert.state((!this.handlerToBeanNameMap.containsKey(handler) ? 1 : 0) != 0, () -> "Cannot register BeanOverrideHandler for bean with name '%s'; detected multiple registrations for %s".formatted(beanName, handler));
        boolean beanNameAlreadyRegistered = this.handlerToBeanNameMap.containsValue(beanName);
        this.handlerToBeanNameMap.put(handler, beanName);
        if (beanNameAlreadyRegistered && logger.isWarnEnabled()) {
            List<BeanOverrideHandler> competingHandlers = this.handlerToBeanNameMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(beanName)).map(Map.Entry::getKey).toList();
            logger.warn((Object)"Bean with name '%s' was overridden by multiple handlers: %s".formatted(beanName, competingHandlers));
        }
        if (handler.getStrategy() == BeanOverrideStrategy.WRAP) {
            this.wrappingBeanOverrideHandlers.put(beanName, handler);
        }
    }

    Object wrapBeanIfNecessary(Object bean, String beanName) {
        if (!this.wrappingBeanOverrideHandlers.containsKey(beanName)) {
            return bean;
        }
        BeanOverrideHandler handler = this.wrappingBeanOverrideHandlers.get(beanName);
        Assert.state((handler != null ? 1 : 0) != 0, () -> "Failed to find wrapping BeanOverrideHandler for bean '" + beanName + "'");
        return handler.createOverrideInstance(beanName, null, bean, (SingletonBeanRegistry)this.beanFactory);
    }

    @Nullable
    Object getBeanForHandler(BeanOverrideHandler handler, Class<?> requiredType) {
        String beanName = this.handlerToBeanNameMap.get(handler);
        if (beanName != null) {
            return this.beanFactory.getBean(beanName, requiredType);
        }
        if (this.parent != null) {
            return this.parent.getBeanForHandler(handler, requiredType);
        }
        return null;
    }
}

