/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;

public class MockFilterRegistration
implements FilterRegistration.Dynamic {
    private final String name;
    private final String className;
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private final List<String> servletNames = new ArrayList<String>();
    private final List<String> urlPatterns = new ArrayList<String>();
    private boolean asyncSupported;

    public MockFilterRegistration(String className) {
        this(className, "");
    }

    public MockFilterRegistration(String className, String name) {
        this.name = name;
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    public boolean setInitParameter(String name, String value) {
        return this.initParameters.putIfAbsent(name, value) != null;
    }

    @Nullable
    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        LinkedHashSet<String> existingParameterNames = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.initParameters.get(entry.getKey()) == null) continue;
            existingParameterNames.add(entry.getKey());
        }
        if (existingParameterNames.isEmpty()) {
            this.initParameters.putAll(initParameters);
        }
        return existingParameterNames;
    }

    public Map<String, String> getInitParameters() {
        return Collections.unmodifiableMap(this.initParameters);
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.servletNames.addAll(Arrays.asList(servletNames));
    }

    public Collection<String> getServletNameMappings() {
        return Collections.unmodifiableCollection(this.servletNames);
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.urlPatterns.addAll(Arrays.asList(urlPatterns));
    }

    public Collection<String> getUrlPatternMappings() {
        return Collections.unmodifiableCollection(this.urlPatterns);
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }
}

