/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.FinalizedSketch;
import org.apache.spark.sql.catalyst.expressions.aggregate.IntersectionAggregationBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.ThetaIntersectionAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ThetaSketchState;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the ThetaSketch's Compact binary representation\n      by intersecting all the Theta sketches in the input column.", examples="\n    Examples:\n      > SELECT theta_sketch_estimate(_FUNC_(sketch)) FROM (SELECT theta_sketch_agg(col) as sketch FROM VALUES (1) tab(col) UNION ALL SELECT theta_sketch_agg(col, 20) as sketch FROM VALUES (1) tab(col));\n       1\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tUc\u0001\u0002\u0015*\u0001bB\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tC\u0002\u0011\t\u0012)A\u0005\r\"A!\r\u0001BK\u0002\u0013\u00053\r\u0003\u0005h\u0001\tE\t\u0015!\u0003e\u0011!A\u0007A!f\u0001\n\u0003\u001a\u0007\u0002C5\u0001\u0005#\u0005\u000b\u0011\u00023\t\u000b)\u0004A\u0011A6\t\u000b)\u0004A\u0011\u00019\t\u000bI\u0004A\u0011I:\t\u000bY\u0004A\u0011I<\t\u000bi\u0004A\u0011K>\t\u000by\u0004A\u0011I@\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u00111\u0010\u0001\u0005B\u0005u\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\ti\tAI\u0001\n\u0003\ty\tC\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002(\"I\u00111\u0016\u0001\u0012\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_C\u0001\"a0\u0001\u0003\u0003%\ta\u0019\u0005\n\u0003\u0003\u0004\u0011\u0011!C\u0001\u0003\u0007D\u0011\"!3\u0001\u0003\u0003%\t%a3\t\u0013\u0005e\u0007!!A\u0005\u0002\u0005m\u0007\"CAp\u0001\u0005\u0005I\u0011IAq\u0011%\t)\u000fAA\u0001\n\u0003\n9oB\u0005\u0003\f%\n\t\u0011#\u0001\u0003\u000e\u0019A\u0001&KA\u0001\u0012\u0003\u0011y\u0001\u0003\u0004kE\u0011\u0005!q\u0005\u0005\n\u0005S\u0011\u0013\u0011!C#\u0005WA\u0011B!\f#\u0003\u0003%\tIa\f\t\u0013\t]\"%!A\u0005\u0002\ne\u0002\"\u0003B&E\u0005\u0005I\u0011\u0002B'\u0005Q!\u0006.\u001a;b\u0013:$XM]:fGRLwN\\!hO*\u0011!fK\u0001\nC\u001e<'/Z4bi\u0016T!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]=\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0007\u0001e\u0002%*T*\u0011\u0007iZT(D\u0001*\u0013\ta\u0014F\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"A\u000f \n\u0005}J#\u0001\u0005+iKR\f7k[3uG\"\u001cF/\u0019;f!\r\tEIR\u0007\u0002\u0005*\u00111)L\u0001\u0006iJ,Wm]\u0005\u0003\u000b\n\u0013\u0011\"\u00168befd\u0015n[3\u0011\u0005\u001dCU\"A\u0016\n\u0005%[#AC#yaJ,7o]5p]B\u0011qiS\u0005\u0003\u0019.\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0016/\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-8\u0003\u0019a$o\\8u}%\t\u0001+\u0003\u0002\\\u001f\u00069\u0001/Y2lC\u001e,\u0017BA/_\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tYv*A\u0003dQ&dG-F\u0001G\u0003\u0019\u0019\u0007.\u001b7eA\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001e!\tqU-\u0003\u0002g\u001f\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\rqJg.\u001b;?)\u0011aWN\\8\u0011\u0005i\u0002\u0001\"B0\b\u0001\u00041\u0005\"\u00022\b\u0001\u0004!\u0007\"\u00025\b\u0001\u0004!GC\u00017r\u0011\u0015y\u0006\u00021\u0001G\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$HC\u00017u\u0011\u0015)\u0018\u00021\u0001e\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\ta\u0007\u0010C\u0003z\u0015\u0001\u0007A-A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"\u0001\u001c?\t\u000bu\\\u0001\u0019\u0001$\u0002\u00119,wo\u00115jY\u0012\f!\u0002\u001d:fiRLh*Y7f+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u000f\u0001\"AV(\n\u0007\u0005%q*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013y\u0015AC5oaV$H+\u001f9fgV\u0011\u0011Q\u0003\t\u0006)\u0006]\u00111D\u0005\u0004\u00033q&aA*fcB!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"=\nQ\u0001^=qKNLA!!\n\u0002 \t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\u0006\t\u0005\u0003;\ti#\u0003\u0003\u00020\u0005}!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\"!!\u000e\u0011\u00079\u000b9$C\u0002\u0002:=\u0013qAQ8pY\u0016\fg.A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\tQ(\u0001\u0004va\u0012\fG/\u001a\u000b\u0006{\u0005\r\u0013q\t\u0005\u0007\u0003\u000b\n\u0002\u0019A\u001f\u0002%%tG/\u001a:tK\u000e$\u0018n\u001c8Ck\u001a4WM\u001d\u0005\b\u0003\u0013\n\u0002\u0019AA&\u0003\u0015Ig\u000e];u!\u0011\ti%a\u0014\u000e\u00035J1!!\u0015.\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000bu\n9&!\u0017\t\r\u0005\u0015#\u00031\u0001>\u0011\u0019\tIE\u0005a\u0001{\u0005!QM^1m)\u0011\ty&!\u001a\u0011\u00079\u000b\t'C\u0002\u0002d=\u00131!\u00118z\u0011\u0019\t9g\u0005a\u0001{\u0005Y1o[3uG\"\u001cF/\u0019;f\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002n\u0005e\u0004#\u0002(\u0002p\u0005M\u0014bAA9\u001f\n)\u0011I\u001d:bsB\u0019a*!\u001e\n\u0007\u0005]tJ\u0001\u0003CsR,\u0007BBA4)\u0001\u0007Q(A\u0006eKN,'/[1mSj,GcA\u001f\u0002\u0000!9\u0011\u0011Q\u000bA\u0002\u00055\u0014A\u00022vM\u001a,'/\u0001\u0003d_BLHc\u00027\u0002\b\u0006%\u00151\u0012\u0005\b?Z\u0001\n\u00111\u0001G\u0011\u001d\u0011g\u0003%AA\u0002\u0011Dq\u0001\u001b\f\u0011\u0002\u0003\u0007A-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E%f\u0001$\u0002\u0014.\u0012\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003%)hn\u00195fG.,GMC\u0002\u0002 >\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019+!'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%&f\u00013\u0002\u0014\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00022B!\u00111WA_\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016\u0001\u00027b]\u001eT!!a/\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\t),\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0013Q\u0019\u0005\t\u0003\u000fd\u0012\u0011!a\u0001I\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!4\u0011\r\u0005=\u0017Q[A0\u001b\t\t\tNC\u0002\u0002T>\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9.!5\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\ti\u000eC\u0005\u0002Hz\t\t\u00111\u0001\u0002`\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\t,a9\t\u0011\u0005\u001dw$!AA\u0002\u0011\fa!Z9vC2\u001cH\u0003BA\u001b\u0003SD\u0011\"a2!\u0003\u0003\u0005\r!a\u0018)'\u0001\ti/a=\u0002v\u0006e\u00181`A\u0000\u0005\u0003\u0011)Aa\u0002\u0011\u0007\u001d\u000by/C\u0002\u0002r.\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002x\u0006\tYB\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAQCW\r^1TW\u0016$8\r[\u0014tA\r{W\u000e]1di\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:T\u0001\u0005\t\u0011!A\u0001\u0012\u0017\u0010I5oi\u0016\u00148/Z2uS:<\u0007%\u00197mAQDW\r\t+iKR\f\u0007e]6fi\u000eDWm\u001d\u0011j]\u0002\"\b.\u001a\u0011j]B,H\u000fI2pYVlgNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011Q`\u0001\u0002L*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003C\u000f[3uC~\u001b8.\u001a;dQ~+7\u000f^5nCR,\u0007f\u0018$V\u001d\u000e{\u0006f]6fi\u000eD\u0017&\u000b\u0011G%>k\u0005\u0005K*F\u0019\u0016\u001bE\u000b\t;iKR\fwl]6fi\u000eDw,Y4hQ\r|G.\u000b\u0011bg\u0002\u001a8.\u001a;dQ\u00022%kT'!-\u0006cU+R*!QEJ\u0003\u0005^1cQ\r|G.\u000b\u0011V\u001d&{e\nI!M\u0019\u0002\u001aV\tT#D)\u0002\"\b.\u001a;b?N\\W\r^2i?\u0006<w\rK2pY2\u0002#\u0007M\u0015!CN\u00043o[3uG\"\u0004cIU(NAY\u000bE*V#TA!\n\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\r\u0011!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011I!A\u00035]Er\u0003'\u0001\u000bUQ\u0016$\u0018-\u00138uKJ\u001cXm\u0019;j_:\fum\u001a\t\u0003u\t\u001aRA\tB\t\u0005;\u0001\u0002Ba\u0005\u0003\u001a\u0019#G\r\\\u0007\u0003\u0005+Q1Aa\u0006P\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0007\u0003\u0016\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\t}!QE\u0007\u0003\u0005CQAAa\t\u0002:\u0006\u0011\u0011n\\\u0005\u0004;\n\u0005BC\u0001B\u0007\u0003!!xn\u0015;sS:<GCAAY\u0003\u0015\t\u0007\u000f\u001d7z)\u001da'\u0011\u0007B\u001a\u0005kAQaX\u0013A\u0002\u0019CQAY\u0013A\u0002\u0011DQ\u0001[\u0013A\u0002\u0011\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003<\t\u001d\u0003#\u0002(\u0003>\t\u0005\u0013b\u0001B \u001f\n1q\n\u001d;j_:\u0004bA\u0014B\"\r\u0012$\u0017b\u0001B#\u001f\n1A+\u001e9mKNB\u0001B!\u0013'\u0003\u0003\u0005\r\u0001\\\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B(!\u0011\t\u0019L!\u0015\n\t\tM\u0013Q\u0017\u0002\u0007\u001f\nTWm\u0019;")
public class ThetaIntersectionAgg
extends TypedImperativeAggregate<ThetaSketchState>
implements UnaryLike<Expression>,
ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Object, Object>> unapply(ThetaIntersectionAgg x$0) {
        return ThetaIntersectionAgg$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Object, Object>, ThetaIntersectionAgg> tupled() {
        return ThetaIntersectionAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, ThetaIntersectionAgg>>> curried() {
        return ThetaIntersectionAgg$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ThetaIntersectionAgg thetaIntersectionAgg = this;
        synchronized (thetaIntersectionAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public ThetaIntersectionAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ThetaIntersectionAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public ThetaIntersectionAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "theta_intersection_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public ThetaSketchState createAggregationBuffer() {
        return new IntersectionAggregationBuffer(SetOperation.builder().buildIntersection());
    }

    @Override
    public ThetaSketchState update(ThetaSketchState intersectionBuffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v == null) {
            return intersectionBuffer;
        }
        DataType dataType = this.child().dataType();
        if (!BinaryType$.MODULE$.equals(dataType)) {
            throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
        }
        byte[] sketchBytes = (byte[])v;
        CompactSketch inputSketch = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketchBytes, this.prettyName());
        ThetaSketchState thetaSketchState = intersectionBuffer;
        if (!(thetaSketchState instanceof IntersectionAggregationBuffer)) {
            throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
        }
        IntersectionAggregationBuffer intersectionAggregationBuffer = (IntersectionAggregationBuffer)thetaSketchState;
        Intersection existingIntersection = intersectionAggregationBuffer.intersection();
        Intersection intersection = existingIntersection;
        intersection.intersect((Sketch)inputSketch);
        return new IntersectionAggregationBuffer(intersection);
    }

    @Override
    public ThetaSketchState merge(ThetaSketchState intersectionBuffer, ThetaSketchState input) {
        Tuple2 tuple2 = new Tuple2((Object)intersectionBuffer, (Object)input);
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState2 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof IntersectionAggregationBuffer) {
                IntersectionAggregationBuffer intersectionAggregationBuffer = (IntersectionAggregationBuffer)thetaSketchState;
                Intersection intersectLeft = intersectionAggregationBuffer.intersection();
                if (thetaSketchState2 instanceof IntersectionAggregationBuffer) {
                    IntersectionAggregationBuffer intersectionAggregationBuffer2 = (IntersectionAggregationBuffer)thetaSketchState2;
                    Intersection intersectRight = intersectionAggregationBuffer2.intersection();
                    intersectLeft.intersect((Sketch)intersectRight.getResult());
                    return new IntersectionAggregationBuffer(intersectLeft);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState3 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof IntersectionAggregationBuffer) {
                IntersectionAggregationBuffer intersectionAggregationBuffer = (IntersectionAggregationBuffer)thetaSketchState;
                Intersection intersection = intersectionAggregationBuffer.intersection();
                if (thetaSketchState3 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState3;
                    CompactSketch sketch = finalizedSketch.sketch();
                    intersection.intersect((Sketch)sketch);
                    return new IntersectionAggregationBuffer(intersection);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState4 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof FinalizedSketch) {
                FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState;
                CompactSketch sketch1 = finalizedSketch.sketch();
                if (thetaSketchState4 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch2 = (FinalizedSketch)thetaSketchState4;
                    CompactSketch sketch2 = finalizedSketch2.sketch();
                    Intersection intersection = SetOperation.builder().buildIntersection();
                    intersection.intersect((Sketch)sketch1);
                    intersection.intersect((Sketch)sketch2);
                    return new IntersectionAggregationBuffer(intersection);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState5 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof FinalizedSketch) {
                FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState;
                CompactSketch sketch = finalizedSketch.sketch();
                if (thetaSketchState5 instanceof IntersectionAggregationBuffer) {
                    IntersectionAggregationBuffer intersectionAggregationBuffer = (IntersectionAggregationBuffer)thetaSketchState5;
                    Intersection intersection = intersectionAggregationBuffer.intersection();
                    intersection.intersect((Sketch)sketch);
                    return new IntersectionAggregationBuffer(intersection);
                }
            }
        }
        throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
    }

    @Override
    public Object eval(ThetaSketchState sketchState) {
        return sketchState.eval();
    }

    @Override
    public byte[] serialize(ThetaSketchState sketchState) {
        return sketchState.serialize();
    }

    @Override
    public ThetaSketchState deserialize(byte[] buffer) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(buffer))) {
            return new FinalizedSketch(CompactSketch.heapify((Memory)Memory.wrap((byte[])buffer)));
        }
        return this.createAggregationBuffer();
    }

    public ThetaIntersectionAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ThetaIntersectionAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ThetaIntersectionAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaIntersectionAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaIntersectionAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaIntersectionAgg thetaIntersectionAgg = (ThetaIntersectionAgg)x$1;
        if (this.mutableAggBufferOffset() != thetaIntersectionAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != thetaIntersectionAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = thetaIntersectionAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!thetaIntersectionAgg.canEqual(this)) return false;
        return true;
    }

    public ThetaIntersectionAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ThetaIntersectionAgg(Expression child) {
        this(child, 0, 0);
    }
}

