/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

final class StorageFactoryService
implements PersistentService {
    private static final String SERVICE_PROPERTIES_EOF_TOKEN = "#--- last line, don't put anything after this line ---";
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class<?> storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String string, Class clazz) throws StandardException {
        this.subSubProtocol = string;
        this.storageFactoryClass = clazz;
        Object object = StorageFactoryService.getMonitor().getEnvironment();
        if (object instanceof File) {
            File file = (File)object;
            try {
                StorageFile storageFile;
                boolean bl;
                this.home = file.getPath();
                this.canonicalHome = file.getCanonicalPath();
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
                if (this.home != null && (bl = (storageFile = this.rootStorageFactory.newStorageFile(null)).mkdirs())) {
                    storageFile.limitAccessToOwner();
                }
            }
            catch (IOException iOException) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException iOException) {
                throw Monitor.exceptionStartingModule(iOException);
            }
        }
        this.separatorChar = this.rootStorageFactory.getSeparator();
    }

    @Override
    public boolean hasStorageFactory() {
        return true;
    }

    @Override
    public StorageFactory getStorageFactoryInstance(boolean bl, String string, String string2, String string3) throws StandardException, IOException {
        try {
            return this.privGetStorageFactoryInstance(bl, string, string2, string3);
        }
        catch (IOException iOException) {
            throw this.registeredClassInstanceError(iOException);
        }
        catch (InstantiationException instantiationException) {
            throw this.registeredClassInstanceError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.registeredClassInstanceError(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.registeredClassInstanceError(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.registeredClassInstanceError(invocationTargetException);
        }
    }

    private StandardException registeredClassInstanceError(Exception exception) {
        return StandardException.newException((String)"XBM0W.S", (Throwable)exception, (Object[])new Object[]{this.subSubProtocol, this.storageFactoryClass});
    }

    private StorageFactory privGetStorageFactoryInstance(boolean bl, String string, String string2, String string3) throws InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        String string4 = string != null && this.subSubProtocol != null && string.startsWith(this.subSubProtocol + ":") ? string.substring(this.subSubProtocol.length() + 1) : string;
        storageFactory.init(bl ? this.home : null, string4, string2, string3);
        return storageFactory;
    }

    @Override
    public String getType() {
        return this.subSubProtocol;
    }

    @Override
    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServiceProperties(String string, Properties properties) throws StandardException {
        String string2 = this.recreateServiceRoot(string, properties);
        Properties properties2 = new Properties(properties);
        try {
            if (string2 != null) {
                File file = new File(string2, "service.properties");
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    properties2.load(new BufferedInputStream(fileInputStream));
                }
            }
            StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, string, null, null);
            StorageFile storageFile = storageFactory.newStorageFile("service.properties");
            this.resolveServicePropertiesFiles(storageFactory, storageFile);
            try (InputStream inputStream = storageFile.getInputStream();){
                properties2.load(new BufferedInputStream(inputStream));
            }
            finally {
                storageFactory.shutdown();
            }
            return properties2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            throw Monitor.exceptionStartingModule(iOException);
        }
        catch (InstantiationException instantiationException) {
            throw Monitor.exceptionStartingModule(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Monitor.exceptionStartingModule(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Monitor.exceptionStartingModule(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Monitor.exceptionStartingModule(invocationTargetException);
        }
    }

    @Override
    public void saveServiceProperties(String string, StorageFactory storageFactory, Properties properties, boolean bl) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException((String)"XBM0P.D", (Object[])new Object[0]);
        }
        WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        StorageFile storageFile = bl ? writableStorageFactory.newStorageFile("service.properties".concat("old")) : null;
        StorageFile storageFile2 = writableStorageFactory.newStorageFile("service.properties");
        FileOperationHelper fileOperationHelper = new FileOperationHelper();
        if (bl) {
            fileOperationHelper.renameTo(storageFile2, storageFile, true);
        }
        OutputStream outputStream = null;
        try {
            outputStream = storageFile2.getOutputStream();
            properties.store(outputStream, string + MessageService.getTextMessage((String)"M001", (Object[])new Object[0]));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
            bufferedWriter.write(SERVICE_PROPERTIES_EOF_TOKEN);
            bufferedWriter.newLine();
            writableStorageFactory.sync(outputStream, false);
            bufferedWriter.close();
            outputStream.close();
            outputStream = null;
        }
        catch (IOException iOException) {
            if (storageFile != null) {
                fileOperationHelper.renameTo(storageFile, storageFile2, false);
            }
            if (bl) {
                throw StandardException.newException((String)"XBM0B.D", (Throwable)iOException, (Object[])new Object[0]);
            }
            throw Monitor.exceptionStartingModule(iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (storageFile != null && !fileOperationHelper.delete(storageFile, false)) {
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage((String)"M004", (Object[])new Object[]{StorageFactoryService.getMostAccuratePath(storageFile)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataWarningFile(StorageFactory storageFactory) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException((String)"XBM0P.D", (Object[])new Object[0]);
        }
        WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        OutputStreamWriter outputStreamWriter = null;
        try {
            StorageFile storageFile = writableStorageFactory.newStorageFile("README_DO_NOT_TOUCH_FILES.txt");
            outputStreamWriter = new OutputStreamWriter(storageFile.getOutputStream(), "UTF8");
            outputStreamWriter.write(MessageService.getTextMessage((String)"M005", (Object[])new Object[0]));
        }
        catch (IOException iOException) {
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void saveServiceProperties(String string, Properties properties) throws StandardException {
        File file = new File(string, "service.properties");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            FileUtil.limitAccessToOwner(file);
            properties.store(fileOutputStream, string + MessageService.getTextMessage((String)"M001", (Object[])new Object[0]));
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                fileOutputStream = null;
            }
            throw Monitor.exceptionStartingModule(iOException);
        }
    }

    private void resolveServicePropertiesFiles(StorageFactory storageFactory, StorageFile storageFile) throws StandardException {
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties".concat("old"));
        FileOperationHelper fileOperationHelper = new FileOperationHelper();
        boolean bl = fileOperationHelper.exists(storageFile, true);
        boolean bl2 = fileOperationHelper.exists(storageFile2, true);
        if (bl && !bl2) {
            return;
        }
        if (bl2 && !bl) {
            fileOperationHelper.renameTo(storageFile2, storageFile, true);
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage((String)"M002", (Object[])new Object[0]));
        } else if (bl2 && bl) {
            String string;
            BufferedReader bufferedReader = null;
            String string2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(storageFile.getPath()), "ISO-8859-1"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().length() == 0) continue;
                    string2 = string;
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException((String)"XJ113.S", (Throwable)iOException, (Object[])new Object[]{storageFile.getPath(), iOException.getMessage()});
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (string2 != null && string2.startsWith(SERVICE_PROPERTIES_EOF_TOKEN)) {
                string = fileOperationHelper.delete(storageFile2, false) ? MessageService.getTextMessage((String)"M003", (Object[])new Object[0]) : MessageService.getTextMessage((String)"M004", (Object[])new Object[]{StorageFactoryService.getMostAccuratePath(storageFile2)});
                Monitor.getStream().printlnWithHeader(string);
            } else {
                fileOperationHelper.delete(storageFile, false);
                fileOperationHelper.renameTo(storageFile2, storageFile, true);
                Monitor.getStream().printlnWithHeader(MessageService.getTextMessage((String)"M002", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String recreateServiceRoot(String string, Properties properties) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        if (properties == null) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = properties.getProperty("createFrom");
        if (string2 != null) {
            bl = true;
            bl2 = false;
        } else {
            string2 = properties.getProperty("restoreFrom");
            if (string2 != null) {
                bl = true;
                bl2 = true;
            } else {
                string2 = properties.getProperty("rollForwardRecoveryFrom");
                if (string2 != null) {
                    try {
                        object3 = null;
                        object2 = this.privGetStorageFactoryInstance(true, string, null, null);
                        try {
                            object = object2.newStorageFile(null);
                            object3 = object.exists() ? this : null;
                        }
                        finally {
                            object2.shutdown();
                        }
                        if (object3 == null) {
                            bl = true;
                            bl2 = false;
                        }
                    }
                    catch (IOException iOException) {
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw Monitor.exceptionStartingModule(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw Monitor.exceptionStartingModule(illegalAccessException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw Monitor.exceptionStartingModule(noSuchMethodException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw Monitor.exceptionStartingModule(invocationTargetException);
                    }
                }
            }
        }
        if (string2 != null) {
            block32: {
                object3 = new File(string2);
                if (this.fileExists((File)object3)) {
                    object2 = new File(string2, "service.properties");
                    if (this.fileExists((File)object2)) {
                        if (bl) {
                            this.createServiceRoot(string, bl2);
                        }
                        try {
                            object = (WritableStorageFactory)this.privGetStorageFactoryInstance(true, string, null, null);
                            try {
                                StorageFile storageFile = object.newStorageFile("service.properties");
                                if (storageFile.exists() && !storageFile.delete()) {
                                    throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{storageFile});
                                }
                                break block32;
                            }
                            finally {
                                object.shutdown();
                            }
                        }
                        catch (IOException iOException) {
                            throw Monitor.exceptionStartingModule(iOException);
                        }
                        catch (InstantiationException instantiationException) {
                            throw Monitor.exceptionStartingModule(instantiationException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw Monitor.exceptionStartingModule(illegalAccessException);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw Monitor.exceptionStartingModule(noSuchMethodException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw Monitor.exceptionStartingModule(invocationTargetException);
                        }
                    }
                    throw StandardException.newException((String)"XBM0Q.D", (Object[])new Object[]{object2});
                }
                throw StandardException.newException((String)"XBM0Y.D", (Object[])new Object[]{object3});
            }
            properties.put("derby.__rt.inRestore", "True");
            if (bl) {
                properties.put("derby.__rt.deleteRootOnError", "True");
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createServiceRoot(String string, boolean bl) throws StandardException {
        String string2;
        block16: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException((String)"XBM0P.D", (Object[])new Object[0]);
            }
            string2 = null;
            try {
                StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, string, null, null);
                try {
                    StorageFile storageFile = storageFactory.newStorageFile(null);
                    if (storageFile.exists()) {
                        if (bl) {
                            if (!storageFile.deleteAll()) {
                                throw StandardException.newException((String)"XBM0I.D", (Object[])new Object[]{this.getDirectoryPath(string)});
                            }
                        } else {
                            this.vetService(storageFactory, string);
                            throw StandardException.newException((String)"XBM0J.D", (Object[])new Object[]{this.getDirectoryPath(string)});
                        }
                    }
                    if (!storageFile.mkdirs()) break block16;
                    storageFile.limitAccessToOwner();
                    String string3 = storageFile.getCanonicalPath();
                    storageFactory.setCanonicalName(string3);
                    try {
                        string2 = storageFactory.getCanonicalName();
                    }
                    catch (IOException iOException) {
                        storageFile.deleteAll();
                        throw iOException;
                    }
                }
                finally {
                    storageFactory.shutdown();
                }
            }
            catch (IOException iOException) {
                throw this.serviceDirectoryCreateError(iOException, string);
            }
            catch (InstantiationException instantiationException) {
                throw this.serviceDirectoryCreateError(instantiationException, string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.serviceDirectoryCreateError(illegalAccessException, string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw this.serviceDirectoryCreateError(noSuchMethodException, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.serviceDirectoryCreateError(invocationTargetException, string);
            }
        }
        return this.getProtocolLeadIn() + string2;
    }

    private StandardException serviceDirectoryCreateError(Exception exception, String string) {
        return StandardException.newException((String)"XBM0H.D", (Throwable)exception, (Object[])new Object[]{string});
    }

    private void vetService(StorageFactory storageFactory, String string) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties");
        if (!storageFile2.exists() && (storageFile = storageFactory.newStorageFile("seg0")).exists()) {
            throw StandardException.newException((String)"XBM0A.D", (Object[])new Object[]{string, "service.properties"});
        }
    }

    private String getDirectoryPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.home != null) {
            stringBuffer.append(this.home);
            stringBuffer.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            stringBuffer.append(string.replace('/', this.separatorChar));
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeServiceRoot(String string) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            StorageFactoryService storageFactoryService = null;
            StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, string, null, null);
            try {
                StorageFile storageFile = storageFactory.newStorageFile(null);
                storageFactoryService = storageFile.deleteAll() ? this : null;
            }
            finally {
                storageFactory.shutdown();
            }
            return storageFactoryService != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCanonicalServiceName(String string) throws StandardException {
        int n = string.indexOf(58);
        if (n < 2 && !this.getType().equals("directory")) {
            return null;
        }
        if (n > 1) {
            if (!string.startsWith(this.getType() + ":")) {
                return null;
            }
            string = string.substring(n + 1);
        }
        String string2 = string;
        try {
            String string3 = null;
            StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, string2, null, null);
            try {
                string3 = storageFactory.getCanonicalName();
            }
            finally {
                storageFactory.shutdown();
            }
            return this.getProtocolLeadIn() + string3;
        }
        catch (Exception exception) {
            throw Monitor.exceptionStartingModule(exception);
        }
    }

    @Override
    public String getUserServiceName(String string) {
        if (this.home != null && string.length() > this.canonicalHome.length() + 1 && string.startsWith(this.canonicalHome) && (string = string.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            string = string.substring(1);
        }
        return string.replace(this.separatorChar, '/');
    }

    @Override
    public boolean isSameService(String string, String string2) {
        return string.equals(string2);
    }

    private final boolean fileExists(File file) {
        return file.exists();
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    private String getProtocolLeadIn() {
        if (this.getType().equals("directory")) {
            return "";
        }
        return this.getType() + ":";
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static String getMostAccuratePath(StorageFile storageFile) {
        String string = storageFile.getPath();
        try {
            string = storageFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    final class DirectoryList
    implements Enumeration {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            this.run();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return this.run() != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        public final DirectoryList run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile storageFile;
                            String string = this.contents[this.index];
                            StorageFile storageFile2 = StorageFactoryService.this.rootStorageFactory.newStorageFile(string);
                            if (storageFile2.isDirectory() && (storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(storageFile2, "service.properties")).exists()) {
                                this.contents[this.index] = storageFile2.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static class FileOperationHelper {
        private String operation;

        private FileOperationHelper() {
        }

        boolean exists(StorageFile storageFile, boolean bl) throws StandardException {
            this.operation = "exists";
            boolean bl2 = false;
            bl2 = storageFile.exists();
            return bl2;
        }

        boolean delete(StorageFile storageFile, boolean bl) throws StandardException {
            this.operation = "delete";
            boolean bl2 = false;
            bl2 = storageFile.delete();
            if (bl && !bl2) {
                throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{storageFile.getPath()});
            }
            return bl2;
        }

        boolean renameTo(StorageFile storageFile, StorageFile storageFile2, boolean bl) throws StandardException {
            this.operation = "renameTo";
            this.delete(storageFile2, false);
            boolean bl2 = false;
            bl2 = storageFile.renameTo(storageFile2);
            if (bl && !bl2) {
                throw StandardException.newException((String)"XBM0S.D", (Object[])new Object[]{storageFile.getPath(), storageFile2.getPath()});
            }
            return bl2;
        }
    }
}

