/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.select;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    public Elements(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Elements clone() {
        Elements clone = new Elements(this.size());
        for (Element e : this) {
            clone.add(e.clone());
        }
        return clone;
    }

    public String outerHtml() {
        return this.stream().map(Node::outerHtml).collect(StringUtil.joining("\n"));
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Elements remove() {
        for (Element element : this) {
            element.remove();
        }
        return this;
    }

    @Override
    public Element set(int index, Element element) {
        Validate.notNull(element);
        Element old = super.set(index, element);
        old.replaceWith(element);
        return old;
    }

    @Override
    public Element remove(int index) {
        Element old = (Element)super.remove(index);
        old.remove();
        return old;
    }

    @Override
    public boolean remove(Object o) {
        int index = super.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public void clear() {
        this.remove();
        super.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean anyRemoved = false;
        for (Object o : c) {
            anyRemoved |= this.remove(o);
        }
        return anyRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean anyRemoved = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (c.contains(el)) continue;
            it.remove();
            anyRemoved = true;
        }
        return anyRemoved;
    }

    @Override
    public boolean removeIf(Predicate<? super Element> filter) {
        boolean anyRemoved = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!filter.test(el)) continue;
            it.remove();
            anyRemoved = true;
        }
        return anyRemoved;
    }

    @Override
    public void replaceAll(UnaryOperator<Element> operator) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, (Element)operator.apply((Element)this.get(i)));
        }
    }
}

