/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.url;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.expressions.url.ParseUrlEvaluator;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ParseUrlEvaluator$
implements Serializable {
    public static final ParseUrlEvaluator$ MODULE$ = new ParseUrlEvaluator$();
    private static final UTF8String HOST = UTF8String.fromString((String)"HOST");
    private static final UTF8String PATH = UTF8String.fromString((String)"PATH");
    private static final UTF8String org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$QUERY = UTF8String.fromString((String)"QUERY");
    private static final UTF8String REF = UTF8String.fromString((String)"REF");
    private static final UTF8String PROTOCOL = UTF8String.fromString((String)"PROTOCOL");
    private static final UTF8String FILE = UTF8String.fromString((String)"FILE");
    private static final UTF8String AUTHORITY = UTF8String.fromString((String)"AUTHORITY");
    private static final UTF8String USERINFO = UTF8String.fromString((String)"USERINFO");
    private static final String REGEXPREFIX = "(&|^)";
    private static final String REGEXSUBFIX = "=([^&]*)";

    private UTF8String HOST() {
        return HOST;
    }

    private UTF8String PATH() {
        return PATH;
    }

    public UTF8String org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$QUERY() {
        return org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$QUERY;
    }

    private UTF8String REF() {
        return REF;
    }

    private UTF8String PROTOCOL() {
        return PROTOCOL;
    }

    private UTF8String FILE() {
        return FILE;
    }

    private UTF8String AUTHORITY() {
        return AUTHORITY;
    }

    private UTF8String USERINFO() {
        return USERINFO;
    }

    private String REGEXPREFIX() {
        return REGEXPREFIX;
    }

    private String REGEXSUBFIX() {
        return REGEXSUBFIX;
    }

    public Pattern org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$getPattern(UTF8String key) {
        return Pattern.compile(this.REGEXPREFIX() + key.toString() + this.REGEXSUBFIX());
    }

    public URI org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$getUrl(UTF8String url, boolean failOnError) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (failOnError) {
                throw QueryExecutionErrors$.MODULE$.invalidUrlError(url, uRISyntaxException);
            }
            uRI = null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return uRI;
    }

    public Function1<URI, String> org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$getExtractPartFunc(UTF8String partToExtract) {
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = this.HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            return (Function1 & Serializable)x$1 -> x$1.getHost();
        }
        UTF8String uTF8String4 = this.PATH();
        UTF8String uTF8String5 = uTF8String;
        if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
            return (Function1 & Serializable)x$2 -> x$2.getRawPath();
        }
        UTF8String uTF8String6 = this.org$apache$spark$sql$catalyst$expressions$url$ParseUrlEvaluator$$QUERY();
        UTF8String uTF8String7 = uTF8String;
        if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
            return (Function1 & Serializable)x$3 -> x$3.getRawQuery();
        }
        UTF8String uTF8String8 = this.REF();
        UTF8String uTF8String9 = uTF8String;
        if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
            return (Function1 & Serializable)x$4 -> x$4.getRawFragment();
        }
        UTF8String uTF8String10 = this.PROTOCOL();
        UTF8String uTF8String11 = uTF8String;
        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
            return (Function1 & Serializable)x$5 -> x$5.getScheme();
        }
        UTF8String uTF8String12 = this.FILE();
        UTF8String uTF8String13 = uTF8String;
        if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
            return (Function1 & Serializable)url -> {
                if (url.getRawQuery() != null) {
                    return url.getRawPath() + "?" + url.getRawQuery();
                }
                return url.getRawPath();
            };
        }
        UTF8String uTF8String14 = this.AUTHORITY();
        UTF8String uTF8String15 = uTF8String;
        if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
            return (Function1 & Serializable)x$6 -> x$6.getRawAuthority();
        }
        UTF8String uTF8String16 = this.USERINFO();
        UTF8String uTF8String17 = uTF8String;
        if (!(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null)) {
            return (Function1 & Serializable)x$7 -> x$7.getRawUserInfo();
        }
        return (Function1 & Serializable)x$8 -> null;
    }

    public ParseUrlEvaluator apply(UTF8String url, UTF8String extractPart, UTF8String pattern, boolean failOnError) {
        return new ParseUrlEvaluator(url, extractPart, pattern, failOnError);
    }

    public Option<Tuple4<UTF8String, UTF8String, UTF8String, Object>> unapply(ParseUrlEvaluator x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.url(), (Object)x$0.extractPart(), (Object)x$0.pattern(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.failOnError())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ParseUrlEvaluator$.class);
    }

    private ParseUrlEvaluator$() {
    }
}

