/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.execution.streaming.state.AvroStateEncoder;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBDataEncoder;
import org.apache.spark.sql.execution.streaming.state.StateRowEncoderCacheKey;
import org.apache.spark.sql.execution.streaming.state.StateSchemaInfo;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomSizeMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomSumMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomTimingMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreEncoding$Avro$;
import org.apache.spark.sql.execution.streaming.state.StateStoreSnapshotLastUploadInstanceMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreSnapshotLastUploadInstanceMetric$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowDataEncoder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.NonFateSharingCache;
import org.apache.spark.util.NonFateSharingCache$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class RocksDBStateStoreProvider$ {
    public static final RocksDBStateStoreProvider$ MODULE$ = new RocksDBStateStoreProvider$();
    private static final int STATE_ENCODING_NUM_VERSION_BYTES = 1;
    private static final byte STATE_ENCODING_VERSION = 0;
    private static final int VIRTUAL_COL_FAMILY_PREFIX_BYTES = 2;
    private static final int SCHEMA_ID_PREFIX_BYTES = 2;
    private static final int MAX_AVRO_ENCODERS_IN_CACHE = 1000;
    private static final long AVRO_ENCODER_LIFETIME_HOURS = 1L;
    private static final StateSchemaInfo DEFAULT_SCHEMA_IDS = new StateSchemaInfo(0, 0);
    private static final NonFateSharingCache<StateRowEncoderCacheKey, RocksDBDataEncoder> dataEncoderCache = NonFateSharingCache$.MODULE$.apply((long)MODULE$.MAX_AVRO_ENCODERS_IN_CACHE(), MODULE$.AVRO_ENCODER_LIFETIME_HOURS(), TimeUnit.HOURS);
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_GET_TIME = new StateStoreCustomTimingMetric("rocksdbGetLatency", "RocksDB: total get call latency");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_PUT_TIME = new StateStoreCustomTimingMetric("rocksdbPutLatency", "RocksDB: total put call latency");
    private static final StateStoreCustomSumMetric CUSTOM_METRIC_GET_COUNT = new StateStoreCustomSumMetric("rocksdbGetCount", "RocksDB: number of get calls");
    private static final StateStoreCustomSumMetric CUSTOM_METRIC_PUT_COUNT = new StateStoreCustomSumMetric("rocksdbPutCount", "RocksDB: number of put calls");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_FLUSH_TIME = new StateStoreCustomTimingMetric("rocksdbCommitFlushLatency", "RocksDB: commit - flush time");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_COMMIT_COMPACT_TIME = new StateStoreCustomTimingMetric("rocksdbCommitCompactLatency", "RocksDB: commit - compact time");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_CHECKPOINT_TIME = new StateStoreCustomTimingMetric("rocksdbCommitCheckpointLatency", "RocksDB: commit - checkpoint time");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_FILESYNC_TIME = new StateStoreCustomTimingMetric("rocksdbCommitFileSyncLatencyMs", "RocksDB: commit - file sync to external storage time");
    private static final StateStoreCustomSumMetric CUSTOM_METRIC_FILES_COPIED = new StateStoreCustomSumMetric("rocksdbFilesCopied", "RocksDB: file manager - files copied");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_BYTES_COPIED = new StateStoreCustomSizeMetric("rocksdbBytesCopied", "RocksDB: file manager - bytes copied");
    private static final StateStoreCustomSumMetric CUSTOM_METRIC_FILES_REUSED = new StateStoreCustomSumMetric("rocksdbFilesReused", "RocksDB: file manager - files reused");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_ZIP_FILE_BYTES_UNCOMPRESSED = new StateStoreCustomSizeMetric("rocksdbZipFileBytesUncompressed", "RocksDB: file manager - uncompressed zip file bytes");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_CHANGE_LOG_WRITER_COMMIT_TIME = new StateStoreCustomTimingMetric("rocksdbChangeLogWriterCommitLatencyMs", "RocksDB: commit - changelog commit time");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_SAVE_ZIP_FILES_TIME = new StateStoreCustomTimingMetric("rocksdbSaveZipFilesLatencyMs", "RocksDB: commit - zip files sync to external storage time");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_LOAD_FROM_SNAPSHOT_TIME = new StateStoreCustomTimingMetric("rocksdbLoadFromSnapshotLatencyMs", "RocksDB: load from snapshot - time taken to load the store from snapshot");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_LOAD_TIME = new StateStoreCustomTimingMetric("rocksdbLoadLatencyMs", "RocksDB: load - time taken to load the store");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_REPLAY_CHANGE_LOG = new StateStoreCustomTimingMetric("rocksdbReplayChangeLogLatencyMs", "RocksDB: load - time taken to replay the change log");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_REPLAY_CHANGE_LOG_FILES = new StateStoreCustomSizeMetric("rocksdbNumReplayChangelogFiles", "RocksDB: load - number of change log files replayed");
    private static final StateStoreCustomSumMetric CUSTOM_METRIC_BLOCK_CACHE_MISS = new StateStoreCustomSumMetric("rocksdbReadBlockCacheMissCount", "RocksDB: read - count of cache misses that required reading from local disk");
    private static final StateStoreCustomSumMetric CUSTOM_METRIC_BLOCK_CACHE_HITS = new StateStoreCustomSumMetric("rocksdbReadBlockCacheHitCount", "RocksDB: read - count of cache hits in RocksDB block cache avoiding disk read");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_BYTES_READ = new StateStoreCustomSizeMetric("rocksdbTotalBytesRead", "RocksDB: read - total of uncompressed bytes read (from memtables/cache/sst) from DB::Get()");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_BYTES_WRITTEN = new StateStoreCustomSizeMetric("rocksdbTotalBytesWritten", "RocksDB: write - total of uncompressed bytes written by DB::{Put(), Delete(), Merge(), Write()}");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_ITERATOR_BYTES_READ = new StateStoreCustomSizeMetric("rocksdbTotalBytesReadThroughIterator", "RocksDB: read - total of uncompressed bytes read using an iterator");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_STALL_TIME = new StateStoreCustomTimingMetric("rocksdbWriterStallLatencyMs", "RocksDB: write - writer wait time for compaction or flush to finish");
    private static final StateStoreCustomTimingMetric CUSTOM_METRIC_TOTAL_COMPACT_TIME = new StateStoreCustomTimingMetric("rocksdbTotalCompactionLatencyMs", "RocksDB: compaction - total compaction time including background");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_COMPACT_READ_BYTES = new StateStoreCustomSizeMetric("rocksdbTotalBytesReadByCompaction", "RocksDB: compaction - total bytes read by the compaction process");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_COMPACT_WRITTEN_BYTES = new StateStoreCustomSizeMetric("rocksdbTotalBytesWrittenByCompaction", "RocksDB: compaction - total bytes written by the compaction process");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_FLUSH_WRITTEN_BYTES = new StateStoreCustomSizeMetric("rocksdbTotalBytesWrittenByFlush", "RocksDB: flush - total bytes written by flush");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_PINNED_BLOCKS_MEM_USAGE = new StateStoreCustomSizeMetric("rocksdbPinnedBlocksMemoryUsage", "RocksDB: memory usage for pinned blocks");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES_KEYS = new StateStoreCustomSizeMetric("rocksdbNumInternalColFamiliesKeys", "RocksDB: number of internal keys for internal column families");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_EXTERNAL_COL_FAMILIES = new StateStoreCustomSizeMetric("rocksdbNumExternalColumnFamilies", "RocksDB: number of external column families");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES = new StateStoreCustomSizeMetric("rocksdbNumInternalColumnFamilies", "RocksDB: number of internal column families");
    private static final StateStoreCustomSizeMetric CUSTOM_METRIC_SST_FILE_SIZE = new StateStoreCustomSizeMetric("rocksdbSstFileSize", "RocksDB: size of all SST files");
    private static final Seq<Product> ALL_CUSTOM_METRICS = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{MODULE$.CUSTOM_METRIC_SST_FILE_SIZE(), MODULE$.CUSTOM_METRIC_GET_TIME(), MODULE$.CUSTOM_METRIC_PUT_TIME(), MODULE$.CUSTOM_METRIC_FLUSH_TIME(), MODULE$.CUSTOM_METRIC_COMMIT_COMPACT_TIME(), MODULE$.CUSTOM_METRIC_CHECKPOINT_TIME(), MODULE$.CUSTOM_METRIC_FILESYNC_TIME(), MODULE$.CUSTOM_METRIC_BYTES_COPIED(), MODULE$.CUSTOM_METRIC_FILES_COPIED(), MODULE$.CUSTOM_METRIC_FILES_REUSED(), MODULE$.CUSTOM_METRIC_ZIP_FILE_BYTES_UNCOMPRESSED(), MODULE$.CUSTOM_METRIC_CHANGE_LOG_WRITER_COMMIT_TIME(), MODULE$.CUSTOM_METRIC_SAVE_ZIP_FILES_TIME(), MODULE$.CUSTOM_METRIC_GET_COUNT(), MODULE$.CUSTOM_METRIC_PUT_COUNT(), MODULE$.CUSTOM_METRIC_BLOCK_CACHE_MISS(), MODULE$.CUSTOM_METRIC_BLOCK_CACHE_HITS(), MODULE$.CUSTOM_METRIC_BYTES_READ(), MODULE$.CUSTOM_METRIC_BYTES_WRITTEN(), MODULE$.CUSTOM_METRIC_ITERATOR_BYTES_READ(), MODULE$.CUSTOM_METRIC_STALL_TIME(), MODULE$.CUSTOM_METRIC_TOTAL_COMPACT_TIME(), MODULE$.CUSTOM_METRIC_COMPACT_READ_BYTES(), MODULE$.CUSTOM_METRIC_COMPACT_WRITTEN_BYTES(), MODULE$.CUSTOM_METRIC_FLUSH_WRITTEN_BYTES(), MODULE$.CUSTOM_METRIC_PINNED_BLOCKS_MEM_USAGE(), MODULE$.CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES_KEYS(), MODULE$.CUSTOM_METRIC_NUM_EXTERNAL_COL_FAMILIES(), MODULE$.CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES(), MODULE$.CUSTOM_METRIC_LOAD_FROM_SNAPSHOT_TIME(), MODULE$.CUSTOM_METRIC_LOAD_TIME(), MODULE$.CUSTOM_METRIC_REPLAY_CHANGE_LOG(), MODULE$.CUSTOM_METRIC_NUM_REPLAY_CHANGE_LOG_FILES()}));
    private static final StateStoreSnapshotLastUploadInstanceMetric CUSTOM_INSTANCE_METRIC_SNAPSHOT_LAST_UPLOADED = new StateStoreSnapshotLastUploadInstanceMetric(StateStoreSnapshotLastUploadInstanceMetric$.MODULE$.apply$default$1(), StateStoreSnapshotLastUploadInstanceMetric$.MODULE$.apply$default$2());
    private static final Seq<StateStoreSnapshotLastUploadInstanceMetric> ALL_INSTANCE_METRICS = new .colon.colon((Object)MODULE$.CUSTOM_INSTANCE_METRIC_SNAPSHOT_LAST_UPLOADED(), (List)Nil$.MODULE$);

    public int STATE_ENCODING_NUM_VERSION_BYTES() {
        return STATE_ENCODING_NUM_VERSION_BYTES;
    }

    public byte STATE_ENCODING_VERSION() {
        return STATE_ENCODING_VERSION;
    }

    public int VIRTUAL_COL_FAMILY_PREFIX_BYTES() {
        return VIRTUAL_COL_FAMILY_PREFIX_BYTES;
    }

    public int SCHEMA_ID_PREFIX_BYTES() {
        return SCHEMA_ID_PREFIX_BYTES;
    }

    private int MAX_AVRO_ENCODERS_IN_CACHE() {
        return MAX_AVRO_ENCODERS_IN_CACHE;
    }

    private long AVRO_ENCODER_LIFETIME_HOURS() {
        return AVRO_ENCODER_LIFETIME_HOURS;
    }

    private StateSchemaInfo DEFAULT_SCHEMA_IDS() {
        return DEFAULT_SCHEMA_IDS;
    }

    public byte[] getColumnFamilyIdAsBytes(short virtualColFamilyId) {
        byte[] encodedBytes = new byte[this.VIRTUAL_COL_FAMILY_PREFIX_BYTES()];
        Platform.putShort((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (short)virtualColFamilyId);
        return encodedBytes;
    }

    public byte[] encodeStateRowWithPrefix(byte[] data, short vcfId) {
        byte[] result = new byte[this.VIRTUAL_COL_FAMILY_PREFIX_BYTES() + data.length];
        int offset = Platform.BYTE_ARRAY_OFFSET + this.VIRTUAL_COL_FAMILY_PREFIX_BYTES();
        Platform.putShort((Object)result, (long)Platform.BYTE_ARRAY_OFFSET, (short)vcfId);
        Platform.copyMemory((Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (Object)result, (long)offset, (long)data.length);
        return result;
    }

    public short getColumnFamilyBytesAsId(byte[] data) {
        return Platform.getShort((Object)data, (long)Platform.BYTE_ARRAY_OFFSET);
    }

    public byte[] decodeStateRowWithPrefix(byte[] data) {
        int offset = Platform.BYTE_ARRAY_OFFSET + this.VIRTUAL_COL_FAMILY_PREFIX_BYTES();
        byte[] key = new byte[data.length - this.VIRTUAL_COL_FAMILY_PREFIX_BYTES()];
        Platform.copyMemory((Object)data, (long)offset, (Object)key, (long)Platform.BYTE_ARRAY_OFFSET, (long)key.length);
        return key;
    }

    private NonFateSharingCache<StateRowEncoderCacheKey, RocksDBDataEncoder> dataEncoderCache() {
        return dataEncoderCache;
    }

    public RocksDBDataEncoder getDataEncoder(String stateStoreEncoding, StateRowEncoderCacheKey encoderCacheKey, KeyStateEncoderSpec keyStateEncoderSpec, StructType valueSchema, Option<StateSchemaProvider> stateSchemaProvider, Option<String> columnFamilyName) {
        Predef$.MODULE$.assert(((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"avro", "unsaferow"}))).contains((Object)stateStoreEncoding));
        return (RocksDBDataEncoder)this.dataEncoderCache().get((Object)encoderCacheKey, (Callable)new Callable<RocksDBDataEncoder>(stateStoreEncoding, columnFamilyName, keyStateEncoderSpec, valueSchema, stateSchemaProvider){
            private final String stateStoreEncoding$1;
            private final Option columnFamilyName$1;
            private final KeyStateEncoderSpec keyStateEncoderSpec$1;
            private final StructType valueSchema$1;
            private final Option stateSchemaProvider$1;

            public RocksDBDataEncoder call() {
                String string = this.stateStoreEncoding$1;
                String string2 = StateStoreEncoding$Avro$.MODULE$.toString();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Predef$.MODULE$.assert(this.columnFamilyName$1.isDefined(), (Function0 & Serializable)() -> "Column family name must be defined for Avro encoding");
                    return new AvroStateEncoder(this.keyStateEncoderSpec$1, this.valueSchema$1, (Option<StateSchemaProvider>)this.stateSchemaProvider$1, (String)this.columnFamilyName$1.get());
                }
                return new UnsafeRowDataEncoder(this.keyStateEncoderSpec$1, this.valueSchema$1);
            }
            {
                this.stateStoreEncoding$1 = stateStoreEncoding$1;
                this.columnFamilyName$1 = columnFamilyName$1;
                this.keyStateEncoderSpec$1 = keyStateEncoderSpec$1;
                this.valueSchema$1 = valueSchema$1;
                this.stateSchemaProvider$1 = stateSchemaProvider$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1()}, serializedLambda);
            }
        });
    }

    public Option<String> getDataEncoder$default$6() {
        return None$.MODULE$;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_GET_TIME() {
        return CUSTOM_METRIC_GET_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_PUT_TIME() {
        return CUSTOM_METRIC_PUT_TIME;
    }

    public StateStoreCustomSumMetric CUSTOM_METRIC_GET_COUNT() {
        return CUSTOM_METRIC_GET_COUNT;
    }

    public StateStoreCustomSumMetric CUSTOM_METRIC_PUT_COUNT() {
        return CUSTOM_METRIC_PUT_COUNT;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_FLUSH_TIME() {
        return CUSTOM_METRIC_FLUSH_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_COMMIT_COMPACT_TIME() {
        return CUSTOM_METRIC_COMMIT_COMPACT_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_CHECKPOINT_TIME() {
        return CUSTOM_METRIC_CHECKPOINT_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_FILESYNC_TIME() {
        return CUSTOM_METRIC_FILESYNC_TIME;
    }

    public StateStoreCustomSumMetric CUSTOM_METRIC_FILES_COPIED() {
        return CUSTOM_METRIC_FILES_COPIED;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_BYTES_COPIED() {
        return CUSTOM_METRIC_BYTES_COPIED;
    }

    public StateStoreCustomSumMetric CUSTOM_METRIC_FILES_REUSED() {
        return CUSTOM_METRIC_FILES_REUSED;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_ZIP_FILE_BYTES_UNCOMPRESSED() {
        return CUSTOM_METRIC_ZIP_FILE_BYTES_UNCOMPRESSED;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_CHANGE_LOG_WRITER_COMMIT_TIME() {
        return CUSTOM_METRIC_CHANGE_LOG_WRITER_COMMIT_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_SAVE_ZIP_FILES_TIME() {
        return CUSTOM_METRIC_SAVE_ZIP_FILES_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_LOAD_FROM_SNAPSHOT_TIME() {
        return CUSTOM_METRIC_LOAD_FROM_SNAPSHOT_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_LOAD_TIME() {
        return CUSTOM_METRIC_LOAD_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_REPLAY_CHANGE_LOG() {
        return CUSTOM_METRIC_REPLAY_CHANGE_LOG;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_REPLAY_CHANGE_LOG_FILES() {
        return CUSTOM_METRIC_NUM_REPLAY_CHANGE_LOG_FILES;
    }

    public StateStoreCustomSumMetric CUSTOM_METRIC_BLOCK_CACHE_MISS() {
        return CUSTOM_METRIC_BLOCK_CACHE_MISS;
    }

    public StateStoreCustomSumMetric CUSTOM_METRIC_BLOCK_CACHE_HITS() {
        return CUSTOM_METRIC_BLOCK_CACHE_HITS;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_BYTES_READ() {
        return CUSTOM_METRIC_BYTES_READ;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_BYTES_WRITTEN() {
        return CUSTOM_METRIC_BYTES_WRITTEN;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_ITERATOR_BYTES_READ() {
        return CUSTOM_METRIC_ITERATOR_BYTES_READ;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_STALL_TIME() {
        return CUSTOM_METRIC_STALL_TIME;
    }

    public StateStoreCustomTimingMetric CUSTOM_METRIC_TOTAL_COMPACT_TIME() {
        return CUSTOM_METRIC_TOTAL_COMPACT_TIME;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_COMPACT_READ_BYTES() {
        return CUSTOM_METRIC_COMPACT_READ_BYTES;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_COMPACT_WRITTEN_BYTES() {
        return CUSTOM_METRIC_COMPACT_WRITTEN_BYTES;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_FLUSH_WRITTEN_BYTES() {
        return CUSTOM_METRIC_FLUSH_WRITTEN_BYTES;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_PINNED_BLOCKS_MEM_USAGE() {
        return CUSTOM_METRIC_PINNED_BLOCKS_MEM_USAGE;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES_KEYS() {
        return CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES_KEYS;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_EXTERNAL_COL_FAMILIES() {
        return CUSTOM_METRIC_NUM_EXTERNAL_COL_FAMILIES;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES() {
        return CUSTOM_METRIC_NUM_INTERNAL_COL_FAMILIES;
    }

    public StateStoreCustomSizeMetric CUSTOM_METRIC_SST_FILE_SIZE() {
        return CUSTOM_METRIC_SST_FILE_SIZE;
    }

    public Seq<Product> ALL_CUSTOM_METRICS() {
        return ALL_CUSTOM_METRICS;
    }

    public StateStoreSnapshotLastUploadInstanceMetric CUSTOM_INSTANCE_METRIC_SNAPSHOT_LAST_UPLOADED() {
        return CUSTOM_INSTANCE_METRIC_SNAPSHOT_LAST_UPLOADED;
    }

    public Seq<StateStoreSnapshotLastUploadInstanceMetric> ALL_INSTANCE_METRICS() {
        return ALL_INSTANCE_METRICS;
    }

    private RocksDBStateStoreProvider$() {
    }
}

