/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!B\n\u0015\u0001Yq\u0002\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011!\u0003!1!Q\u0001\f%CQa\u0014\u0001\u0005\u0002ACq!\u0016\u0001C\u0002\u0013Ea\u000b\u0003\u0004d\u0001\u0001\u0006Ia\u0016\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0011\u001dy\u0007\u00011A\u0005\nADaA\u001e\u0001!B\u00131\u0007bB>\u0001\u0001\u0004%I\u0001 \u0005\b}\u0002\u0001\r\u0011\"\u0003\u0000\u0011\u001d\t\u0019\u0001\u0001Q!\nuDq!a\u0002\u0001\t#1R\rC\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013\u0012Q\u0003R*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018M\u0003\u0002\u0016-\u00059Am\u001d;sK\u0006l'BA\f\u0019\u0003%\u0019HO]3b[&twM\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h+\tyrh\u0005\u0003\u0001A\u0019\u001a\u0004CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(a9\u0011\u0001F\f\b\u0003S5j\u0011A\u000b\u0006\u0003W1\na\u0001\u0010:p_Rt4\u0001A\u0005\u0002G%\u0011qFI\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$G\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00020EA\u0011AgN\u0007\u0002k)\u0011a\u0007G\u0001\tS:$XM\u001d8bY&\u0011\u0001(\u000e\u0002\b\u0019><w-\u001b8h!\rQ4(P\u0007\u0002)%\u0011A\b\u0006\u0002\b\tN#(/Z1n!\tqt\b\u0004\u0001\u0005\u000b\u0001\u0003!\u0019A!\u0003\u0003Q\u000b\"AQ#\u0011\u0005\u0005\u001a\u0015B\u0001##\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\t$\n\u0005\u001d\u0013#aA!os\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007)kU(D\u0001L\u0015\ta%%A\u0004sK\u001adWm\u0019;\n\u00059[%\u0001C\"mCN\u001cH+Y4\u0002\rqJg.\u001b;?)\t\tF\u000b\u0006\u0002S'B\u0019!\bA\u001f\t\u000b!\u001b\u00019A%\t\u000bU\u0019\u0001\u0019A\u001d\u0002\t\u0011\fG/Y\u000b\u0002/B!\u0001,X0!\u001b\u0005I&B\u0001.\\\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0018\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002_3\n9\u0001*Y:i\u001b\u0006\u0004\bC\u00011b\u001b\u00051\u0012B\u00012\u0017\u0005\u0011!\u0016.\\3\u0002\u000b\u0011\fG/\u0019\u0011\u0002)QLW.\u001a+p\u0007\",7m\u001b9pS:$h)\u001b7f+\u00051\u0007\u0003\u0002-^?\u001e\u0004\"\u0001\u001b7\u000f\u0005%T\u0007CA\u0015#\u0013\tY'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6#\u0003a!\u0018.\\3U_\u000eCWmY6q_&tGOR5mK~#S-\u001d\u000b\u0003cR\u0004\"!\t:\n\u0005M\u0014#\u0001B+oSRDq!^\u0004\u0002\u0002\u0003\u0007a-A\u0002yIE\nQ\u0003^5nKR{7\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005\u000b\u0002\tqB\u0011\u0011%_\u0005\u0003u\n\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002=QLW.\u001a+p\u001f2$Wm\u001d;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3US6,W#A?\u0011\takvlX\u0001#i&lW\rV8PY\u0012,7\u000f^\"iK\u000e\\\u0007o\\5oi\u001aKG.\u001a+j[\u0016|F%Z9\u0015\u0007E\f\t\u0001C\u0004v\u0015\u0005\u0005\t\u0019A?\u0002?QLW.\u001a+p\u001f2$Wm\u001d;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3US6,\u0007\u0005\u000b\u0002\fq\u000612-\u001e:sK:$8\t[3dWB|\u0017N\u001c;GS2,7/\u0001\u0004va\u0012\fG/\u001a\u000b\u0004c\u00065\u0001BBA\b\u001b\u0001\u0007q,\u0001\u0003uS6,\u0017aB2mK\u0006tW\u000f\u001d\u000b\u0004c\u0006U\u0001BBA\b\u001d\u0001\u0007q,A\u0004sKN$xN]3\u0015\u0003E\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002O\u0006YqO]5uK>\u0013'.Z2u)\r\t\u00181\u0005\u0005\b\u0003K\t\u0002\u0019AA\u0014\u0003\rywn\u001d\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\tIwN\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\u0011\t)$a\u000b\u0003%=\u0013'.Z2u\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0015\u0006#\u0005e\u0012Q\t\t\u0006C\u0005m\u0012qH\u0005\u0004\u0003{\u0011#A\u0002;ie><8\u000f\u0005\u0003\u0002*\u0005\u0005\u0013\u0002BA\"\u0003W\u00111\"S(Fq\u000e,\u0007\u000f^5p]\u000e\u0012\u0011qH\u0001\u000be\u0016\fGm\u00142kK\u000e$HcA9\u0002L!9\u0011Q\n\nA\u0002\u0005=\u0013aA8jgB!\u0011\u0011FA)\u0013\u0011\t\u0019&a\u000b\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW\u000eK\u0003\u0013\u0003s\t)\u0005")
public class DStreamCheckpointData<T>
implements Serializable,
Logging {
    private final DStream<T> dstream;
    private final ClassTag<T> evidence$1;
    private final HashMap<Time, Object> data;
    private transient HashMap<Time, String> timeToCheckpointFile;
    private transient HashMap<Time, Time> timeToOldestCheckpointFileTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashMap<Time, Object> data() {
        return this.data;
    }

    private HashMap<Time, String> timeToCheckpointFile() {
        return this.timeToCheckpointFile;
    }

    private void timeToCheckpointFile_$eq(HashMap<Time, String> x$1) {
        this.timeToCheckpointFile = x$1;
    }

    private HashMap<Time, Time> timeToOldestCheckpointFileTime() {
        return this.timeToOldestCheckpointFileTime;
    }

    private void timeToOldestCheckpointFileTime_$eq(HashMap<Time, Time> x$1) {
        this.timeToOldestCheckpointFileTime = x$1;
    }

    public HashMap<Time, String> currentCheckpointFiles() {
        return this.data();
    }

    public void update(Time time) {
        HashMap checkpointFiles = (HashMap)((StrictOptimizedMapOps)this.dstream.generatedRDDs().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointData.$anonfun$update$1(x$1)))).map((Function1 & Serializable)x -> new Tuple2(x._1(), ((RDD)x._2()).getCheckpointFile().get()));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Current checkpoint files:\n" + checkpointFiles.toSeq().mkString("\n"));
        if (!checkpointFiles.isEmpty()) {
            this.currentCheckpointFiles().clear();
            this.currentCheckpointFiles().$plus$plus$eq((IterableOnce)checkpointFiles);
            this.timeToCheckpointFile().$plus$plus$eq(this.currentCheckpointFiles());
            this.timeToOldestCheckpointFileTime().update((Object)time, this.currentCheckpointFiles().keys().min(Time$.MODULE$.ordering()));
            return;
        }
    }

    public void cleanup(Time time) {
        Option option = this.timeToOldestCheckpointFileTime().remove((Object)time);
        if (option instanceof Some) {
            Some some = (Some)option;
            Time lastCheckpointFileTime = (Time)some.value();
            HashMap filesToDelete = (HashMap)this.timeToCheckpointFile().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointData.$anonfun$cleanup$1(lastCheckpointFileTime, x$2)));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Files to delete:\n" + filesToDelete.mkString(","));
            ObjectRef fileSystem = ObjectRef.create(null);
            filesToDelete.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Time time = (Time)tuple2._1();
                    String file = (String)tuple2._2();
                    try {
                        Path path = new Path(file);
                        if ((FileSystem)fileSystem$1.elem == null) {
                            fileSystem$1.elem = path.getFileSystem($this.dstream.ssc().sparkContext().hadoopConfiguration());
                        }
                        if (((FileSystem)fileSystem$1.elem).delete(path, true)) {
                            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted checkpoint file ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.FILE_NAME, file)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for time ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIME, time)})))));
                        } else {
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting old checkpoint file '", "' for time "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, file)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIME, time)})))));
                        }
                        boxedUnit = this.timeToCheckpointFile().$minus$eq((Object)time);
                    }
                    catch (Exception e) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting old checkpoint file '", "' for time "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, file)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIME, time)})))), (Throwable)e);
                        fileSystem$1.elem = null;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Nothing to delete");
            return;
        }
        throw new MatchError((Object)option);
    }

    public void restore() {
        this.currentCheckpointFiles().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Time time = (Time)tuple2._1();
                String file = (String)tuple2._2();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring checkpointed RDD for time ", " from file "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIME, time)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.FILE_NAME, file)})))));
                return (HashMap)$this.dstream.generatedRDDs().$plus$eq((Object)new Tuple2((Object)time, (Object)$this.dstream.context().sparkContext().checkpointFile(file, $this.evidence$1)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String toString() {
        return "[\n" + this.currentCheckpointFiles().size() + " checkpoint files \n" + this.currentCheckpointFiles().mkString("\n") + "\n]";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> this.getClass().getSimpleName() + ".writeObject used");
            if ($this.dstream.context().graph() != null) {
                DStreamGraph dStreamGraph = $this.dstream.context().graph();
                synchronized (dStreamGraph) {
                    if (!$this.dstream.context().graph().checkpointInProgress()) {
                        String msg = "Object of " + this.getClass().getName() + " is being serialized  possibly as a part of closure of an RDD operation. This is because  the DStream object is being referred to from within the closure.  Please rewrite the RDD operation inside this DStream to avoid this.  This has been enforced to avoid bloating of Spark tasks  with unnecessary objects.";
                        throw new NotSerializableException(msg);
                    }
                    oos.defaultWriteObject();
                }
                return;
            }
            throw new NotSerializableException("Graph is unexpectedly null when DStream is being serialized.");
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> this.getClass().getSimpleName() + ".readObject used");
            ois.defaultReadObject();
            this.timeToOldestCheckpointFileTime_$eq((HashMap<Time, Time>)new HashMap());
            this.timeToCheckpointFile_$eq((HashMap<Time, String>)new HashMap());
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Tuple2 x$1) {
        return ((RDD)x$1._2()).getCheckpointFile().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$cleanup$1(Time lastCheckpointFileTime$1, Tuple2 x$2) {
        return ((Time)x$2._1()).$less(lastCheckpointFileTime$1);
    }

    public DStreamCheckpointData(DStream<T> dstream, ClassTag<T> evidence$1) {
        this.dstream = dstream;
        this.evidence$1 = evidence$1;
        Logging.$init$((Logging)this);
        this.data = new HashMap();
        this.timeToCheckpointFile = new HashMap();
        this.timeToOldestCheckpointFileTime = new HashMap();
    }
}

