/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.xml;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.xml.XmlDataSource;
import org.apache.spark.sql.execution.datasources.xml.XmlDataSource$;
import org.apache.spark.sql.execution.datasources.xml.XmlOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\u0007\u000e\u0001qAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1BQA\u000f\u0001\u0005\u0002mBQA\u0014\u0001\u0005B=CQ!\u0019\u0001\u0005B\tDQ\u0001 \u0001\u0005BuDq!a\u0007\u0001\t\u0003\ni\u0002\u0003\u0004\u0002d\u0001!\t\u0005\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\ty\u0007\u0001C!\u0003cBq!! \u0001\t\u0003\nyHA\u0007Y[24\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u001d=\t1\u0001_7m\u0015\t\u0001\u0012#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\n\u0014\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\u0005\u0002\"AH\u0010\u000e\u0003=I!\u0001I\b\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u001a\u0012aB:pkJ\u001cWm]\u0005\u0003M\r\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011!D\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012!\f\t\u0003]]r!aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IZ\u0012A\u0002\u001fs_>$hHC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u000359W\r\u001e-nY>\u0003H/[8ogR\u0019AhQ%\u0011\u0005u\nU\"\u0001 \u000b\u00059y$B\u0001!\u0014\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\"?\u0005)AV\u000e\\(qi&|gn\u001d\u0005\u0006\t\u000e\u0001\r!R\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\r\u001ek\u0011aE\u0005\u0003\u0011N\u0011Ab\u00159be.\u001cVm]:j_:DQAS\u0002A\u0002-\u000b!\u0002]1sC6,G/\u001a:t!\u0011qC*L\u0017\n\u00055K$aA'ba\u0006Y\u0011n]*qY&$\u0018M\u00197f)\u0011\u0001F+V,\u0011\u0005E\u0013V\"A\u001a\n\u0005M\u001b$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\t\u0012\u0001\r!\u0012\u0005\u0006-\u0012\u0001\raS\u0001\b_B$\u0018n\u001c8t\u0011\u0015AF\u00011\u0001Z\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005i{V\"A.\u000b\u0005qk\u0016A\u00014t\u0015\tqv#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003An\u0013A\u0001U1uQ\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\u0011\u0019G.\u001c8\u0011\u0007E#g-\u0003\u0002fg\t1q\n\u001d;j_:\u0004\"a\u001a6\u000e\u0003!T!![\n\u0002\u000bQL\b/Z:\n\u0005-D'AC*ueV\u001cG\u000fV=qK\")A)\u0002a\u0001\u000b\")a+\u0002a\u0001\u0017\")q.\u0002a\u0001a\u0006)a-\u001b7fgB\u0019\u0011O^=\u000f\u0005I$hB\u0001\u0019t\u0013\u0005!\u0014BA;4\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\u0007M+\u0017O\u0003\u0002vgA\u0011!L_\u0005\u0003wn\u0013!BR5mKN#\u0018\r^;t\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)%q\u00181AA\u0003\u0003+\t9\u0002\u0005\u0002\u001f\u007f&\u0019\u0011\u0011A\b\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000b\u00113\u0001\u0019A#\t\u000f\u0005\u001da\u00011\u0001\u0002\n\u0005\u0019!n\u001c2\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004^\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0003\u0002\u0014\u00055!a\u0001&pE\")aK\u0002a\u0001\u0017\"1\u0011\u0011\u0004\u0004A\u0002\u0019\f!\u0002Z1uCN\u001b\u0007.Z7b\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015!\u0005}\u0011\u0011HA\u001e\u0003{\t\t%!\u0012\u0002R\u0005M\u0003cB)\u0002\"\u0005\u0015\u00121F\u0005\u0004\u0003G\u0019$!\u0003$v]\u000e$\u0018n\u001c82!\rq\u0012qE\u0005\u0004\u0003Sy!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000bE\fi#!\r\n\u0007\u0005=\u0002P\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t\u0019$!\u000e\u000e\u0003}J1!a\u000e@\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b\u0011;\u0001\u0019A#\t\r\u0005eq\u00011\u0001g\u0011\u0019\tyd\u0002a\u0001M\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\r\u0003\u0004\u0002D\u001d\u0001\rAZ\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\t9e\u0002a\u0001\u0003\u0013\nqAZ5mi\u0016\u00148\u000f\u0005\u0003rm\u0006-\u0003c\u0001\u0012\u0002N%\u0019\u0011qJ\u0012\u0003\r\u0019KG\u000e^3s\u0011\u00151v\u00011\u0001L\u0011\u001d\t)f\u0002a\u0001\u0003/\n!\u0002[1e_>\u00048i\u001c8g!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/;\u0006!1m\u001c8g\u0013\u0011\t\t'a\u0017\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003!!xn\u0015;sS:<\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0004cA)\u0002l%\u0019\u0011QN\u001a\u0003\u0007%sG/\u0001\u0004fcV\fGn\u001d\u000b\u0004!\u0006M\u0004bBA;\u0015\u0001\u0007\u0011qO\u0001\u0006_RDWM\u001d\t\u0004#\u0006e\u0014bAA>g\t\u0019\u0011I\\=\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$2\u0001UAA\u0011\u001d\t\u0019i\u0003a\u0001\u0003\u000b\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0004O\u0006\u001d\u0015bAAEQ\nAA)\u0019;b)f\u0004X\r")
public class XmlFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "xml";
    }

    public XmlOptions getXmlOptions(SparkSession sparkSession, Map<String, String> parameters) {
        return new XmlOptions(parameters, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord(), true);
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        XmlOptions xmlOptions = this.getXmlOptions(sparkSession, options);
        XmlDataSource xmlDataSource = XmlDataSource$.MODULE$.apply(xmlOptions);
        return xmlDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        XmlOptions xmlOptions = this.getXmlOptions(sparkSession, options);
        return XmlDataSource$.MODULE$.apply(xmlOptions).inferSchema(sparkSession, files, xmlOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        XmlOptions xmlOptions = this.getXmlOptions(sparkSession, options);
        xmlOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, xmlOptions){
            private final XmlOptions xmlOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new XmlOutputWriter(path, dataSchema, context, this.xmlOptions$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return ".xml" + CodecStreams$.MODULE$.getCompressionExtension((JobContext)context);
            }
            {
                this.xmlOptions$1 = xmlOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        XmlOptions xmlOptions = this.getXmlOptions(sparkSession, options);
        String columnNameOfCorruptRecord = xmlOptions.columnNameOfCorruptRecord();
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, columnNameOfCorruptRecord);
        StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XmlFileFormat.$anonfun$buildReader$1(columnNameOfCorruptRecord, x$1))));
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = columnNameOfCorruptRecord;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw QueryCompilationErrors$.MODULE$.queryFromRawFilesIncludeCorruptRecordColumnError();
            }
        }
        return (Function1 & Serializable)file -> {
            StaxXmlParser parser = new StaxXmlParser(actualRequiredSchema, xmlOptions);
            return XmlDataSource$.MODULE$.apply(xmlOptions).readFile(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), (PartitionedFile)file, parser, requiredSchema);
        };
    }

    public String toString() {
        return "XML";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof XmlFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof VariantType) {
            return false;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return dataType2 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(String columnNameOfCorruptRecord$1, StructField x$1) {
        String string = x$1.name();
        String string2 = columnNameOfCorruptRecord$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

