/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\rb\u0001\u00021b\u00011D!\"a\u0004\u0001\u0005\u000b\u0007I\u0011IA\t\u0011)\ty\u0004\u0001B\u0001B\u0003%\u00111\u0003\u0005\u000b\u0003\u0007\u0002!Q1A\u0005\u0002\u0005\u0015\u0003BCA*\u0001\t\u0005\t\u0015!\u0003\u0002H!Q\u0011q\u000b\u0001\u0003\u0006\u0004%\t!!\u0017\t\u0013\u0005u\u0003A!A!\u0002\u0013\t\bBCA1\u0001\t\u0015\r\u0011\"\u0011\u0002d!Q\u00111\u000f\u0001\u0003\u0002\u0003\u0006I!!\u001a\t\u0015\u0005]\u0004A!b\u0001\n\u0013\tI\b\u0003\u0006\u0002\u0002\u0002\u0011\t\u0011)A\u0005\u0003wB\u0001\"a!\u0001\t\u0003)\u0017Q\u0011\u0005\t\u0003\u0007\u0003A\u0011A3\u0002\u001a\"A\u00111\u0011\u0001\u0005\u0002\r\fY\u000bC\u0004\u0002 \u0002!\t!!\u0017\t\u0015\u0005M\u0006\u0001#b\u0001\n\u0013\tI\u0006C\u0004\u0002$\u0002!\t!!.\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAb\u0001\u0001\u0006I!!0\t\u0013\u0005\u0015\u0007A1A\u0005\n\u0005U\u0006\u0002CAd\u0001\u0001\u0006I!!*\t\u0013\u0005%\u0007\u00011A\u0005\n\u0005-\u0007\"CAj\u0001\u0001\u0007I\u0011BAk\u0011!\t\t\u000f\u0001Q!\n\u00055\u0007\u0002CAr\u0001\u0011\u00053-!:\t\u000f\t5\u0001\u0001\"\u0011\u0003\u0010!9!Q\u0004\u0001\u0005B\u0005U\u0006b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005S\u0001A\u0011IAf\u0011%\u0011i\u0003\u0001b\u0001\n\u0013\u0011y\u0003\u0003\u0005\u00038\u0001\u0001\u000b\u0011\u0002B\u0019\u0011%\u0011I\u0004\u0001b\u0001\n\u0013\u0011Y\u0004\u0003\u0005\u0003@\u0001\u0001\u000b\u0011\u0002B\u001f\u0011%\u0011\t\u0005\u0001b\u0001\n\u0013\u0011y\u0003\u0003\u0005\u0003D\u0001\u0001\u000b\u0011\u0002B\u0019\u0011%\u0011)\u0005\u0001b\u0001\n\u0003\n\u0019\u0007\u0003\u0005\u0003N\u0001\u0001\u000b\u0011BA3\u0011\u001d\u0011\t\u0006\u0001C!\u0005'BqAa\u0016\u0001\t\u0003\u0011I\u0006C\u0004\u0003h\u0001!\tA!\u001b\t\u000f\t-\u0005\u0001\"\u0011\u0003\u000e\"9!1\u0013\u0001\u0005R\tU\u0005b\u0002BN\u0001\u0011\u0005#Q\u0014\u0005\b\u0005O\u0003A\u0011\tBU\u0011\u001d\u00119\f\u0001C)\u0005sCqA!0\u0001\t#\u0012y\fC\u0004\u0003F\u0002!\tEa2\t\u000f\tE\u0007\u0001\"\u0011\u0003T\u001e9!q[1\t\u0002\tegA\u00021b\u0011\u0003\u0011Y\u000eC\u0004\u0002\u0004F\"\tA!?\t\u000f\tm\u0018\u0007\"\u0011\u0003~\"91qA\u0019\u0005B\r%aaBB\tc\u0001\t41\u0003\u0005\n\u0007C)$\u0011!Q\u0001\n]Dq!a!6\t\u0003\u0019\u0019C\u0002\u0004\u0004,U\"5Q\u0006\u0005\u000b\u0003CB$Q3A\u0005\u0002\u0005\r\u0004BCA:q\tE\t\u0015!\u0003\u0002f!Q!Q\t\u001d\u0003\u0016\u0004%\t!a\u0019\t\u0015\t5\u0003H!E!\u0002\u0013\t)\u0007\u0003\u0006\u0002Xa\u0012)\u001a!C\u0001\u00033B\u0011\"!\u00189\u0005#\u0005\u000b\u0011B9\t\u0015\u0005\r\u0003H!f\u0001\n\u0003\t)\u0005\u0003\u0006\u0002Ta\u0012\t\u0012)A\u0005\u0003\u000fB!\"a\u001e9\u0005+\u0007I\u0011AA=\u0011)\t\t\t\u000fB\tB\u0003%\u00111\u0010\u0005\b\u0003\u0007CD\u0011AB#\u0011%\u00119\u000bOA\u0001\n\u0003\u0019)\u0006C\u0005\u0004ba\n\n\u0011\"\u0001\u0004d!I1q\u000f\u001d\u0012\u0002\u0013\u000511\r\u0005\n\u0007sB\u0014\u0013!C\u0001\u0007wB\u0011ba 9#\u0003%\ta!!\t\u0013\r\u0015\u0005(%A\u0005\u0002\r\u001d\u0005\"CBFq\u0005\u0005I\u0011IBG\u0011%\u0019I\nOA\u0001\n\u0003\t\u0019\u0007C\u0005\u0004\u001cb\n\t\u0011\"\u0001\u0004\u001e\"I1\u0011\u0015\u001d\u0002\u0002\u0013\u000531\u0015\u0005\n\u0007cC\u0014\u0011!C\u0001\u0007gC\u0011ba.9\u0003\u0003%\te!/\t\u0013\ru\u0006(!A\u0005B\r}\u0006\"\u0003Biq\u0005\u0005I\u0011IBa\u0011%\u0019\u0019\rOA\u0001\n\u0003\u001a)mB\u0005\u0004JV\n\t\u0011#\u0003\u0004L\u001aI11F\u001b\u0002\u0002#%1Q\u001a\u0005\b\u0003\u0007#F\u0011ABn\u0011%\u0011\t\u000eVA\u0001\n\u000b\u001a\t\rC\u0005\u0004^R\u000b\t\u0011\"!\u0004`\"I11\u001e+\u0002\u0002\u0013\u00055Q\u001e\u0005\b\u0007\u007f,D\u0011\u000bC\u0001\r\u0019!)!\r\u0003\u0005\b!9\u00111\u0011.\u0005\u0002\u0011%\u0001\"\u0003C\u00075\n\u0007I\u0011BBG\u0011!!yA\u0017Q\u0001\n\r=\u0005bBB\u00045\u0012\u0005C\u0011\u0003\u0005\n\t+\t\u0014\u0011!C\u0005\t/\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\t\u001c\u0017AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003I\u0016\f!!\u001c7\u000b\u0005\u0019<\u0017!B:qCJ\\'B\u00015j\u0003\u0019\t\u0007/Y2iK*\t!.A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001[bt\u00181\u0001\t\u0005]>\fx/D\u0001b\u0013\t\u0001\u0018M\u0001\u0011Qe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007C\u0001:v\u001b\u0005\u0019(B\u0001;d\u0003\u0019a\u0017N\\1mO&\u0011ao\u001d\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u00059\u0004\u0001CA=}\u001b\u0005Q(BA>d\u0003\u0011)H/\u001b7\n\u0005uT(AC'M/JLG/\u00192mKB\u0011an`\u0005\u0004\u0003\u0003\t'\u0001\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ngB)\u00110!\u0002\u0002\n%\u0019\u0011q\u0001>\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u0004]\u0006-\u0011bAA\u0007C\n\tCj\\4jgRL7MU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\u0006\u0019Q/\u001b3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003OqA!a\u0006\u0002$A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e-\fa\u0001\u0010:p_Rt$BAA\u0011\u0003\u0015\u00198-\u00197b\u0013\u0011\t)#a\b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\u0011\t)#a\b)\u000b\u0005\ty#a\u000f\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000ef\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\t\u0019DA\u0003TS:\u001cW-\t\u0002\u0002>\u0005)\u0011G\f\u001b/a\u0005!Q/\u001b3!Q\u0015\u0011\u0011qFA\u001e\u0003E\u0019w.\u001a4gS\u000eLWM\u001c;NCR\u0014\u0018\u000e_\u000b\u0003\u0003\u000f\u00022A]A%\u0013\r\tYe\u001d\u0002\u0007\u001b\u0006$(/\u001b=)\u000b\r\ty#a\u0014\"\u0005\u0005E\u0013!\u0002\u001a/c9\u0002\u0014AE2pK\u001a4\u0017nY5f]Rl\u0015\r\u001e:jq\u0002BS\u0001BA\u0018\u0003\u001f\nq\"\u001b8uKJ\u001cW\r\u001d;WK\u000e$xN]\u000b\u0002c\"*Q!a\f\u0002P\u0005\u0001\u0012N\u001c;fe\u000e,\u0007\u000f\u001e,fGR|'\u000f\t\u0015\u0006\r\u0005=\u0012qJ\u0001\u000b]Vl7\t\\1tg\u0016\u001cXCAA3!\u0011\t9'!\u001b\u000e\u0005\u0005}\u0011\u0002BA6\u0003?\u00111!\u00138uQ\u00159\u0011qFA8C\t\t\t(A\u00032]Mr\u0003'A\u0006ok6\u001cE.Y:tKN\u0004\u0003&\u0002\u0005\u00020\u0005=\u0014!D5t\u001bVdG/\u001b8p[&\fG.\u0006\u0002\u0002|A!\u0011qMA?\u0013\u0011\ty(a\b\u0003\u000f\t{w\u000e\\3b]\u0006q\u0011n]'vYRLgn\\7jC2\u0004\u0013A\u0002\u001fj]&$h\bF\u0006x\u0003\u000f\u000bY)a$\u0002\u0014\u0006]\u0005bBA\b\u0017\u0001\u0007\u00111\u0003\u0015\u0007\u0003\u000f\u000by#a\u000f\t\u000f\u0005\r3\u00021\u0001\u0002H!2\u00111RA\u0018\u0003\u001fBa!a\u0016\f\u0001\u0004\t\bFBAH\u0003_\ty\u0005C\u0004\u0002b-\u0001\r!!\u001a)\r\u0005M\u0015qFA8\u0011\u001d\t9h\u0003a\u0001\u0003w\"ra^AN\u0003;\u000b\t\u000bC\u0004\u0002\u00101\u0001\r!a\u0005\t\r\u0005}E\u00021\u0001r\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t\u0011\u001d\t\u0019\u000b\u0004a\u0001\u0003K\u000b\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0011\t\u0005\u001d\u0014qU\u0005\u0005\u0003S\u000byB\u0001\u0004E_V\u0014G.\u001a\u000b\u0002o\"*a\"a\f\u00020\u0006\u0012\u0011\u0011W\u0001\u0006e9\u0002d\u0006M\u0001\u000e?\u000e|WM\u001a4jG&,g\u000e^:\u0016\u0005\u0005\u0015\u0006&\u0002\t\u00020\u0005=\u0014\u0001E0j]R,'oY3qiZ+7\r^8s+\t\ti\fE\u0002s\u0003\u007fK1!!1t\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0002#}Kg\u000e^3sG\u0016\u0004HOV3di>\u0014\b%\u0001\u0006`S:$XM]2faR\f1bX5oi\u0016\u00148-\u001a9uA\u0005\trLY5oCJLH\u000b\u001b:fg\"|G\u000eZ:\u0016\u0005\u00055\u0007CBA4\u0003\u001f\f)+\u0003\u0003\u0002R\u0006}!!B!se\u0006L\u0018!F0cS:\f'/\u001f+ie\u0016\u001c\bn\u001c7eg~#S-\u001d\u000b\u0005\u0003/\fi\u000e\u0005\u0003\u0002h\u0005e\u0017\u0002BAn\u0003?\u0011A!\u00168ji\"I\u0011q\u001c\f\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0004q\u0012\n\u0014AE0cS:\f'/\u001f+ie\u0016\u001c\bn\u001c7eg\u0002\nQb\u001c8QCJ\fWn\u00115b]\u001e,G\u0003BAl\u0003ODq!!;\u0019\u0001\u0004\tY/A\u0003qCJ\fW\u000e\r\u0003\u0002n\u0006m\bCBAx\u0003g\f90\u0004\u0002\u0002r*\u0019\u0011\u0011^2\n\t\u0005U\u0018\u0011\u001f\u0002\u0006!\u0006\u0014\u0018-\u001c\t\u0005\u0003s\fY\u0010\u0004\u0001\u0005\u0019\u0005u\u0018q]A\u0001\u0002\u0003\u0015\t!a@\u0003\u0007}#3'\u0005\u0003\u0003\u0002\t\u001d\u0001\u0003BA4\u0005\u0007IAA!\u0002\u0002 \t9aj\u001c;iS:<\u0007\u0003BA4\u0005\u0013IAAa\u0003\u0002 \t\u0019\u0011I\\=\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\t\tE!1C\u0007\u0002\u0001!9!QC\rA\u0002\u0005\u0015\u0016!\u0002<bYV,\u0007&B\r\u00020\te\u0011E\u0001B\u000e\u0003\u0015\td&\u000e\u00181\u000319W\r\u001e+ie\u0016\u001c\bn\u001c7eQ\u0015Q\u0012q\u0006B\r\u00035\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7egR!!\u0011\u0003B\u0013\u0011\u001d\u0011)b\u0007a\u0001\u0003\u001bDSaGA\u0018\u00053\tQbZ3u)\"\u0014Xm\u001d5pY\u0012\u001c\b&\u0002\u000f\u00020\te\u0011AB7be\u001eLg.\u0006\u0002\u00032A9\u0011q\rB\u001ac\u0006\u0015\u0016\u0002\u0002B\u001b\u0003?\u0011\u0011BR;oGRLwN\\\u0019\u0002\u000f5\f'oZ5oA\u00059Q.\u0019:hS:\u001cXC\u0001B\u001f!\u0019\t9Ga\rrc\u0006AQ.\u0019:hS:\u001c\b%A\u0003tG>\u0014X-\u0001\u0004tG>\u0014X\rI\u0001\f]Vlg)Z1ukJ,7\u000fK\u0003$\u0003_\u0011I%\t\u0002\u0003L\u0005)\u0011G\f\u001c/a\u0005aa.^7GK\u0006$XO]3tA!*A%a\f\u0003J\u000591/^7nCJLXCAA\u0005Q\u0015)\u0013q\u0006B\r\u00035\u0011\u0017N\\1ssN+X.\\1ssV\u0011!1\f\t\u0004]\nu\u0013b\u0001B0C\n9#)\u001b8befdunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:zQ\u00151\u0013q\u0006B2C\t\u0011)'A\u00033]Mr\u0003'\u0001\u0005fm\u0006dW/\u0019;f)\u0011\u0011YG!\u001d\u0011\u00079\u0014i'C\u0002\u0003p\u0005\u0014\u0011\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]N+X.\\1ss\"9!1O\u0014A\u0002\tU\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0005o\u0012)\t\u0005\u0004\u0003z\t}$1Q\u0007\u0003\u0005wR1A! f\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0005\u0003\u0013YHA\u0004ECR\f7/\u001a;\u0011\t\u0005e(Q\u0011\u0003\r\u0005\u000f\u0013\t(!A\u0001\u0002\u000b\u0005\u0011q \u0002\u0004?\u0012\"\u0004&B\u0014\u00020\u0005=\u0016a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003K\u0013y\t\u0003\u0004\u0003\u0012\"\u0002\r!]\u0001\tM\u0016\fG/\u001e:fg\u00061\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002r\u0005/CaA!'*\u0001\u0004\t\u0018!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0006qe\u0016$\u0017n\u0019;SC^$2!\u001dBP\u0011\u0019\u0011\tJ\u000ba\u0001c\"*!&a\f\u0003$\u0006\u0012!QU\u0001\u0006g9\u0002d\u0006M\u0001\u0005G>\u0004\u0018\u0010F\u0002x\u0005WCqA!,,\u0001\u0004\u0011y+A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002p\nE\u0016\u0002\u0002BZ\u0003c\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0006W\u0005=\u00121H\u0001\u000fe\u0006<(\u0007\u001d:fI&\u001cG/[8o)\u0011\t)Ka/\t\r\teE\u00061\u0001r\u0003Y\u0001(o\u001c2bE&d\u0017\u000e^=3aJ,G-[2uS>tG\u0003BAS\u0005\u0003DaAa1.\u0001\u0004\t\u0018a\u00039s_\n\f'-\u001b7jif\fQa\u001e:ji\u0016,\"A!3\u0011\u0007e\u0014Y-C\u0002\u0003Nj\u0014\u0001\"\u0014'Xe&$XM\u001d\u0015\u0006]\u0005=\"\u0011J\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0003\u0015\u0006\u0001\u0005=\u00121H\u0001\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0004\"A\\\u0019\u0014\u000fE\u0012iNa9\u0003jB!\u0011q\rBp\u0013\u0011\u0011\t/a\b\u0003\r\u0005s\u0017PU3g!\u0011I(Q]<\n\u0007\t\u001d(P\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004BAa;\u0003v6\u0011!Q\u001e\u0006\u0005\u0005_\u0014\t0\u0001\u0002j_*\u0011!1_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003x\n5(\u0001D*fe&\fG.\u001b>bE2,GC\u0001Bm\u0003\u0011\u0011X-\u00193\u0016\u0005\t}\b\u0003B=\u0004\u0002]L1aa\u0001{\u0005!iEJU3bI\u0016\u0014\b&B\u001a\u00020\t%\u0013\u0001\u00027pC\u0012$2a^B\u0006\u0011\u001d\u0019i\u0001\u000ea\u0001\u0003'\tA\u0001]1uQ\"*A'a\f\u0003J\tiBj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'oE\u00036\u0005\u0013\u001c)\u0002\u0005\u0003\u0004\u0018\ruQBAB\r\u0015\r\u0019Y\"Z\u0001\tS:$XM\u001d8bY&!1qDB\r\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0007K\u0019I\u0003E\u0002\u0004(Uj\u0011!\r\u0005\u0007\u0007C9\u0004\u0019A<\u0003\t\u0011\u000bG/Y\n\bq\tu7qFB\u001b!\u0011\t9g!\r\n\t\rM\u0012q\u0004\u0002\b!J|G-^2u!\u0011\u00199d!\u0011\u000f\t\re2Q\b\b\u0005\u00033\u0019Y$\u0003\u0002\u0002\"%!1qHA\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LAAa>\u0004D)!1qHA\u0010)1\u00199ea\u0013\u0004N\r=3\u0011KB*!\r\u0019I\u0005O\u0007\u0002k!9\u0011\u0011M\"A\u0002\u0005\u0015\u0004b\u0002B#\u0007\u0002\u0007\u0011Q\r\u0005\u0007\u0003/\u001a\u0005\u0019A9\t\u000f\u0005\r3\t1\u0001\u0002H!9\u0011qO\"A\u0002\u0005mD\u0003DB$\u0007/\u001aIfa\u0017\u0004^\r}\u0003\"CA1\tB\u0005\t\u0019AA3\u0011%\u0011)\u0005\u0012I\u0001\u0002\u0004\t)\u0007\u0003\u0005\u0002X\u0011\u0003\n\u00111\u0001r\u0011%\t\u0019\u0005\u0012I\u0001\u0002\u0004\t9\u0005C\u0005\u0002x\u0011\u0003\n\u00111\u0001\u0002|\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB3U\u0011\t)ga\u001a,\u0005\r%\u0004\u0003BB6\u0007gj!a!\u001c\u000b\t\r=4\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012TA!!\u000e\u0002 %!1QOB7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"a! +\u0007E\u001c9'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\r%\u0006BA$\u0007O\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\n*\"\u00111PB4\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111q\u0012\t\u0005\u0007#\u001b9*\u0004\u0002\u0004\u0014*!1Q\u0013By\u0003\u0011a\u0017M\\4\n\t\u0005%21S\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u00119aa(\t\u0013\u0005}G*!AA\u0002\u0005\u0015\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\u0015\u0006CBBT\u0007[\u00139!\u0004\u0002\u0004**!11VA\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007_\u001bIK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA>\u0007kC\u0011\"a8O\u0003\u0003\u0005\rAa\u0002\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0007\u001f\u001bY\fC\u0005\u0002`>\u000b\t\u00111\u0001\u0002f\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002fQ\u00111qR\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m4q\u0019\u0005\n\u0003?\u0014\u0016\u0011!a\u0001\u0005\u000f\tA\u0001R1uCB\u00191\u0011\n+\u0014\u000bQ\u001byM!;\u0011\u001f\rE7q[A3\u0003K\n\u0018qIA>\u0007\u000fj!aa5\u000b\t\rU\u0017qD\u0001\beVtG/[7f\u0013\u0011\u0019Ina5\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0006\u0002\u0004L\u0006)\u0011\r\u001d9msRa1qIBq\u0007G\u001c)oa:\u0004j\"9\u0011\u0011M,A\u0002\u0005\u0015\u0004b\u0002B#/\u0002\u0007\u0011Q\r\u0005\u0007\u0003/:\u0006\u0019A9\t\u000f\u0005\rs\u000b1\u0001\u0002H!9\u0011qO,A\u0002\u0005m\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007_\u001cY\u0010\u0005\u0004\u0002h\rE8Q_\u0005\u0005\u0007g\fyB\u0001\u0004PaRLwN\u001c\t\u000e\u0003O\u001a90!\u001a\u0002fE\f9%a\u001f\n\t\re\u0018q\u0004\u0002\u0007)V\u0004H.Z\u001b\t\u0013\ru\b,!AA\u0002\r\u001d\u0013a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0002X\u0012\r\u0001bBB\u00073\u0002\u0007\u00111\u0003\u0002\u001e\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN\u0019!La@\u0015\u0005\u0011-\u0001cAB\u00145\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004CcA<\u0005\u0014!91Q\u00020A\u0002\u0005M\u0011\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001C\r!\u0011\u0019\t\nb\u0007\n\t\u0011u11\u0013\u0002\u0007\u001f\nTWm\u0019;)\u000bE\nyC!\u0013)\u000bA\nyC!\u0013")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements MLWritable,
LogisticRegressionParams,
HasTrainingSummary<LogisticRegressionTrainingSummary> {
    private Vector _coefficients;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final DenseVector _interceptVector;
    private final double _intercept;
    private double[] _binaryThresholds;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private Param<String> family;
    private Param<Matrix> lowerBoundsOnCoefficients;
    private Param<Matrix> upperBoundsOnCoefficients;
    private Param<Vector> lowerBoundsOnIntercepts;
    private Param<Vector> upperBoundsOnIntercepts;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private DoubleParam threshold;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;
    private volatile boolean bitmap$0;

    public static LogisticRegressionModel load(String path) {
        return LogisticRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LogisticRegressionTrainingSummary> setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if (!this.bitmap$0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = true;
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        if (!this.bitmap$0) {
            return this._coefficients$lzycompute();
        }
        return this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private DenseVector _interceptVector() {
        return this._interceptVector;
    }

    private double _intercept() {
        return this._intercept;
    }

    private double[] _binaryThresholds() {
        return this._binaryThresholds;
    }

    private void _binaryThresholds_$eq(double[] x$1) {
        this._binaryThresholds = x$1;
    }

    @Override
    public void onParamChange(Param<?> param) {
        block6: {
            block7: {
                if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) break block6;
                String string = param.name();
                String string2 = "threshold";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                String string3 = param.name();
                String string4 = "thresholds";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
            }
            if (this.isDefined(this.threshold()) || this.isDefined(this.thresholds())) {
                double _threshold = this.getThreshold();
                if (_threshold == 0.0) {
                    this._binaryThresholds_$eq(new double[]{_threshold, Double.NEGATIVE_INFINITY});
                    return;
                }
                if (_threshold == 1.0) {
                    this._binaryThresholds_$eq(new double[]{_threshold, Double.POSITIVE_INFINITY});
                    return;
                }
                this._binaryThresholds_$eq(new double[]{_threshold, scala.math.package$.MODULE$.log(_threshold / (1.0 - _threshold))});
                return;
            }
            this._binaryThresholds_$eq(null);
            return;
        }
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary) {
            BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
            return binaryLogisticRegressionTrainingSummary;
        }
        throw new RuntimeException("Cannot create a binary summary for a non-binary model(numClasses=" + this.numClasses() + "), use summary instead.");
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        if (this.numClasses() > 2) {
            return new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
        }
        return new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return super.predict(features);
        }
        if (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this._binaryThresholds()[0]) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            double[] values = denseVector.values();
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                Utils$.MODULE$.softmax(values);
            } else {
                values[0] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-values[0]));
                values[1] = 1.0 - values[0];
            }
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return (Vector)this.margins().apply((Object)features);
        }
        double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return super.raw2prediction(rawPrediction);
        }
        if (rawPrediction.apply(1) > this._binaryThresholds()[1]) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return super.probability2prediction(probability);
        }
        if (probability.apply(1) > this._binaryThresholds()[0]) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return "LogisticRegressionModel: uid=" + this.uid() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        double[] dArray;
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        MLWritable.$init$(this);
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable)() -> "Dimension mismatch! Expected coefficientMatrix.numRows == interceptVector.size, but " + this.coefficientMatrix().numRows() + " != " + this.interceptVector().size());
        this._interceptVector = isMultinomial ? interceptVector.toDense() : null;
        double d = this._intercept = !isMultinomial ? interceptVector.apply(0) : Double.NaN;
        if (!isMultinomial) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.5;
            dArray = dArray2;
            dArray2[1] = 0.0;
        } else {
            dArray = null;
        }
        this._binaryThresholds = dArray;
        this.margin = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable)features -> {
            DenseVector m = this._interceptVector().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return m;
        };
        this.score = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
        Statics.releaseFence();
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Nil$.MODULE$), 2, false);
    }

    public LogisticRegressionModel() {
        this("", (Matrix)Matrices$.MODULE$.empty(), (Vector)Vectors$.MODULE$.empty(), -1, false);
    }

    private static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Some some;
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    Some some2;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    int major2 = sp2._1$mcI$sp();
                                    int minor2 = sp2._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    if (row2 == null || (some2 = Row$.MODULE$.unapplySeq(row2)).isEmpty() || some2.get() == null || ((SeqOps)some2.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqOps)some2.get()).apply(0);
                                    Object numFeatures = ((SeqOps)some2.get()).apply(1);
                                    Object intercept = ((SeqOps)some2.get()).apply(2);
                                    coefficients = ((SeqOps)some2.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple4._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple4._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                            Vector coefficients2 = (Vector)tuple4._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Nil$.MODULE$);
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqOps)some.get()).apply(0);
                        Object numFeatures = ((SeqOps)some.get()).apply(1);
                        Object interceptVector = ((SeqOps)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqOps)some.get()).apply(3);
                        isMultinomial = ((SeqOps)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple5._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple5._2());
                Vector interceptVector = (Vector)tuple5._3();
                Matrix coefficientMatrix = (Matrix)tuple5._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.numClasses());
                    }
                    case 1: {
                        return BoxesRunTime.boxToInteger((int)this.numFeatures());
                    }
                    case 2: {
                        return this.interceptVector();
                    }
                    case 3: {
                        return this.coefficientMatrix();
                    }
                    case 4: {
                        return BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return "numClasses";
                    }
                    case 1: {
                        return "numFeatures";
                    }
                    case 2: {
                        return "interceptVector";
                    }
                    case 3: {
                        return "coefficientMatrix";
                    }
                    case 4: {
                        return "isMultinomial";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

