/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$Data$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r%e\u0001\u0002!B\u00011C\u0001B\u0019\u0001\u0003\u0006\u0004%\te\u0019\u0005\tu\u0002\u0011\t\u0011)A\u0005I\"AA\u0010\u0001BC\u0002\u0013\u0005Q\u0010C\u0005\u0002\u000e\u0001\u0011\t\u0011)A\u0005}\"Q\u0011\u0011\u0003\u0001\u0003\u0006\u0004%\t!a\u0005\t\u0015\u0005%\u0002A!A!\u0002\u0013\t)\u0002\u0003\u0005\u0002.\u0001!\taQA\u0018\u0011)\ti\u0004\u0001EC\u0002\u0013\u0005\u0011q\b\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011q\u001a\u0001\u0005B\u0005E\u0007bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u0016\u0001!\tEa\u0006\t\u000f\tm\u0001\u0001\"\u0011\u0003\u001e\u001d9!1E!\t\u0002\t\u0015bA\u0002!B\u0011\u0003\u00119\u0003C\u0004\u0002.Y!\tA!\u0012\t\u000f\t\u001dc\u0003\"\u0011\u0003J!9!1\u000b\f\u0005B\tUca\u0002B/-\u00011\"q\f\u0005\n\u0005CR\"\u0011!Q\u0001\nECq!!\f\u001b\t\u0003\u0011\u0019G\u0002\u0004\u0003li!%Q\u000e\u0005\tyv\u0011)\u001a!C\u0001{\"I\u0011QB\u000f\u0003\u0012\u0003\u0006IA \u0005\u000b\u0005\u0007k\"Q3A\u0005\u0002\t\u0015\u0005B\u0003BK;\tE\t\u0015!\u0003\u0003\b\"Q!qS\u000f\u0003\u0016\u0004%\tA!'\t\u0015\t\rVD!E!\u0002\u0013\u0011Y\nC\u0004\u0002.u!\tA!*\t\u0013\u00055T$!A\u0005\u0002\tE\u0006\"\u0003B];E\u0005I\u0011\u0001B^\u0011%\u0011y-HI\u0001\n\u0003\u0011\t\u000eC\u0005\u0003Vv\t\n\u0011\"\u0001\u0003X\"I!1\\\u000f\u0002\u0002\u0013\u0005#Q\u001c\u0005\n\u0005Sl\u0012\u0011!C\u0001\u0003\u007fA\u0011Ba;\u001e\u0003\u0003%\tA!<\t\u0013\tMX$!A\u0005B\tU\b\"CB\u0002;\u0005\u0005I\u0011AB\u0003\u0011%\u0019y!HA\u0001\n\u0003\u001a\t\u0002C\u0005\u0004\u0016u\t\t\u0011\"\u0011\u0004\u0018!I!QC\u000f\u0002\u0002\u0013\u00053\u0011\u0004\u0005\n\u00077i\u0012\u0011!C!\u0007;9\u0011b!\t\u001b\u0003\u0003EIaa\t\u0007\u0013\t-$$!A\t\n\r\u0015\u0002bBA\u0017g\u0011\u000511\u0007\u0005\n\u0005+\u0019\u0014\u0011!C#\u00073A\u0011b!\u000e4\u0003\u0003%\tia\u000e\t\u0013\r}2'!A\u0005\u0002\u000e\u0005\u0003bBB*5\u0011E3Q\u000b\u0004\u0007\u0007?2Ba!\u0019\t\u000f\u00055\u0012\b\"\u0001\u0004d!I1qM\u001dC\u0002\u0013%!Q\u001c\u0005\t\u0007SJ\u0004\u0015!\u0003\u0003`\"9!1K\u001d\u0005B\r-\u0004\u0002CB8-\u0011\u0005\u0011i!\u001d\t\u0013\rmd#!A\u0005\n\ru$\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,GN\u0003\u0002C\u0007\u0006Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u0011+\u0015AA7m\u0015\t1u)A\u0003ta\u0006\u00148N\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<7\u0001A\n\u0006\u00015\u001bf\u000b\u0018\t\u0004\u001d>\u000bV\"A\"\n\u0005A\u001b%!B'pI\u0016d\u0007C\u0001*\u0001\u001b\u0005\t\u0005C\u0001*U\u0013\t)\u0016IA\u000bHCV\u001c8/[1o\u001b&DH/\u001e:f!\u0006\u0014\u0018-\\:\u0011\u0005]SV\"\u0001-\u000b\u0005e\u001b\u0015\u0001B;uS2L!a\u0017-\u0003\u00155cuK]5uC\ndW\rE\u0002X;~K!A\u0018-\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u0003%\u0002L!!Y!\u0003-\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016\u001cV/\\7bef\f1!^5e+\u0005!\u0007CA3o\u001d\t1G\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j\u0017\u00061AH]8pizR\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[*\fa\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011QN\u001b\u0015\u0004\u0003ID\bCA:w\u001b\u0005!(BA;F\u0003)\tgN\\8uCRLwN\\\u0005\u0003oR\u0014QaU5oG\u0016\f\u0013!_\u0001\u0006e9\u0002d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003eb\fqa^3jO\"$8/F\u0001\u007f!\u0015y\u0018\u0011AA\u0003\u001b\u0005Q\u0017bAA\u0002U\n)\u0011I\u001d:bsB\u0019q0a\u0002\n\u0007\u0005%!N\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0007ID\u0018\u0001C<fS\u001eDGo\u001d\u0011)\u0007\u0011\u0011\b0A\u0005hCV\u001c8/[1ogV\u0011\u0011Q\u0003\t\u0006\u007f\u0006\u0005\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\r\t\tcQ\u0001\u0005gR\fG/\u0003\u0003\u0002&\u0005m!\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fg\u000eK\u0002\u0006eb\f!bZ1vgNL\u0017M\\:!Q\r1!\u000f_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fE\u000b\t$!\u000e\u0002:!)!m\u0002a\u0001I\"\"\u0011\u0011\u0007:y\u0011\u0015ax\u00011\u0001\u007fQ\u0011\t)D\u001d=\t\u000f\u0005Eq\u00011\u0001\u0002\u0016!\"\u0011\u0011\b:y\u0003-qW/\u001c$fCR,(/Z:\u0016\u0005\u0005\u0005\u0003cA@\u0002D%\u0019\u0011Q\t6\u0003\u0007%sG\u000f\u000b\u0003\te\u0006%\u0013EAA&\u0003\u0015\u0019d\u0006\r\u00181\u00039\u0019X\r\u001e$fCR,(/Z:D_2$B!!\u0015\u0002T5\t\u0001\u0001\u0003\u0004\u0002V%\u0001\r\u0001Z\u0001\u0006m\u0006dW/\u001a\u0015\u0005\u0013I\fI&\t\u0002\u0002\\\u0005)!GL\u0019/a\u0005\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0005\u0003#\n\t\u0007\u0003\u0004\u0002V)\u0001\r\u0001\u001a\u0015\u0005\u0015I\fI&A\ttKR\u0004&o\u001c2bE&d\u0017\u000e^=D_2$B!!\u0015\u0002j!1\u0011QK\u0006A\u0002\u0011DCa\u0003:\u0002Z\u0005!1m\u001c9z)\r\t\u0016\u0011\u000f\u0005\b\u0003gb\u0001\u0019AA;\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t9(! \u000e\u0005\u0005e$bAA>\u0007\u0006)\u0001/\u0019:b[&!\u0011qPA=\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\u0007sq\u0006IAO]1og\u001a|'/\u001c\u000b\u0005\u0003\u000f\u000bI\u000b\u0005\u0003\u0002\n\u0006\rf\u0002BAF\u0003;sA!!$\u0002\u001a:!\u0011qRAL\u001d\u0011\t\t*!&\u000f\u0007\u001d\f\u0019*C\u0001K\u0013\tA\u0015*\u0003\u0002G\u000f&\u0019\u00111T#\u0002\u0007M\fH.\u0003\u0003\u0002 \u0006\u0005\u0016a\u00029bG.\fw-\u001a\u0006\u0004\u00037+\u0015\u0002BAS\u0003O\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005}\u0015\u0011\u0015\u0005\b\u0003Wk\u0001\u0019AAW\u0003\u001d!\u0017\r^1tKR\u0004D!a,\u0002<B1\u0011\u0011WAZ\u0003ok!!!)\n\t\u0005U\u0016\u0011\u0015\u0002\b\t\u0006$\u0018m]3u!\u0011\tI,a/\r\u0001\u0011a\u0011QXAU\u0003\u0003\u0005\tQ!\u0001\u0002@\n\u0019q\fJ\u0019\u0012\t\u0005\u0005\u0017q\u0019\t\u0004\u007f\u0006\r\u0017bAAcU\n9aj\u001c;iS:<\u0007cA@\u0002J&\u0019\u00111\u001a6\u0003\u0007\u0005s\u0017\u0010K\u0002\u000eeb\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003'\fy\u000e\u0005\u0003\u0002V\u0006mWBAAl\u0015\u0011\tI.!)\u0002\u000bQL\b/Z:\n\t\u0005u\u0017q\u001b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBAq\u001d\u0001\u0007\u00111[\u0001\u0007g\u000eDW-\\1)\u00079\u0011\b0A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005\u0005\u0013\u0011\u001e\u0005\b\u0003W|\u0001\u0019AAw\u0003!1W-\u0019;ve\u0016\u001c\b\u0003BAx\u0003kl!!!=\u000b\u0007\u0005M8)\u0001\u0004mS:\fGnZ\u0005\u0005\u0003o\f\tP\u0001\u0004WK\u000e$xN\u001d\u0015\u0005\u001fI\fI%\u0001\nqe\u0016$\u0017n\u0019;Qe>\u0014\u0017MY5mSRLH\u0003BAw\u0003\u007fDq!a;\u0011\u0001\u0004\ti\u000f\u000b\u0003\u0011e\u0006%\u0013aC4bkN\u001c\u0018.\u00198t\t\u001a+\"!a\")\u0007E\u0011\b0A\u0003xe&$X-\u0006\u0002\u0003\u000eA\u0019qKa\u0004\n\u0007\tE\u0001L\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\r\u0011\"\u000f_\u0001\ti>\u001cFO]5oOR\tA\r\u000b\u0003\u0014e\u0006%\u0013aB:v[6\f'/_\u000b\u0002?\"\u001aAC\u001d=)\u0007\u0001\u0011\b0\u0001\u000bHCV\u001c8/[1o\u001b&DH/\u001e:f\u001b>$W\r\u001c\t\u0003%Z\u0019rA\u0006B\u0015\u0005_\u0011)\u0004E\u0002\u0000\u0005WI1A!\fk\u0005\u0019\te.\u001f*fMB!qK!\rR\u0013\r\u0011\u0019\u0004\u0017\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\u0003S>T!Aa\u0010\u0002\t)\fg/Y\u0005\u0005\u0005\u0007\u0012ID\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003&\u0005!!/Z1e+\t\u0011Y\u0005\u0005\u0003X\u0005\u001b\n\u0016b\u0001B(1\nAQ\n\u0014*fC\u0012,'\u000fK\u0002\u0019eb\fA\u0001\\8bIR\u0019\u0011Ka\u0016\t\r\te\u0013\u00041\u0001e\u0003\u0011\u0001\u0018\r\u001e5)\u0007e\u0011\bP\u0001\u000eHCV\u001c8/[1o\u001b&DH/\u001e:f\u001b>$W\r\\,sSR,'oE\u0002\u001b\u0005\u001b\t\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005K\u0012I\u0007E\u0002\u0003hii\u0011A\u0006\u0005\u0007\u0005Cb\u0002\u0019A)\u0003\t\u0011\u000bG/Y\n\b;\t%\"q\u000eB;!\ry(\u0011O\u0005\u0004\u0005gR'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005o\u0012yH\u0004\u0003\u0003z\tudbA4\u0003|%\t1.C\u0002\u0002 *LAAa\u0011\u0003\u0002*\u0019\u0011q\u00146\u0002\u00075,8/\u0006\u0002\u0003\bB)q0!\u0001\u0003\nB!!1\u0012BJ\u001b\t\u0011iI\u0003\u0003\u0002t\n=%b\u0001BI\u000b\u0006)Q\u000e\u001c7jE&!\u0011q\u001fBG\u0003\u0011iWo\u001d\u0011\u0002\rMLw-\\1t+\t\u0011Y\nE\u0003\u0000\u0003\u0003\u0011i\n\u0005\u0003\u0003\f\n}\u0015\u0002\u0002BQ\u0005\u001b\u0013a!T1ue&D\u0018aB:jO6\f7\u000f\t\u000b\t\u0005O\u0013YK!,\u00030B\u0019!\u0011V\u000f\u000e\u0003iAQ\u0001 \u0013A\u0002yDqAa!%\u0001\u0004\u00119\tC\u0004\u0003\u0018\u0012\u0002\rAa'\u0015\u0011\t\u001d&1\u0017B[\u0005oCq\u0001`\u0013\u0011\u0002\u0003\u0007a\u0010C\u0005\u0003\u0004\u0016\u0002\n\u00111\u0001\u0003\b\"I!qS\u0013\u0011\u0002\u0003\u0007!1T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iLK\u0002\u007f\u0005\u007f[#A!1\u0011\t\t\r'1Z\u0007\u0003\u0005\u000bTAAa2\u0003J\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003k*LAA!4\u0003F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u001b\u0016\u0005\u0005\u000f\u0013y,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\te'\u0006\u0002BN\u0005\u007f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001Bp!\u0011\u0011\tOa:\u000e\u0005\t\r(\u0002\u0002Bs\u0005{\tA\u0001\\1oO&\u0019qNa9\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q\u0019Bx\u0011%\u0011\tpKA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005o\u0004bA!?\u0003\u0000\u0006\u001dWB\u0001B~\u0015\r\u0011iP[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\u0001\u0005w\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!1qAB\u0007!\ry8\u0011B\u0005\u0004\u0007\u0017Q'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005cl\u0013\u0011!a\u0001\u0003\u000f\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\\B\n\u0011%\u0011\tPLA\u0001\u0002\u0004\t\t%\u0001\u0005iCND7i\u001c3f)\t\t\t\u0005\u0006\u0002\u0003`\u00061Q-];bYN$Baa\u0002\u0004 !I!\u0011_\u0019\u0002\u0002\u0003\u0007\u0011qY\u0001\u0005\t\u0006$\u0018\rE\u0002\u0003*N\u001aRaMB\u0014\u0005k\u00012b!\u000b\u00040y\u00149Ia'\u0003(6\u001111\u0006\u0006\u0004\u0007[Q\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007c\u0019YCA\tBEN$(/Y2u\rVt7\r^5p]N\"\"aa\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\t\u001d6\u0011HB\u001e\u0007{AQ\u0001 \u001cA\u0002yDqAa!7\u0001\u0004\u00119\tC\u0004\u0003\u0018Z\u0002\rAa'\u0002\u000fUt\u0017\r\u001d9msR!11IB(!\u0015y8QIB%\u0013\r\u00199E\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011}\u001cYE BD\u00057K1a!\u0014k\u0005\u0019!V\u000f\u001d7fg!I1\u0011K\u001c\u0002\u0002\u0003\u0007!qU\u0001\u0004q\u0012\u0002\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\r]3Q\f\t\u0004\u007f\u000ee\u0013bAB.U\n!QK\\5u\u0011\u0019\u0011I\u0006\u000fa\u0001I\nQr)Y;tg&\fg.T5yiV\u0014X-T8eK2\u0014V-\u00193feN\u0019\u0011Ha\u0013\u0015\u0005\r\u0015\u0004c\u0001B4s\u0005I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004CcA)\u0004n!1!\u0011L\u001fA\u0002\u0011\fAcY8naV$X\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHc\u0002@\u0004t\rU4\u0011\u0010\u0005\b\u0003Wt\u0004\u0019AAw\u0011\u001d\u00199H\u0010a\u0001\u0003+\tQ\u0001Z5tiNDQ\u0001  A\u0002y\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa \u0011\t\t\u00058\u0011Q\u0005\u0005\u0007\u0007\u0013\u0019O\u0001\u0004PE*,7\r\u001e\u0015\u0004-ID\bfA\u000bsq\u0002")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable,
HasTrainingSummary<GaussianMixtureSummary> {
    private int numFeatures;
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private IntParam k;
    private IntParam aggregationDepth;
    private DoubleParam tol;
    private Param<String> probabilityCol;
    private Param<String> weightCol;
    private Param<String> predictionCol;
    private LongParam seed;
    private Param<String> featuresCol;
    private IntParam maxIter;
    private volatile boolean bitmap$0;

    public static GaussianMixtureModel load(String path) {
        return GaussianMixtureModel$.MODULE$.load(path);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<GaussianMixtureSummary> setSummary(Option<GaussianMixtureSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    private int numFeatures$lzycompute() {
        GaussianMixtureModel gaussianMixtureModel = this;
        synchronized (gaussianMixtureModel) {
            if (!this.bitmap$0) {
                this.numFeatures = ((MultivariateGaussian)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.gaussians()))).mean().size();
                this.bitmap$0 = true;
            }
        }
        return this.numFeatures;
    }

    public int numFeatures() {
        return !this.bitmap$0 ? this.numFeatures$lzycompute() : this.numFeatures;
    }

    public GaussianMixtureModel setFeaturesCol(String value) {
        return (GaussianMixtureModel)this.set(this.featuresCol(), value);
    }

    public GaussianMixtureModel setPredictionCol(String value) {
        return (GaussianMixtureModel)this.set(this.predictionCol(), value);
    }

    public GaussianMixtureModel setProbabilityCol(String value) {
        return (GaussianMixtureModel)this.set(this.probabilityCol(), value);
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = this.copyValues(new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians()), extra);
        return (GaussianMixtureModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block4: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
            outputData = dataset;
            int numColsOutput = 0;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
                    }
                }
                UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> this.predictProbability((org.apache.spark.ml.linalg.Vector)vector), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(null)));
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.probabilityCol())).metadata());
                ++numColsOutput;
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) {
                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)vector.argmax()), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                } else {
                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                }
                ++numColsOutput;
            }
            if (numColsOutput != false) break block4;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(47).append(this.uid()).append(": GaussianMixtureModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = this.validateAndTransformSchema(schema);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumValues(outputSchema, this.$(this.predictionCol()), this.weights().length);
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.probabilityCol()), this.weights().length);
        }
        return var2_2;
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities(features, this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        Tuple2[] modelGaussians = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.gaussians()), (Function1 & Serializable)gaussian -> new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov())), ClassTag$.MODULE$.apply(Tuple2.class));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)modelGaussians), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(44).append("GaussianMixtureModel: uid=").append(this.uid()).append(", k=").append(this.weights().length).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    @Override
    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)HasTrainingSummary.summary$(this);
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        HasAggregationDepth.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Statics.releaseFence();
    }

    private static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Matrix[] sigmas;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
            double[] weights = (double[])row.getSeq(0).toArray((ClassTag)ClassTag$.MODULE$.Double());
            Vector[] mus = (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class));
            Predef$.MODULE$.require(mus.length == (sigmas = (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class))).length, (Function0 & Serializable)() -> "Length of Mu and Sigma array must match");
            Predef$.MODULE$.require(mus.length == weights.length, (Function0 & Serializable)() -> "Length of weight and Gaussian array must match");
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])mus), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])sigmas))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector mu = (Vector)tuple2._1();
                Matrix sigma = (Matrix)tuple2._2();
                MultivariateGaussian multivariateGaussian = new MultivariateGaussian(mu.asML(), sigma.asML());
                return multivariateGaussian;
            }, ClassTag$.MODULE$.apply(MultivariateGaussian.class));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), weights, gaussians);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private volatile GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data$module;
        private final GaussianMixtureModel instance;

        private GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])gaussians), (Function1 & Serializable)g -> Vectors$.MODULE$.fromML(g.mean()), ClassTag$.MODULE$.apply(Vector.class));
            Matrix[] sigmas = (Matrix[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])gaussians), (Function1 & Serializable)c -> Matrices$.MODULE$.fromML(c.cov()), ClassTag$.MODULE$.apply(Matrix.class));
            Data data = new Data(this, weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3(GaussianMixtureModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GaussianMixtureModelWriter gaussianMixtureModelWriter = this;
            synchronized (gaussianMixtureModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GaussianMixtureModel$GaussianMixtureModelWriter$Data$(this);
                }
            }
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final double[] weights;
            private final Vector[] mus;
            private final Matrix[] sigmas;
            public final /* synthetic */ GaussianMixtureModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public double[] weights() {
                return this.weights;
            }

            public Vector[] mus() {
                return this.mus;
            }

            public Matrix[] sigmas() {
                return this.sigmas;
            }

            public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
                return new Data(this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer(), weights, mus, sigmas);
            }

            public double[] copy$default$1() {
                return this.weights();
            }

            public Vector[] copy$default$2() {
                return this.mus();
            }

            public Matrix[] copy$default$3() {
                return this.sigmas();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.weights();
                        break;
                    }
                    case 1: {
                        object = this.mus();
                        break;
                    }
                    case 2: {
                        object = this.sigmas();
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "weights";
                        break;
                    }
                    case 1: {
                        string = "mus";
                        break;
                    }
                    case 2: {
                        string = "sigmas";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() != this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.weights() != data.weights()) return false;
                if (this.mus() != data.mus()) return false;
                if (this.sigmas() != data.sigmas()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GaussianMixtureModelWriter org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GaussianMixtureModelWriter $outer, double[] weights, Vector[] mus, Matrix[] sigmas) {
                this.weights = weights;
                this.mus = mus;
                this.sigmas = sigmas;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

