/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class YarnSparkHadoopUtil$ {
    public static final YarnSparkHadoopUtil$ MODULE$ = new YarnSparkHadoopUtil$();
    private static final double AM_MEMORY_OVERHEAD_FACTOR = 0.1;
    private static final String ANY_HOST = "*";
    private static final Priority RM_REQUEST_PRIORITY = Priority.newInstance((int)1);
    private static final String envVarNameRegex = "[A-Za-z_][A-Za-z0-9_]*";

    public double AM_MEMORY_OVERHEAD_FACTOR() {
        return AM_MEMORY_OVERHEAD_FACTOR;
    }

    public String ANY_HOST() {
        return ANY_HOST;
    }

    public Priority RM_REQUEST_PRIORITY() {
        return RM_REQUEST_PRIORITY;
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? new StringBuilder(5).append((String)env.apply((Object)key)).append("<CPS>").append(value).toString() : value;
        env.put((Object)key, (Object)newValue);
    }

    private String envVarNameRegex() {
        return envVarNameRegex;
    }

    public String replaceEnvVars(String unresolvedString, Map<String, String> env, boolean isWindows) {
        String string;
        if (isWindows) {
            Regex windowsPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(24).append("(?i)(?:\\^\\^|\\^%|%%|%(").append(this.envVarNameRegex()).append(")%)").toString()));
            string = windowsPattern.replaceAllIn((CharSequence)unresolvedString, (Function1 & Serializable)m -> {
                String string;
                block5: {
                    String string2 = m.matched();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 1184: {
                            if (!"%%".equals(string2)) break;
                            string = "%";
                            break block5;
                        }
                        case 2951: {
                            if (!"^%".equals(string2)) break;
                            string = "%";
                            break block5;
                        }
                        case 3008: {
                            if (!"^^".equals(string2)) break;
                            string = "^";
                            break block5;
                        }
                    }
                    string = (String)env.getOrElse((Object)m.group(1), (Function0 & Serializable)() -> "");
                }
                return Regex$.MODULE$.quoteReplacement(string);
            });
        } else {
            Regex unixPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(30).append("(?i)(?:\\\\\\\\|\\\\\\$|\\$(").append(this.envVarNameRegex()).append(")|\\$\\{(").append(this.envVarNameRegex()).append(")})").toString()));
            string = unixPattern.replaceAllIn((CharSequence)unresolvedString, (Function1 & Serializable)m -> {
                String string;
                block4: {
                    String string2 = m.matched();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 2888: {
                            if (!"\\$".equals(string2)) break;
                            string = "$";
                            break block4;
                        }
                        case 2944: {
                            if (!"\\\\".equals(string2)) break;
                            string = "\\";
                            break block4;
                        }
                    }
                    string = string2.startsWith("${") ? (String)env.getOrElse((Object)m.group(2), (Function0 & Serializable)() -> "") : (String)env.getOrElse((Object)m.group(1), (Function0 & Serializable)() -> "");
                }
                return Regex$.MODULE$.quoteReplacement(string);
            });
        }
        String osResolvedString = string;
        Regex yarnPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(12).append("(?i)\\{\\{(").append(this.envVarNameRegex()).append(")}}").toString()));
        return yarnPattern.replaceAllIn((CharSequence)osResolvedString, (Function1 & Serializable)m -> Regex$.MODULE$.quoteReplacement((String)env.getOrElse((Object)m.group(1), (Function0 & Serializable)() -> "")));
    }

    public boolean replaceEnvVars$default$3() {
        return Utils$.MODULE$.isWindows();
    }

    public void addOutOfMemoryErrorArgument(ListBuffer<String> javaOpts) {
        block2: {
            if (javaOpts.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("-XX:OnOutOfMemoryError")))) break block2;
            if (Utils$.MODULE$.isWindows()) {
                javaOpts.$plus$eq((Object)this.escapeForShell("-XX:OnOutOfMemoryError=taskkill /F /PID %%%%p"));
            } else {
                javaOpts.$plus$eq((Object)"-XX:OnOutOfMemoryError='kill %p'");
            }
        }
    }

    public String escapeForShell(String arg) {
        String string;
        if (arg != null) {
            if (Utils$.MODULE$.isWindows()) {
                string = YarnCommandBuilderUtils$.MODULE$.quoteForBatchScript(arg);
            } else {
                scala.collection.mutable.StringBuilder escaped = new scala.collection.mutable.StringBuilder("'");
                StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(arg), (Function1 & Serializable)x0$1 -> YarnSparkHadoopUtil$.$anonfun$escapeForShell$1(escaped, BoxesRunTime.unboxToChar((Object)x0$1)));
                string = escaped.append("'").toString();
            }
        } else {
            string = arg;
        }
        return string;
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)new StringBuilder(1).append(securityMgr.getViewAcls()).append(" ").append(securityMgr.getViewAclsGroups()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)new StringBuilder(1).append(securityMgr.getModifyAcls()).append(" ").append(securityMgr.getModifyAclsGroups()).toString())}));
    }

    public ContainerId getContainerId() {
        String containerIdString = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        return ContainerId.fromString((String)containerIdString);
    }

    public long executorOffHeapMemorySizeAsMb(SparkConf sparkConf, ExecutorResourceRequest execRequest) {
        return Utils$.MODULE$.checkOffHeapEnabled(sparkConf, execRequest.amount());
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$escapeForShell$1(scala.collection.mutable.StringBuilder escaped$1, char x0$1) {
        scala.collection.mutable.StringBuilder stringBuilder;
        char c = x0$1;
        switch (c) {
            case '$': {
                stringBuilder = escaped$1.append("\\$");
                break;
            }
            case '\"': {
                stringBuilder = escaped$1.append("\\\"");
                break;
            }
            case '\'': {
                stringBuilder = escaped$1.append("'\\''");
                break;
            }
            default: {
                stringBuilder = escaped$1.append(c);
                break;
            }
        }
        return stringBuilder;
    }

    private YarnSparkHadoopUtil$() {
    }
}

