/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, bitLength) - Returns a checksum of SHA-2 family as a hex string of `expr`.\n      SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 256);\n       529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\u000f\u001f\u0001.B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0015l\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u001d\t)\u0001\u0001C)\u0003\u000fA\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0019\u0001E\u0005I\u0011AA\u000e\u0011%\t\u0019\u0004AA\u0001\n\u0003\n)\u0004C\u0005\u0002H\u0001\t\t\u0011\"\u0001\u0002J!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00033\u0002\u0011\u0011!C!\u00037B\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u000f%\tYJHA\u0001\u0012\u0003\tiJ\u0002\u0005\u001e=\u0005\u0005\t\u0012AAP\u0011\u0019\u0019v\u0003\"\u0001\u00028\"I\u0011\u0011X\f\u0002\u0002\u0013\u0015\u00131\u0018\u0005\n\u0003{;\u0012\u0011!CA\u0003\u007fC\u0011\"!2\u0018\u0003\u0003%\t)a2\t\u0013\u0005ew#!A\u0005\n\u0005m'\u0001B*iCJR!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0007\u00011\u00024GO$\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0013'\u0003\u00023=\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00025o9\u0011Q&N\u0005\u0003my\tq\u0001]1dW\u0006<W-\u0003\u00029s\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001\u001c\u001f!\tYDI\u0004\u0002=\u0005:\u0011Q\bQ\u0007\u0002})\u0011qHK\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\u000bQa]2bY\u0006L!AN\"\u000b\u0003\u0005K!!\u0012$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005Y\u001a\u0005C\u0001%J\u001b\u0005\u0019\u0015B\u0001&D\u0005\u001d\u0001&o\u001c3vGR\fA\u0001\\3giV\tQ\n\u0005\u0002.\u001d&\u0011qJ\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004+Z;\u0006CA\u0017\u0001\u0011\u0015YU\u00011\u0001N\u0011\u0015\tV\u00011\u0001N\u0003!!\u0017\r^1UsB,W#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u\u0013\u0013!\u0002;za\u0016\u001c\u0018BA0]\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0003\t\u0004\"\u0001S2\n\u0005\u0011\u001c%a\u0002\"p_2,\u0017M\\\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A4\u0011\u0007mB',\u0003\u0002j\r\n\u00191+Z9\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u00071|\u0017\u000f\u0005\u0002I[&\u0011an\u0011\u0002\u0004\u0003:L\b\"\u00029\n\u0001\u0004a\u0017AB5oaV$\u0018\u0007C\u0003s\u0013\u0001\u0007A.\u0001\u0004j]B,HOM\u0001\nI><UM\\\"pI\u0016$B!^>\u0002\u0002A\u0011a/_\u0007\u0002o*\u0011\u0001PH\u0001\bG>$WmZ3o\u0013\tQxO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015a(\u00021\u0001~\u0003\r\u0019G\u000f\u001f\t\u0003mzL!a`<\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u00111\u0001\u0006A\u0002U\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B+\u0002\n\u00055\u0001BBA\u0006\u0017\u0001\u0007Q*A\u0004oK^dUM\u001a;\t\r\u0005=1\u00021\u0001N\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$R!VA\u000b\u0003/Aqa\u0013\u0007\u0011\u0002\u0003\u0007Q\nC\u0004R\u0019A\u0005\t\u0019A'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0004\u0016\u0004\u001b\u0006}1FAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-2)\u0001\u0006b]:|G/\u0019;j_:LA!a\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005!A.\u00198h\u0015\t\t\t%\u0001\u0003kCZ\f\u0017\u0002BA#\u0003w\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA&!\rA\u0015QJ\u0005\u0004\u0003\u001f\u001a%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00017\u0002V!I\u0011qK\t\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0003#BA0\u0003KbWBAA1\u0015\r\t\u0019gQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA4\u0003C\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!-!\u001c\t\u0011\u0005]3#!AA\u00021\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qGA:\u0011%\t9\u0006FA\u0001\u0002\u0004\tY%\u0001\u0004fcV\fGn\u001d\u000b\u0004E\u0006e\u0004\u0002CA,+\u0005\u0005\t\u0019\u00017)'\u0001\ti(a!\u0002\u0006\u0006%\u00151RAH\u0003#\u000b)*a&\u0011\u00075\ny(C\u0002\u0002\u0002z\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\b\u0006\t\u0019I\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:-A\tLG\u000fT3oORD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\r[3dWN,X\u000eI8gAMC\u0015)\f\u001a!M\u0006l\u0017\u000e\\=!CN\u0004\u0013\r\t5fq\u0002\u001aHO]5oO\u0002zg\r\t1fqB\u0014\bM\f\u0006!A\u0001\u0002\u0003\u0005I*I\u00036\u0012$\u0007\u000e\u0017!'\"\u000bUFM\u001b7Y\u0001\u001a\u0006*Q\u00174qQb\u0003%\u00198eAMC\u0015)L\u001b2e\u0001\n'/\u001a\u0011tkB\u0004xN\u001d;fI:\u0002#)\u001b;!Y\u0016tw\r\u001e5!_\u001a\u0004\u0003\u0007I5tA\u0015\fX/\u001b<bY\u0016tG\u000f\t;pAI*dG\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u000e\u0006q(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!eU2\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116ee\u00127m\r21oE\u0012t'Z2co\u0015,4'\u0019\u001beG\u001a\f\u0014(O\u0019esE*$g\u0019\u001a5kM:D-O\u0019:c]B\u0004G\r\u001ace\r$$GN\u001b8M^J\u0014M\r\u001cc\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAJ\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\tI*\u0001\u0006iCNDwLZ;oGN\fAa\u00155beA\u0011QfF\n\u0006/\u0005\u0005\u0016Q\u0016\t\b\u0003G\u000bI+T'V\u001b\t\t)KC\u0002\u0002(\u000e\u000bqA];oi&lW-\u0003\u0003\u0002,\u0006\u0015&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qVA[\u001b\t\t\tL\u0003\u0003\u00024\u0006}\u0012AA5p\u0013\r)\u0015\u0011\u0017\u000b\u0003\u0003;\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003o\tQ!\u00199qYf$R!VAa\u0003\u0007DQa\u0013\u000eA\u00025CQ!\u0015\u000eA\u00025\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002J\u0006U\u0007#\u0002%\u0002L\u0006=\u0017bAAg\u0007\n1q\n\u001d;j_:\u0004R\u0001SAi\u001b6K1!a5D\u0005\u0019!V\u000f\u001d7fe!A\u0011q[\u000e\u0002\u0002\u0003\u0007Q+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!8\u0011\t\u0005e\u0012q\\\u0005\u0005\u0003C\fYD\u0001\u0004PE*,7\r\u001e")
public class Sha2
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 x$0) {
        return Sha2$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            case 224: {
                uTF8String = UTF8String.fromString((String)new DigestUtils("SHA-224").digestAsHex(input));
                break;
            }
            case 0: 
            case 256: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
                break;
            }
            case 384: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
                break;
            }
            case 512: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
                break;
            }
            default: {
                uTF8String = null;
                break;
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = DigestUtils.class.getName();
        String messageDigestAlgorithms = MessageDigestAlgorithms.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> new StringBuilder(454).append("\n        if (").append((String)eval2).append(" == 224) {\n          ").append(ev.value()).append(" = UTF8String.fromString(\n                          new ").append(digestUtils).append("(").append(messageDigestAlgorithms).append(".SHA_224).digestAsHex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 256 || ").append((String)eval2).append(" == 0) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha256Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 384) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha384Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 512) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha512Hex(").append((String)eval1).append("));\n        } else {\n          ").append(ev.isNull()).append(" = true;\n        }\n      ").toString());
    }

    @Override
    public Sha2 withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

