/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.6034991609278433\n      > SELECT _FUNC_(null);\n       1.6034991609278433\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u0011#\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011\u0015\u0011\u0006\u0001\"\u0001Y\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015Y\b\u0001\"\u0011}\u0011\u00199\u0003\u0001\"\u0011\u0002\b!9\u0011\u0011\u0004\u0001\u0005R\u0005m\u0001\"CA\u0011\u0001\u0005\u0005I\u0011AA\u0012\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0013\u0011\n\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"a\u0019\u0001\u0003\u0003%\t!!\u001a\t\u0013\u0005-\u0004!!A\u0005B\u00055\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\ty\bAA\u0001\n\u0003\n\t\tC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\u001e9\u0011\u0011\u0017\u0012\t\u0002\u0005MfAB\u0011#\u0011\u0003\t)\f\u0003\u0004S3\u0011\u0005\u0011q\u0019\u0005\b\u0003\u0013LB\u0011AAf\u0011%\tI-GA\u0001\n\u0003\u000by\rC\u0005\u0002Vf\t\n\u0011\"\u0001\u0002D!I\u0011q[\r\u0002\u0002\u0013\u0005\u0015\u0011\u001c\u0005\n\u0003WL\u0012\u0013!C\u0001\u0003\u0007B\u0011\"!<\u001a\u0003\u0003%I!a<\u0003\u000bI\u000bg\u000e\u001a8\u000b\u0005\r\"\u0013aC3yaJ,7o]5p]NT!!\n\u0014\u0002\u0011\r\fG/\u00197zgRT!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u00195uA\u0011\u0011GM\u0007\u0002E%\u00111G\t\u0002\u0004%\u0012;\u0005CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$a\u0002)s_\u0012,8\r\u001e\t\u0003w\rs!\u0001P!\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}r\u0013A\u0002\u001fs_>$h(C\u00018\u0013\t\u0011e'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011+%\u0001D*fe&\fG.\u001b>bE2,'B\u0001\"7\u0003\u0015\u0019\u0007.\u001b7e+\u0005A\u0005CA\u0019J\u0013\tQ%E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013\u0001\u00035jI\u0016\u001cV-\u001a3\u0016\u00039\u0003\"!N(\n\u0005A3$a\u0002\"p_2,\u0017M\\\u0001\nQ&$WmU3fI\u0002\na\u0001P5oSRtDc\u0001+V-B\u0011\u0011\u0007\u0001\u0005\u0006\r\u0016\u0001\r\u0001\u0013\u0005\b\u0019\u0016\u0001\n\u00111\u0001O)\u0005!FC\u0001+Z\u0011\u00151u\u00011\u0001I\u0003-9\u0018\u000e\u001e5OK^\u001cV-\u001a3\u0015\u0005Qc\u0006\"B/\t\u0001\u0004q\u0016\u0001B:fK\u0012\u0004\"!N0\n\u0005\u00014$\u0001\u0002'p]\u001e\fA\"\u001a<bY&sG/\u001a:oC2$\"a\u00194\u0011\u0005U\"\u0017BA37\u0005\u0019!u.\u001e2mK\")q-\u0003a\u0001Q\u0006)\u0011N\u001c9viB\u0011\u0011N[\u0007\u0002I%\u00111\u000e\n\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u0019a\u000e^=\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0014\u0013aB2pI\u0016<WM\\\u0005\u0003gB\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006k*\u0001\rA^\u0001\u0004GRD\bCA8x\u0013\tA\bO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000biT\u0001\u0019\u00018\u0002\u0005\u00154\u0018!\u00044mCR\f%oZ;nK:$8/F\u0001~!\u0011Yd0!\u0001\n\u0005},%\u0001C%uKJ\fGo\u001c:\u0011\u0007U\n\u0019!C\u0002\u0002\u0006Y\u00121!\u00118z+\t\tI\u0001\u0005\u0003\u0002\f\u0005Ma\u0002BA\u0007\u0003\u001f\u0001\"!\u0010\u001c\n\u0007\u0005Ea'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#1\u0014\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002U\u0003;Aa!a\b\u000e\u0001\u0004A\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0006)\u0006\u0015\u0012q\u0005\u0005\b\r:\u0001\n\u00111\u0001I\u0011\u001dae\u0002%AA\u00029\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002.)\u001a\u0001*a\f,\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000f7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\t)DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002F)\u001aa*a\f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\t1\fgn\u001a\u0006\u0003\u0003+\nAA[1wC&!\u0011QCA(\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0006E\u00026\u0003?J1!!\u00197\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t!a\u001a\t\u0013\u0005%4#!AA\u0002\u0005u\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002pA1\u0011\u0011OA<\u0003\u0003i!!a\u001d\u000b\u0007\u0005Ud'\u0001\u0006d_2dWm\u0019;j_:L1a`A:\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001(\u0002~!I\u0011\u0011N\u000b\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002L\u0005\r\u0005\"CA5-\u0005\u0005\t\u0019AA/\u0003\u0019)\u0017/^1mgR\u0019a*!#\t\u0013\u0005%t#!AA\u0002\u0005\u0005\u0001f\u0006\u0001\u0002\u000e\u0006M\u0015QSAM\u00037\u000by*!)\u0002&\u0006\u001d\u00161VAW!\r\t\u0014qR\u0005\u0004\u0003#\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003/\u000b\u00111E0G+:\u001bu\fK.tK\u0016$W,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]1oI>l\u0007E^1mk\u0016\u0004s/\u001b;iA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011b]\u0012\u0004\u0013\u000eZ3oi&\u001c\u0017\r\u001c7zA\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AY\fG.^3tA\u0011\u0014\u0018m\u001e8!MJ|W\u000e\t;iK\u0002\u001aH/\u00198eCJ$\u0007E\\8s[\u0006d\u0007\u0005Z5tiJL'-\u001e;j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0015!!\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\f\u0019/gI*D'\r\u001b8sa\u001a\u0004\u0007\u000f\u00193qaR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AErc\u0007M\u001a5se\nd\u0007M\u001d3oa\"4g\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c92\u0004g\r\u001b:sE2\u0004'\u000f\u001a8qQ\u001a4G\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\r\u0016A\u000f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u00020\u0006QQ.\u0019;i?\u001a,hnY:\u0002\u000bI\u000bg\u000e\u001a8\u0011\u0005EJ2#B\r\u00028\u0006u\u0006cA\u001b\u0002:&\u0019\u00111\u0018\u001c\u0003\r\u0005s\u0017PU3g!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003'\n!![8\n\u0007\u0011\u000b\t\r\u0006\u0002\u00024\u0006)\u0011\r\u001d9msR\u0019A+!4\t\u000bu[\u0002\u0019\u00010\u0015\u000bQ\u000b\t.a5\t\u000b\u0019c\u0002\u0019\u0001%\t\u000f1c\u0002\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m\u0017q\u001d\t\u0006k\u0005u\u0017\u0011]\u0005\u0004\u0003?4$AB(qi&|g\u000eE\u00036\u0003GDe*C\u0002\u0002fZ\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAu=\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003c\u0004B!!\u0014\u0002t&!\u0011Q_A(\u0005\u0019y%M[3di\u0002")
public class Randn
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Randn$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Randn x$0) {
        return Randn$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Randn$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(7).append("randn(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Randn withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Randn copy(Expression child, boolean hideSeed) {
        return new Randn(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "hideSeed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        if (this.hideSeed() != randn.hideSeed()) return false;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Randn() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Randn(Expression child) {
        this(child, false);
    }
}

