/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AesEncrypt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, key[, mode[, padding[, iv[, aad]]]]) - Returns an encrypted value of `expr` using AES in given `mode` with the specified `padding`.\n      Key lengths of 16, 24 and 32 bits are supported. Supported combinations of (`mode`, `padding`) are ('ECB', 'PKCS'), ('GCM', 'NONE') and ('CBC', 'PKCS').\n      Optional initialization vectors (IVs) are only supported for CBC and GCM modes. These must be 16 bytes for CBC and 12 bytes for GCM. If not provided, a random vector will be generated and prepended to the output.\n      Optional additional authenticated data (AAD) is only supported for GCM. If provided for encryption, the identical AAD value must be provided for decryption.\n      The default mode is GCM.\n  ", arguments="\n    Arguments:\n      * expr - The binary value to encrypt.\n      * key - The passphrase to use to encrypt the data.\n      * mode - Specifies which block cipher mode should be used to encrypt messages.\n               Valid modes: ECB, GCM, CBC.\n      * padding - Specifies how to pad messages whose length is not a multiple of the block size.\n                  Valid values: PKCS, NONE, DEFAULT. The DEFAULT padding means PKCS for ECB, NONE for GCM and PKCS for CBC.\n      * iv - Optional initialization vector. Only supported for CBC and GCM modes.\n             Valid values: None or ''. 16-byte array for CBC mode. 12-byte array for GCM mode.\n      * aad - Optional additional authenticated data. Only supported for GCM mode. This can be any free-form input and\n              must be provided for both encryption and decryption.\n  ", examples="\n    Examples:\n      > SELECT hex(_FUNC_('Spark', '0000111122223333'));\n       83F16B2AA704794132802D248E6BFD4E380078182D1544813898AC97E709B28A94\n      > SELECT hex(_FUNC_('Spark SQL', '0000111122223333', 'GCM'));\n       6E7CA17BBB468D3084B5744BCA729FB7B2B7BCB8E4472847D02670489D95FA97DBBA7D3210\n      > SELECT base64(_FUNC_('Spark SQL', '1234567890abcdef', 'ECB', 'PKCS'));\n       3lmwu+Mw0H3fi5NDvcu9lg==\n      > SELECT base64(_FUNC_('Apache Spark', '1234567890abcdef', 'CBC', 'DEFAULT'));\n       2NYmDCjgXTbbxGA3/SnJEfFC/JQ7olk2VQWReIAAFKo=\n      > SELECT base64(_FUNC_('Spark', 'abcdefghijklmnop12345678ABCDEFGH', 'CBC', 'DEFAULT', unhex('00000000000000000000000000000000')));\n       AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg=\n      > SELECT base64(_FUNC_('Spark', 'abcdefghijklmnop12345678ABCDEFGH', 'GCM', 'DEFAULT', unhex('000000000000000000000000'), 'This is an AAD mixed into the input'));\n       AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4\n  ", since="3.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\teb\u0001\u0002\u0017.\u0001jB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t3\u0002\u0011\t\u0012)A\u0005w!A!\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005\\\u0001\tE\t\u0015!\u0003<\u0011!a\u0006A!f\u0001\n\u0003A\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B\u001e\t\u0011y\u0003!Q3A\u0005\u0002aC\u0001b\u0018\u0001\u0003\u0012\u0003\u0006Ia\u000f\u0005\tA\u0002\u0011)\u001a!C\u00011\"A\u0011\r\u0001B\tB\u0003%1\b\u0003\u0005c\u0001\tU\r\u0011\"\u0001Y\u0011!\u0019\u0007A!E!\u0002\u0013Y\u0004\"\u00023\u0001\t\u0003)\u0007\u0002C7\u0001\u0011\u000b\u0007I\u0011\t-\t\u000b\u0011\u0004A\u0011\u00018\t\u000b\u0011\u0004A\u0011\u0001;\t\u000b\u0011\u0004A\u0011A=\t\u000b\u0011\u0004A\u0011A?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003c\u0001A\u0011KA\u001a\u0011%\ty\u0004AA\u0001\n\u0003\t\t\u0005C\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002R!I\u0011q\r\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003#B\u0011\"a\u001b\u0001#\u0003%\t!!\u0015\t\u0013\u00055\u0004!%A\u0005\u0002\u0005E\u0003\"CA8\u0001E\u0005I\u0011AA)\u0011%\t\t\bAA\u0001\n\u0003\n\u0019\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;C\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005]\u0006!!A\u0005B\u0005e\u0006\"CA_\u0001\u0005\u0005I\u0011IA`\u000f%\tI/LA\u0001\u0012\u0003\tYO\u0002\u0005-[\u0005\u0005\t\u0012AAw\u0011\u0019!g\u0005\"\u0001\u0003\u0006!I!q\u0001\u0014\u0002\u0002\u0013\u0015#\u0011\u0002\u0005\n\u0005\u00171\u0013\u0011!CA\u0005\u001bA\u0011Ba\u0007'\u0003\u0003%\tI!\b\t\u0013\t=b%!A\u0005\n\tE\"AC!fg\u0016s7M]=qi*\u0011afL\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00021c\u0005A1-\u0019;bYf\u001cHO\u0003\u00023g\u0005\u00191/\u001d7\u000b\u0005Q*\u0014!B:qCJ\\'B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001w}\u0012Ui\u0013\t\u0003yuj\u0011!L\u0005\u0003}5\u0012!\"\u0012=qe\u0016\u001c8/[8o!\ta\u0004)\u0003\u0002B[\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\ta4)\u0003\u0002E[\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuIA\u0004Qe>$Wo\u0019;\u0011\u00051#fBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001\u0016(\u0001\u0004=e>|GOP\u0005\u0002\u0011&\u00111kR\u0001\ba\u0006\u001c7.Y4f\u0013\t)fK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002T\u000f\u0006)\u0011N\u001c9viV\t1(\u0001\u0004j]B,H\u000fI\u0001\u0004W\u0016L\u0018\u0001B6fs\u0002\nA!\\8eK\u0006)Qn\u001c3fA\u00059\u0001/\u00193eS:<\u0017\u0001\u00039bI\u0012Lgn\u001a\u0011\u0002\u0005%4\u0018aA5wA\u0005\u0019\u0011-\u00193\u0002\t\u0005\fG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u0019<\u0007.\u001b6lYB\u0011A\b\u0001\u0005\u0006/6\u0001\ra\u000f\u0005\u000656\u0001\ra\u000f\u0005\u000696\u0001\ra\u000f\u0005\u0006=6\u0001\ra\u000f\u0005\u0006A6\u0001\ra\u000f\u0005\u0006E6\u0001\raO\u0001\fe\u0016\u0004H.Y2f[\u0016tG\u000f\u0006\u0004g_B\f(o\u001d\u0005\u0006/>\u0001\ra\u000f\u0005\u00065>\u0001\ra\u000f\u0005\u00069>\u0001\ra\u000f\u0005\u0006=>\u0001\ra\u000f\u0005\u0006A>\u0001\ra\u000f\u000b\u0006MV4x\u000f\u001f\u0005\u0006/B\u0001\ra\u000f\u0005\u00065B\u0001\ra\u000f\u0005\u00069B\u0001\ra\u000f\u0005\u0006=B\u0001\ra\u000f\u000b\u0005Mj\\H\u0010C\u0003X#\u0001\u00071\bC\u0003[#\u0001\u00071\bC\u0003]#\u0001\u00071\bF\u0002g}~DQa\u0016\nA\u0002mBQA\u0017\nA\u0002m\n!\u0002\u001d:fiRLh*Y7f+\t\t)\u0001\u0005\u0003\u0002\b\u0005=a\u0002BA\u0005\u0003\u0017\u0001\"AT$\n\u0007\u00055q)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b9\u0015AC5oaV$H+\u001f9fgV\u0011\u0011\u0011\u0004\t\u0006\u0019\u0006m\u0011qD\u0005\u0004\u0003;1&aA*fcB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&E\nQ\u0001^=qKNLA!!\u000b\u0002$\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tG\"LG\u000e\u001a:f]V\u0011\u0011q\u0006\t\u0005\u0019\u0006m1(A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191(!\u000e\t\u000f\u0005]b\u00031\u0001\u0002:\u0005Ya.Z<DQ&dGM]3o!\u0011a\u00151H\u001e\n\u0007\u0005ubK\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsRia-a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001bBqaV\f\u0011\u0002\u0003\u00071\bC\u0004[/A\u0005\t\u0019A\u001e\t\u000fq;\u0002\u0013!a\u0001w!9al\u0006I\u0001\u0002\u0004Y\u0004b\u00021\u0018!\u0003\u0005\ra\u000f\u0005\bE^\u0001\n\u00111\u0001<\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0015+\u0007m\n)f\u000b\u0002\u0002XA!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013!C;oG\",7m[3e\u0015\r\t\tgR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA3\u00037\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014\u0001\u00027b]\u001eT!!a \u0002\t)\fg/Y\u0005\u0005\u0003#\tI(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\bB\u0019a)!#\n\u0007\u0005-uIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0012\u0006]\u0005c\u0001$\u0002\u0014&\u0019\u0011QS$\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001a\u0002\n\t\u00111\u0001\u0002\b\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a(\u0011\r\u0005\u0005\u0016qUAI\u001b\t\t\u0019KC\u0002\u0002&\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI+a)\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003_\u000b)\fE\u0002G\u0003cK1!a-H\u0005\u001d\u0011un\u001c7fC:D\u0011\"!'#\u0003\u0003\u0005\r!!%\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003k\nY\fC\u0005\u0002\u001a\u000e\n\t\u00111\u0001\u0002\b\u00061Q-];bYN$B!a,\u0002B\"I\u0011\u0011\u0014\u0013\u0002\u0002\u0003\u0007\u0011\u0011\u0013\u0015\u0018\u0001\u0005\u0015\u00171ZAg\u0003#\f\u0019.a6\u0002Z\u0006u\u0017q\\Ar\u0003K\u00042\u0001PAd\u0013\r\tI-\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty-ACU\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003e[3z72\u0002Sn\u001c3f72\u0002\u0003/\u00193eS:<7\f\f\u0011jmnc\u0003%Y1e;vkV,\u000b\u0011.AI+G/\u001e:og\u0002\ng\u000eI3oGJL\b\u000f^3eAY\fG.^3!_\u001a\u0004\u0003-\u001a=qe\u0002\u0004So]5oO\u0002\nUi\u0015\u0011j]\u0002:\u0017N^3oA\u0001lw\u000eZ3aA]LG\u000f\u001b\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011aa\u0006$G-\u001b8hA:R\u0001\u0005\t\u0011!A\u0001ZU-\u001f\u0011mK:<G\u000f[:!_\u001a\u0004\u0013G\u000e\u0017!eQ\u0002\u0013M\u001c3!gI\u0002#-\u001b;tA\u0005\u0014X\rI:vaB|'\u000f^3e]\u0001\u001aV\u000f\u001d9peR,G\rI2p[\nLg.\u0019;j_:\u001c\be\u001c4!Q\u0001lw\u000eZ3aY\u0001\u0002\u0007/\u00193eS:<\u0007-\u000b\u0011be\u0016\u0004\u0003fJ#D\u0005\u001eb\u0003e\n)L\u0007N;\u0013\u0006\f\u0011)O\u001d\u001bUj\n\u0017!O9{e*R\u0014*A\u0005tG\r\t\u0015(\u0007\n\u001bu\u0005\f\u0011(!.\u001b5kJ\u0015/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u001fB$\u0018n\u001c8bY\u0002Jg.\u001b;jC2L'0\u0019;j_:\u0004c/Z2u_J\u001c\b\u0005K%Wg&\u0002\u0013M]3!_:d\u0017\u0010I:vaB|'\u000f^3eA\u0019|'\u000fI\"C\u0007\u0002\ng\u000e\u001a\u0011H\u00076\u0003Sn\u001c3fg:\u0002C\u000b[3tK\u0002jWo\u001d;!E\u0016\u0004\u0013G\u000e\u0011csR,7\u000f\t4pe\u0002\u001a%i\u0011\u0011b]\u0012\u0004\u0013G\r\u0011csR,7\u000f\t4pe\u0002:5)\u0014\u0018!\u0013\u001a\u0004cn\u001c;!aJ|g/\u001b3fI2\u0002\u0013\r\t:b]\u0012|W\u000e\t<fGR|'\u000fI<jY2\u0004#-\u001a\u0011hK:,'/\u0019;fI\u0002\ng\u000e\u001a\u0011qe\u0016\u0004XM\u001c3fI\u0002\"x\u000e\t;iK\u0002zW\u000f\u001e9vi:R\u0001\u0005\t\u0011!A\u0001z\u0005\u000f^5p]\u0006d\u0007%\u00193eSRLwN\\1mA\u0005,H\u000f[3oi&\u001c\u0017\r^3eA\u0011\fG/\u0019\u0011)\u0003\u0006#\u0015\u0006I5tA=tG.\u001f\u0011tkB\u0004xN\u001d;fI\u00022wN\u001d\u0011H\u00076s\u0003%\u00134!aJ|g/\u001b3fI\u00022wN\u001d\u0011f]\u000e\u0014\u0018\u0010\u001d;j_:d\u0003\u0005\u001e5fA%$WM\u001c;jG\u0006d\u0007%Q!EAY\fG.^3![V\u001cH\u000f\t2fAA\u0014xN^5eK\u0012\u0004cm\u001c:!I\u0016\u001c'/\u001f9uS>tgF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0011,g-Y;mi\u0002jw\u000eZ3!SN\u0004siQ'/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t).\u0001DB\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sA5\u0002C\u000b[3!E&t\u0017M]=!m\u0006dW/\u001a\u0011u_\u0002*gn\u0019:zaRt#\u0002\t\u0011!A\u0001\u0002#\u0006I6fs\u0002j\u0003\u0005\u00165fAA\f7o\u001d9ie\u0006\u001cX\r\t;pAU\u001cX\r\t;pA\u0015t7M]=qi\u0002\"\b.\u001a\u0011eCR\fgF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011n_\u0012,\u0007%\f\u0011Ta\u0016\u001c\u0017NZ5fg\u0002:\b.[2iA\tdwnY6!G&\u0004\b.\u001a:![>$W\rI:i_VdG\r\t2fAU\u001cX\r\u001a\u0011u_\u0002*gn\u0019:zaR\u0004S.Z:tC\u001e,7O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!-\u0006d\u0017\u000e\u001a\u0011n_\u0012,7O\u000f\u0011F\u0007\nc\u0003eR\"NY\u0001\u001a%i\u0011\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AA\fG\rZ5oO\u0002j\u0003e\u00159fG&4\u0017.Z:!Q><\b\u0005^8!a\u0006$\u0007%\\3tg\u0006<Wm\u001d\u0011xQ>\u001cX\r\t7f]\u001e$\b\u000eI5tA9|G\u000fI1![VdG/\u001b9mK\u0002zg\r\t;iK\u0002\u0012Gn\\2lAML'0\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EV1mS\u0012\u0004c/\u00197vKNT\u0004\u0005U&D'2\u0002cj\u0014(FY\u0001\"UIR!V\u0019Rs\u0003\u0005\u00165fA\u0011+e)Q+M)\u0002\u0002\u0018\r\u001a3j]\u001e\u0004S.Z1og\u0002\u00026jQ*!M>\u0014\b%R\"CY\u0001ruJT#!M>\u0014\beR\"NA\u0005tG\r\t)L\u0007N\u0003cm\u001c:!\u0007\n\u001beF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011jm\u0002j\u0003e\u00149uS>t\u0017\r\u001c\u0011j]&$\u0018.\u00197ju\u0006$\u0018n\u001c8!m\u0016\u001cGo\u001c:/A=sG.\u001f\u0011tkB\u0004xN\u001d;fI\u00022wN\u001d\u0011D\u0005\u000e\u0003\u0013M\u001c3!\u000f\u000ek\u0005%\\8eKNt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c+\u00197jI\u00022\u0018\r\\;fgj\u0002cj\u001c8fA=\u0014\beJ\u0014/AE2TFY=uK\u0002\n'O]1zA\u0019|'\u000fI\"C\u0007\u0002jw\u000eZ3/AE\u0012TFY=uK\u0002\n'O]1zA\u0019|'\u000fI$D\u001b\u0002jw\u000eZ3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\n\u0017\r\u001a\u0011.A=\u0003H/[8oC2\u0004\u0013\r\u001a3ji&|g.\u00197!CV$\b.\u001a8uS\u000e\fG/\u001a3!I\u0006$\u0018M\f\u0011P]2L\be];qa>\u0014H/\u001a3!M>\u0014\beR\"NA5|G-\u001a\u0018!)\"L7\u000fI2b]\u0002\u0012W\rI1os\u00022'/Z3.M>\u0014X\u000eI5oaV$\b%\u00198e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5,8\u000f\u001e\u0011cK\u0002\u0002(o\u001c<jI\u0016$\u0007EZ8sA\t|G\u000f\u001b\u0011f]\u000e\u0014\u0018\u0010\u001d;j_:\u0004\u0013M\u001c3!I\u0016\u001c'/\u001f9uS>tgF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAn\u0003\u001d]$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t5fq\"zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003e\n\u00191aA\n\u0014'M\u00193eI\u00124gM\u001a4O%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001d4\rF2$IM!BoA\"t'\u000f\u001b2gIB\u0004G\r#3ia*eG\u0011$Ei\u0015\u001b\u0004\b\r\u00198qEB$\u0007R\u00196iQB\u0014g\r\u001d:q\u0005\u001b\u0015hN#8ae\u0012%\u0007O!:i)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0003.\u001a=)?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu\u0005\f\u0011(aA\u0002\u0004'M\u00192cI\u0012$GM\u001a4gM:C\u0006I\u0014H\u00076;\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!m\u0015;4)Q\u00198\u0005\n\u0013EG\u000e\u001dEgABDGQ\u001b8iQ\u00125)Q\u001c3s\u0019\u0013uG\u0011\u001aCo\t\u001b%\tO#5i]\u0012\u0004\bN\u001cEaI2t\u0007\r\u001b9s\u0011KTGR!:o\u0011\u0013%)Q\u001cEgI\n\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011cCN,g\u0007\u000e\u0015`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;C\u0006I\u00142eM\"TGN\u001c9sA\n'm\u00193fM\u001eb\u0003eJ#D\u0005\u001eb\u0003e\n)L\u0007N;\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g1lw/^\u0016NoBB5GZ56\u001d\u001238-^\u001dmOvj$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t2bg\u00164D\u0007K0G+:\u001bu\fK\u0014Ba\u0006\u001c\u0007.\u001a\u0011Ta\u0006\u00148n\n\u0017!OE\u00124\u0007N\u001b7oaJ\u0004'\u00192dI\u00164w\u0005\f\u0011(\u0007\n\u001bu\u0005\f\u0011(\t\u00163\u0015)\u0016'UO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001aO36$5I[4Y)\n\u0014\u0007pR!4_Ms'*\u00124G\u0007>R\u0015kN8mWJ2\u0016k\u0016*f\u0013\u0006\u000beiS8>\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0017m]37i!zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003eJ1cG\u0012,gm\u001a5jU.dWN\\8qcI\u001aD'\u000e\u001c8q\u0005\u00135\tR#G\u000f\";C\u0006I\u0014D\u0005\u000e;C\u0006I\u0014E\u000b\u001a\u000bU\u000b\u0014+(Y\u0001*h\u000e[3yQ\u001d\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u0019(S%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)\u0011)TIRjw+_'[k5DgO[5B!FSeNZ4>\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0017m]37i!zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003eJ1cG\u0012,gm\u001a5jU.dWN\\8qcI\u001aD'\u000e\u001c8q\u0005\u00135\tR#G\u000f\";C\u0006I\u0014H\u00076;C\u0006I\u0014E\u000b\u001a\u000bU\u000b\u0014+(Y\u0001*h\u000e[3yQ\u001d\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007M\u0014*Y\u0001:C\u000b[5tA%\u001c\b%\u00198!\u0003\u0006#\u0005%\\5yK\u0012\u0004\u0013N\u001c;pAQDW\rI5oaV$x%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015+[-jWM$F*\\\u001cL\tf*6M\u0017\u001aoYJ#\u0017\fR30!b#$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0005\u0018!B\u001a/g9\u0002\u0014!B4s_V\u0004\u0018EAAt\u0003)i\u0017n]2`MVt7m]\u0001\u000b\u0003\u0016\u001cXI\\2ssB$\bC\u0001\u001f''\u00151\u0013q^A~!-\t\t0a><wmZ4h\u000f4\u000e\u0005\u0005M(bAA{\u000f\u00069!/\u001e8uS6,\u0017\u0002BA}\u0003g\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\tiPa\u0001\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0003{\n!![8\n\u0007U\u000by\u0010\u0006\u0002\u0002l\u0006AAo\\*ue&tw\r\u0006\u0002\u0002v\u0005)\u0011\r\u001d9msRiaMa\u0004\u0003\u0012\tM!Q\u0003B\f\u00053AQaV\u0015A\u0002mBQAW\u0015A\u0002mBQ\u0001X\u0015A\u0002mBQAX\u0015A\u0002mBQ\u0001Y\u0015A\u0002mBQAY\u0015A\u0002m\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \t-\u0002#\u0002$\u0003\"\t\u0015\u0012b\u0001B\u0012\u000f\n1q\n\u001d;j_:\u0004\u0012B\u0012B\u0014wmZ4hO\u001e\n\u0007\t%rI\u0001\u0004UkBdWM\u000e\u0005\t\u0005[Q\u0013\u0011!a\u0001M\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tM\u0002\u0003BA<\u0005kIAAa\u000e\u0002z\t1qJ\u00196fGR\u0004")
public class AesEncrypt
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private final Expression key;
    private final Expression mode;
    private final Expression padding;
    private final Expression iv;
    private final Expression aad;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Expression, Expression>> unapply(AesEncrypt x$0) {
        return AesEncrypt$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Expression, Expression>, AesEncrypt> tupled() {
        return AesEncrypt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, AesEncrypt>>>>>> curried() {
        return AesEncrypt$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        AesEncrypt aesEncrypt = this;
        synchronized (aesEncrypt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    public Expression key() {
        return this.key;
    }

    public Expression mode() {
        return this.mode;
    }

    public Expression padding() {
        return this.padding;
    }

    public Expression iv() {
        return this.iv;
    }

    public Expression aad() {
        return this.aad;
    }

    private Expression replacement$lzycompute() {
        AesEncrypt aesEncrypt = this;
        synchronized (aesEncrypt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, (DataType)BinaryType$.MODULE$, "aesEncrypt", (Seq<Expression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.input(), this.key(), this.mode(), this.padding(), this.iv(), this.aad()}))), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "aes_encrypt";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, BinaryType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$, BinaryType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.input(), this.key(), this.mode(), this.padding(), this.iv(), this.aad()}));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5));
    }

    public AesEncrypt copy(Expression input, Expression key, Expression mode, Expression padding, Expression iv, Expression aad) {
        return new AesEncrypt(input, key, mode, padding, iv, aad);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.key();
    }

    public Expression copy$default$3() {
        return this.mode();
    }

    public Expression copy$default$4() {
        return this.padding();
    }

    public Expression copy$default$5() {
        return this.iv();
    }

    public Expression copy$default$6() {
        return this.aad();
    }

    @Override
    public String productPrefix() {
        return "AesEncrypt";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.key();
                break;
            }
            case 2: {
                object = this.mode();
                break;
            }
            case 3: {
                object = this.padding();
                break;
            }
            case 4: {
                object = this.iv();
                break;
            }
            case 5: {
                object = this.aad();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AesEncrypt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "input";
                break;
            }
            case 1: {
                string = "key";
                break;
            }
            case 2: {
                string = "mode";
                break;
            }
            case 3: {
                string = "padding";
                break;
            }
            case 4: {
                string = "iv";
                break;
            }
            case 5: {
                string = "aad";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AesEncrypt)) return false;
        boolean bl = true;
        if (!bl) return false;
        AesEncrypt aesEncrypt = (AesEncrypt)x$1;
        Expression expression = this.input();
        Expression expression2 = aesEncrypt.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.key();
        Expression expression4 = aesEncrypt.key();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mode();
        Expression expression6 = aesEncrypt.mode();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.padding();
        Expression expression8 = aesEncrypt.padding();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.iv();
        Expression expression10 = aesEncrypt.iv();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.aad();
        Expression expression12 = aesEncrypt.aad();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        if (!aesEncrypt.canEqual(this)) return false;
        return true;
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding, Expression iv, Expression aad) {
        this.input = input;
        this.key = key;
        this.mode = mode;
        this.padding = padding;
        this.iv = iv;
        this.aad = aad;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding, Expression iv) {
        this(input, key, mode, padding, iv, Literal$.MODULE$.apply(""));
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding) {
        this(input, key, mode, padding, Literal$.MODULE$.apply(""));
    }

    public AesEncrypt(Expression input, Expression key, Expression mode) {
        this(input, key, mode, Literal$.MODULE$.apply("DEFAULT"));
    }

    public AesEncrypt(Expression input, Expression key) {
        this(input, key, Literal$.MODULE$.apply("GCM"));
    }
}

