/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterSubscriber;
import java.time.Duration;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

class CorePublisherRateLimiterOperator<T> {
    private final CorePublisher<? extends T> source;
    private final RateLimiter rateLimiter;

    CorePublisherRateLimiterOperator(CorePublisher<? extends T> source, RateLimiter rateLimiter) {
        this.source = source;
        this.rateLimiter = rateLimiter;
    }

    void subscribe(CoreSubscriber<? super T> actual) {
        long waitDuration = this.rateLimiter.reservePermission();
        if (waitDuration >= 0L) {
            if (waitDuration > 0L) {
                this.delaySubscription(actual, waitDuration);
            } else {
                this.source.subscribe(new RateLimiterSubscriber<T>(this.rateLimiter, actual));
            }
        } else {
            Operators.error(actual, (Throwable)RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter));
        }
    }

    private void delaySubscription(CoreSubscriber<? super T> actual, long waitDuration) {
        Mono.delay((Duration)Duration.ofNanos(waitDuration)).subscribe(delay -> this.source.subscribe(new RateLimiterSubscriber(this.rateLimiter, actual)));
    }
}

