/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.impl;

import org.apache.pulsar.common.policies.data.BrokerStatus;

public final class BrokerStatusImpl
implements BrokerStatus {
    private String brokerAddress;
    private boolean active;
    private int loadFactor;

    public static BrokerStatusImplBuilder builder() {
        return new BrokerStatusImplBuilder();
    }

    @Override
    public int compareTo(BrokerStatus other) {
        int result = Integer.compare(this.loadFactor, other.getLoadFactor());
        if (result == 0) {
            result = this.brokerAddress.compareTo(other.getBrokerAddress());
        }
        return result;
    }

    @Override
    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void setBrokerAddress(String brokerAddress) {
        this.brokerAddress = brokerAddress;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerStatusImpl)) {
            return false;
        }
        BrokerStatusImpl other = (BrokerStatusImpl)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.getLoadFactor() != other.getLoadFactor()) {
            return false;
        }
        String this$brokerAddress = this.getBrokerAddress();
        String other$brokerAddress = other.getBrokerAddress();
        return !(this$brokerAddress == null ? other$brokerAddress != null : !this$brokerAddress.equals(other$brokerAddress));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + this.getLoadFactor();
        String $brokerAddress = this.getBrokerAddress();
        result = result * 59 + ($brokerAddress == null ? 43 : $brokerAddress.hashCode());
        return result;
    }

    public String toString() {
        return "BrokerStatusImpl(brokerAddress=" + this.getBrokerAddress() + ", active=" + this.isActive() + ", loadFactor=" + this.getLoadFactor() + ")";
    }

    public BrokerStatusImpl(String brokerAddress, boolean active, int loadFactor) {
        this.brokerAddress = brokerAddress;
        this.active = active;
        this.loadFactor = loadFactor;
    }

    public BrokerStatusImpl() {
    }

    public static class BrokerStatusImplBuilder
    implements BrokerStatus.Builder {
        private String brokerAddress;
        private boolean active;
        private int loadFactor;

        @Override
        public BrokerStatusImplBuilder brokerAddress(String brokerAddress) {
            this.brokerAddress = brokerAddress;
            return this;
        }

        @Override
        public BrokerStatusImplBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public BrokerStatusImplBuilder loadFactor(int loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        @Override
        public BrokerStatusImpl build() {
            return new BrokerStatusImpl(this.brokerAddress, this.active, this.loadFactor);
        }
    }
}

