/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;
import org.apache.dubbo.rpc.protocol.rest.message.MediaTypeMatcher;
import org.apache.dubbo.rpc.protocol.rest.util.DataParseUtils;

@Activate(value={"multiValue"})
public class MultiValueCodec
implements HttpMessageCodec<byte[], OutputStream> {
    @Override
    public Object decode(byte[] body, Class<?> targetType, Type type) throws Exception {
        Object map = DataParseUtils.multipartFormConvert(body, targetType);
        Map valuesMap = (Map)map;
        if (Map.class.isAssignableFrom(targetType)) {
            return map;
        }
        if (DataParseUtils.isTextType(targetType)) {
            Set set = valuesMap.keySet();
            ArrayList arrayList = new ArrayList(set);
            Object key = arrayList.get(0);
            Object value = valuesMap.get(key);
            if (value == null) {
                return null;
            }
            return DataParseUtils.stringTypeConvert(targetType, String.valueOf(((List)value).get(0)));
        }
        Map<String, Field> beanPropertyFields = ReflectUtils.getBeanPropertyFields(targetType);
        Object emptyObject = ReflectUtils.getEmptyObject(targetType);
        beanPropertyFields.entrySet().stream().forEach(entry -> {
            try {
                List values = (List)valuesMap.get(entry.getKey());
                String value = values == null ? null : String.valueOf(values.get(0));
                ((Field)entry.getValue()).set(emptyObject, DataParseUtils.stringTypeConvert(((Field)entry.getValue()).getType(), value));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        return emptyObject;
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class<?> targetType) {
        return MediaTypeMatcher.MULTI_VALUE.mediaSupport(mediaType);
    }

    @Override
    public boolean typeSupport(Class<?> targetType) {
        return false;
    }

    @Override
    public MediaType contentType() {
        return MediaType.APPLICATION_FORM_URLENCODED_VALUE;
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody, URL url) throws Exception {
        DataParseUtils.writeFormContent((Map)unSerializedBody, outputStream);
    }
}

