/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.script;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.support.RpcUtils;

public class ScriptStateRouter<T>
extends AbstractStateRouter<T> {
    public static final String NAME = "SCRIPT_ROUTER";
    private static final int SCRIPT_ROUTER_DEFAULT_PRIORITY = 0;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ScriptStateRouter.class);
    private static final ConcurrentMap<String, ScriptEngine> ENGINES = new ConcurrentHashMap<String, ScriptEngine>();
    private final ScriptEngine engine;
    private final String rule;
    private CompiledScript function;
    private AccessControlContext accessControlContext;

    public ScriptStateRouter(URL url) {
        super(url);
        Permissions perms = new Permissions();
        perms.add(new RuntimePermission("accessDeclaredMembers"));
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        this.accessControlContext = new AccessControlContext(new ProtectionDomain[]{domain});
        this.setUrl(url);
        this.engine = this.getEngine(url);
        this.rule = this.getRule(url);
        try {
            Compilable compilable = (Compilable)((Object)this.engine);
            this.function = compilable.compile(this.rule);
        }
        catch (ScriptException e) {
            logger.error("2-14", "script route rule invalid", "", "script route error, rule has been ignored. rule: " + this.rule + ", url: " + RpcContext.getServiceContext().getUrl(), e);
        }
    }

    private String getRule(URL url) {
        String vRule = url.getParameterAndDecoded("rule");
        if (StringUtils.isEmpty(vRule)) {
            throw new IllegalStateException("route rule can not be empty.");
        }
        return vRule;
    }

    private ScriptEngine getEngine(URL url) {
        String type = url.getParameter("type", "javascript");
        return ConcurrentHashMapUtils.computeIfAbsent(ENGINES, type, t -> {
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(type);
            if (scriptEngine == null) {
                throw new IllegalStateException("unsupported route engine type: " + type);
            }
            return scriptEngine;
        });
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        if (this.engine == null || this.function == null) {
            if (needToPrintMessage) {
                messageHolder.set("Directly Return. Reason: engine or function is null");
            }
            return invokers;
        }
        Bindings bindings = this.createBindings(invokers, invocation);
        return this.getRoutedInvokers(invokers, AccessController.doPrivileged(() -> {
            try {
                return this.function.eval(bindings);
            }
            catch (ScriptException e) {
                logger.error("2-14", "Scriptrouter exec script error", "", "Script route error, rule has been ignored. rule: " + this.rule + ", method:" + RpcUtils.getMethodName(invocation) + ", url: " + RpcContext.getContext().getUrl(), e);
                return invokers;
            }
        }, this.accessControlContext));
    }

    protected BitList<Invoker<T>> getRoutedInvokers(BitList<Invoker<T>> invokers, Object obj) {
        Object result = invokers.clone();
        if (obj instanceof Invoker[]) {
            ((AbstractCollection)result).retainAll(Arrays.asList((Invoker[])obj));
        } else if (obj instanceof Object[]) {
            ((AbstractCollection)result).retainAll(Arrays.stream((Object[])obj).map(item -> (Invoker)item).collect(Collectors.toList()));
        } else {
            ((AbstractCollection)result).retainAll((List)obj);
        }
        return result;
    }

    private Bindings createBindings(List<Invoker<T>> invokers, Invocation invocation) {
        Bindings bindings = this.engine.createBindings();
        bindings.put("invokers", (Object)new ArrayList<Invoker<T>>(invokers));
        bindings.put("invocation", (Object)invocation);
        bindings.put("context", (Object)RpcContext.getClientAttachment());
        return bindings;
    }

    @Override
    public boolean isRuntime() {
        return this.getUrl().getParameter("runtime", false);
    }

    @Override
    public boolean isForce() {
        return this.getUrl().getParameter("force", false);
    }
}

