/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.rpc.cluster.router.mesh.util.MeshRuleListener;

public class MeshRuleDispatcher {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MeshRuleDispatcher.class);
    private final String appName;
    private final ConcurrentMap<String, Set<MeshRuleListener>> listenerMap = new ConcurrentHashMap<String, Set<MeshRuleListener>>();

    public MeshRuleDispatcher(String appName) {
        this.appName = appName;
    }

    public synchronized void post(Map<String, List<Map<String, Object>>> ruleMap) {
        if (ruleMap.isEmpty()) {
            for (Map.Entry entry : this.listenerMap.entrySet()) {
                for (MeshRuleListener listener : (Set)entry.getValue()) {
                    listener.clearRule(this.appName);
                }
            }
        } else {
            for (Map.Entry<String, List<Map<String, Object>>> entry : ruleMap.entrySet()) {
                String ruleType = entry.getKey();
                Set listeners = (Set)this.listenerMap.get(ruleType);
                if (CollectionUtils.isNotEmpty(listeners)) {
                    for (MeshRuleListener listener : listeners) {
                        listener.onRuleChange(this.appName, entry.getValue());
                    }
                    continue;
                }
                logger.warn("2-18", "Receive mesh rule but none of listener has been registered", "", "Receive rule but none of listener has been registered. Maybe type not matched. Rule Type: " + ruleType);
            }
            for (Map.Entry<String, List<Map<String, Object>>> entry : this.listenerMap.entrySet()) {
                if (ruleMap.containsKey(entry.getKey())) continue;
                for (MeshRuleListener listener : (Set)((Object)entry.getValue())) {
                    listener.clearRule(this.appName);
                }
            }
        }
    }

    public synchronized void register(MeshRuleListener listener) {
        if (listener == null) {
            return;
        }
        ConcurrentHashMapUtils.computeIfAbsent(this.listenerMap, listener.ruleSuffix(), k -> new ConcurrentHashSet()).add(listener);
    }

    public synchronized void unregister(MeshRuleListener listener) {
        if (listener == null) {
            return;
        }
        Set listeners = (Set)this.listenerMap.get(listener.ruleSuffix());
        if (CollectionUtils.isNotEmpty(listeners)) {
            listeners.remove(listener);
        }
        if (CollectionUtils.isEmpty(listeners)) {
            this.listenerMap.remove(listener.ruleSuffix());
        }
    }

    public boolean isEmpty() {
        return this.listenerMap.isEmpty();
    }

    @Deprecated
    public Map<String, Set<MeshRuleListener>> getListenerMap() {
        return this.listenerMap;
    }
}

