/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.reactive;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.util.annotation.NonNull;

public abstract class AbstractTripleReactorSubscriber<T>
implements Subscriber<T>,
CoreSubscriber<T> {
    private volatile boolean isCancelled;
    protected volatile CallStreamObserver<T> downstream;
    private final AtomicBoolean SUBSCRIBED = new AtomicBoolean();
    private volatile Subscription subscription;
    private final AtomicBoolean HAS_SUBSCRIBED = new AtomicBoolean();
    private volatile boolean isDone;

    public void subscribe(CallStreamObserver<T> downstream) {
        if (downstream == null) {
            throw new NullPointerException();
        }
        if (this.SUBSCRIBED.compareAndSet(false, true)) {
            this.downstream = downstream;
            this.subscription.request(1L);
        }
    }

    public void onSubscribe(@NonNull Subscription subscription) {
        if (this.subscription == null && this.HAS_SUBSCRIBED.compareAndSet(false, true)) {
            this.subscription = subscription;
            return;
        }
        subscription.cancel();
    }

    public void onNext(T t) {
        if (!this.isDone && !this.isCanceled()) {
            this.downstream.onNext(t);
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable throwable) {
        if (!this.isCanceled()) {
            this.isDone = true;
            this.downstream.onError(throwable);
        }
    }

    public void onComplete() {
        if (!this.isCanceled()) {
            this.isDone = true;
            this.downstream.onCompleted();
        }
    }

    public void cancel() {
        if (!this.isCancelled && this.subscription != null) {
            this.isCancelled = true;
            this.subscription.cancel();
        }
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }
}

