/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ServiceKeyMetric;
import org.apache.dubbo.metrics.model.container.AtomicLongContainer;
import org.apache.dubbo.metrics.model.container.LongAccumulatorContainer;
import org.apache.dubbo.metrics.model.container.LongContainer;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.AbstractMetricsExport;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RtStatComposite
extends AbstractMetricsExport {
    private final AtomicBoolean samplesChanged = new AtomicBoolean(true);
    private final Map<String, List<LongContainer<? extends Number>>> rtStats = new ConcurrentHashMap<String, List<LongContainer<? extends Number>>>();

    public RtStatComposite(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public void init(MetricsPlaceValue ... placeValues) {
        if (placeValues == null) {
            return;
        }
        for (MetricsPlaceValue placeValue : placeValues) {
            List<LongContainer<? extends Number>> containers = this.initStats(placeValue);
            for (LongContainer<? extends Number> container : containers) {
                this.rtStats.computeIfAbsent(container.getMetricsKeyWrapper().getType(), k -> new ArrayList()).add(container);
            }
        }
        this.samplesChanged.set(true);
    }

    private List<LongContainer<? extends Number>> initStats(MetricsPlaceValue placeValue) {
        ArrayList<LongContainer<? extends Number>> singleRtStats = new ArrayList<LongContainer<? extends Number>>();
        singleRtStats.add(new AtomicLongContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_LAST, placeValue)));
        singleRtStats.add(new LongAccumulatorContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_MIN, placeValue), new LongAccumulator(Long::min, Long.MAX_VALUE)));
        singleRtStats.add(new LongAccumulatorContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_MAX, placeValue), new LongAccumulator(Long::max, Long.MIN_VALUE)));
        singleRtStats.add(new AtomicLongContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_SUM, placeValue), (responseTime, longAccumulator) -> longAccumulator.addAndGet((long)responseTime)));
        AtomicLongContainer avgContainer = new AtomicLongContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_AVG, placeValue), (k, v) -> v.incrementAndGet());
        avgContainer.setValueSupplier(applicationName -> {
            LongContainer totalContainer = this.rtStats.values().stream().flatMap(Collection::stream).filter(longContainer -> longContainer.isKeyWrapper(MetricsKey.METRIC_RT_SUM, placeValue.getType())).findFirst().get();
            AtomicLong totalRtTimes = (AtomicLong)avgContainer.get(applicationName);
            AtomicLong totalRtSum = (AtomicLong)totalContainer.get(applicationName);
            return totalRtSum.get() / totalRtTimes.get();
        });
        singleRtStats.add(avgContainer);
        return singleRtStats;
    }

    public void calcServiceKeyRt(String registryOpType, Long responseTime, Metric key) {
        for (LongContainer<? extends Number> container : this.rtStats.get(registryOpType)) {
            Number current = (Number)container.get(key);
            if (current == null) {
                container.putIfAbsent(key, container.getInitFunc().apply(key));
                this.samplesChanged.set(true);
                current = (Number)container.get(key);
            }
            container.getConsumerFunc().accept(responseTime, current);
        }
    }

    public void calcServiceKeyRt(Invocation invocation, String registryOpType, Long responseTime) {
        List actions;
        if (invocation.getServiceModel() != null && invocation.getServiceModel().getServiceKey() != null) {
            Map<String, Object> attributeMap = invocation.getServiceModel().getServiceMetadata().getAttributeMap();
            Map cache = (Map)attributeMap.get("ServiceKeyRt");
            if (cache == null) {
                attributeMap.putIfAbsent("ServiceKeyRt", new ConcurrentHashMap(32));
                cache = (Map)attributeMap.get("ServiceKeyRt");
            }
            if ((actions = (List)cache.get(registryOpType)) == null) {
                actions = this.calServiceRtActions(invocation, registryOpType);
                cache.putIfAbsent(registryOpType, actions);
                this.samplesChanged.set(true);
                actions = (List)cache.get(registryOpType);
            }
        } else {
            actions = this.calServiceRtActions(invocation, registryOpType);
        }
        for (Action action : actions) {
            action.run(responseTime);
        }
    }

    private List<Action> calServiceRtActions(Invocation invocation, String registryOpType) {
        LinkedList<Action> actions = new LinkedList<Action>();
        ServiceKeyMetric key = new ServiceKeyMetric(this.getApplicationModel(), invocation.getTargetServiceUniqueName());
        for (LongContainer<? extends Number> container : this.rtStats.get(registryOpType)) {
            Number current = (Number)container.get(key);
            if (current == null) {
                container.putIfAbsent(key, container.getInitFunc().apply(key));
                this.samplesChanged.set(true);
                current = (Number)container.get(key);
            }
            actions.add(new Action(container.getConsumerFunc(), current));
        }
        return actions;
    }

    public void calcMethodKeyRt(Invocation invocation, String registryOpType, Long responseTime) {
        List actions;
        if (this.getServiceLevel() && invocation.getServiceModel() != null && invocation.getServiceModel().getServiceMetadata() != null) {
            Map<String, Object> attributeMap = invocation.getServiceModel().getServiceMetadata().getAttributeMap();
            Map cache = (Map)attributeMap.get("MethodKeyRt");
            if (cache == null) {
                attributeMap.putIfAbsent("MethodKeyRt", new ConcurrentHashMap(32));
                cache = (Map)attributeMap.get("MethodKeyRt");
            }
            if ((actions = (List)cache.get(registryOpType)) == null) {
                actions = this.calMethodRtActions(invocation, registryOpType);
                cache.putIfAbsent(registryOpType, actions);
                this.samplesChanged.set(true);
                actions = (List)cache.get(registryOpType);
            }
        } else {
            actions = this.calMethodRtActions(invocation, registryOpType);
        }
        for (Action action : actions) {
            action.run(responseTime);
        }
    }

    private List<Action> calMethodRtActions(Invocation invocation, String registryOpType) {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (LongContainer<? extends Number> container : this.rtStats.get(registryOpType)) {
            MethodMetric key;
            Number current = (Number)container.get(key = new MethodMetric(this.getApplicationModel(), invocation, this.getServiceLevel()));
            if (current == null) {
                container.putIfAbsent(key, container.getInitFunc().apply(key));
                this.samplesChanged.set(true);
                current = (Number)container.get(key);
            }
            actions.add(new Action(container.getConsumerFunc(), current));
        }
        return actions;
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (List<LongContainer<? extends Number>> containers : this.rtStats.values()) {
            for (LongContainer<? extends Number> container : containers) {
                MetricsKeyWrapper metricsKeyWrapper = container.getMetricsKeyWrapper();
                for (Metric key : container.keySet()) {
                    list.add(new GaugeMetricSample<Metric>(metricsKeyWrapper.targetKey(), metricsKeyWrapper.targetDesc(), key.getTags(), category, key, value -> container.getValueSupplier().apply((Metric)value).longValue()));
                }
            }
        }
        return list;
    }

    public List<LongContainer<? extends Number>> getRtStats() {
        return this.rtStats.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean calSamplesChanged() {
        return this.samplesChanged.compareAndSet(true, false);
    }

    private static class Action {
        private final BiConsumer<Long, Number> consumerFunc;
        private final Number initValue;

        public Action(BiConsumer<Long, Number> consumerFunc, Number initValue) {
            this.consumerFunc = consumerFunc;
            this.initValue = initValue;
        }

        public void run(Long responseTime) {
            this.consumerFunc.accept(responseTime, this.initValue);
        }
    }
}

