/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.dubbo.config.spring.util.LazyTargetSource;

public class LazyTargetInvocationHandler
implements InvocationHandler {
    private final LazyTargetSource lazyTargetSource;
    private volatile Object target;

    public LazyTargetInvocationHandler(LazyTargetSource lazyTargetSource) {
        this.lazyTargetSource = lazyTargetSource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block10: {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 0) {
                if ("toString".equals(methodName)) {
                    if (this.target != null) {
                        return this.target.toString();
                    }
                    return this.toString();
                }
                if ("hashCode".equals(methodName)) {
                    return this.hashCode();
                }
            } else if (parameterTypes.length == 1 && "equals".equals(methodName)) {
                return this.equals(args[0]);
            }
            if (this.target == null) {
                this.target = this.lazyTargetSource.getTarget();
            }
            if (method.getDeclaringClass().isInstance(this.target)) {
                try {
                    return method.invoke(this.target, args);
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    if (targetException == null) break block10;
                    throw targetException;
                }
            }
        }
        throw new IllegalStateException("The proxied interface [" + method.getDeclaringClass() + "] contains a method [" + method + "] that is not implemented by the proxy class [" + this.target.getClass() + "]");
    }
}

