/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.route;

import com.tencent.polaris.api.config.provider.ServiceConfig;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.pojo.RouteArgument;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.rpc.RuleBasedRouterFailoverType;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RouteInfo {
    private final SourceService sourceService;
    private final ServiceMetadata destService;
    private ServiceRule sourceRouteRule;
    private ServiceRule destRouteRule;
    private String canary;
    private final Map<StatusDimension.Level, StatusDimension> statusDimensions;
    private final Map<String, Boolean> chainEnable = new HashMap<String, Boolean>();
    private boolean includeUnhealthyInstances;
    private boolean includeCircuitBreakInstances;
    private MetadataFailoverType metadataFailoverType;
    private RuleBasedRouterFailoverType ruleBasedRouterFailoverType;
    private Map<String, Map<String, String>> routerMetadata = new HashMap<String, Map<String, String>>();
    private RouteResult.NextRouterInfo nextRouterInfo;
    private String subsetName;
    private Map<String, ModelProto.MatchString> subsetMetadata;

    public RouteInfo(SourceService sourceService, ServiceRule sourceRouteRule, ServiceMetadata destService, ServiceRule destRouteRule, String method, ServiceConfig serviceConfig) {
        if (RouteInfo.isEmptyService(sourceService) && !RouteInfo.isEmptyService(serviceConfig)) {
            this.sourceService = new SourceService();
            this.sourceService.setNamespace(serviceConfig.getNamespace());
            this.sourceService.setService(serviceConfig.getName());
        } else {
            this.sourceService = sourceService;
        }
        if (Objects.nonNull(sourceService)) {
            this.routerMetadata.computeIfAbsent("ruleRouter", k -> new HashMap());
            this.routerMetadata.get("ruleRouter").putAll(sourceService.getLabels());
        }
        this.sourceRouteRule = sourceRouteRule;
        this.destService = destService;
        this.destRouteRule = destRouteRule;
        HashMap<StatusDimension.Level, StatusDimension> dimensionMap = new HashMap<StatusDimension.Level, StatusDimension>();
        dimensionMap.put(StatusDimension.Level.SERVICE, StatusDimension.EMPTY_DIMENSION);
        if (StringUtils.isNotBlank(method)) {
            dimensionMap.put(StatusDimension.Level.ALL_CALLER, new StatusDimension(method, null));
        }
        if (Objects.nonNull(sourceService)) {
            dimensionMap.put(StatusDimension.Level.ALL_METHOD, new StatusDimension("", sourceService));
        }
        if (StringUtils.isNotBlank(method) && null != sourceService) {
            dimensionMap.put(StatusDimension.Level.CALLER_METHOD, new StatusDimension(method, sourceService));
        }
        this.statusDimensions = Collections.unmodifiableMap(dimensionMap);
    }

    public RouteInfo(SourceService sourceService, ServiceMetadata destService, String method, ServiceConfig serviceConfig) {
        this(sourceService, null, destService, null, method, serviceConfig);
    }

    public MetadataFailoverType getMetadataFailoverType() {
        return this.metadataFailoverType;
    }

    public void setMetadataFailoverType(MetadataFailoverType metadataFailoverType) {
        this.metadataFailoverType = metadataFailoverType;
    }

    public RuleBasedRouterFailoverType getRuleBasedRouterFailoverType() {
        return this.ruleBasedRouterFailoverType;
    }

    public void setRuleBasedRouterFailoverType(RuleBasedRouterFailoverType ruleBasedRouterFailoverType) {
        this.ruleBasedRouterFailoverType = ruleBasedRouterFailoverType;
    }

    public Map<StatusDimension.Level, StatusDimension> getStatusDimensions() {
        return this.statusDimensions;
    }

    public void setSourceRouteRule(ServiceRule sourceRouteRule) {
        this.sourceRouteRule = sourceRouteRule;
    }

    public void setDestRouteRule(ServiceRule destRouteRule) {
        this.destRouteRule = destRouteRule;
    }

    public RouteResult.NextRouterInfo getNextRouterInfo() {
        return this.nextRouterInfo;
    }

    public void setNextRouterInfo(RouteResult.NextRouterInfo nextRouterInfo) {
        this.nextRouterInfo = nextRouterInfo;
    }

    public String getCanary() {
        return this.canary;
    }

    public void setCanary(String canary) {
        this.canary = canary;
    }

    public Boolean routerIsEnabled(String routerType) {
        return this.chainEnable.get(routerType);
    }

    public void enableRouter(String routerType) {
        this.chainEnable.put(routerType, true);
    }

    public void disableRouter(String routerType) {
        this.chainEnable.put(routerType, false);
    }

    public SourceService getSourceService() {
        return this.sourceService;
    }

    public ServiceRule getSourceRouteRule() {
        return this.sourceRouteRule;
    }

    public ServiceMetadata getDestService() {
        return this.destService;
    }

    public ServiceRule getDestRouteRule() {
        return this.destRouteRule;
    }

    public boolean isIncludeUnhealthyInstances() {
        return this.includeUnhealthyInstances;
    }

    public void setIncludeUnhealthyInstances(boolean includeUnhealthyInstances) {
        this.includeUnhealthyInstances = includeUnhealthyInstances;
    }

    public boolean isIncludeCircuitBreakInstances() {
        return this.includeCircuitBreakInstances;
    }

    public void setIncludeCircuitBreakInstances(boolean includeCircuitBreakInstances) {
        this.includeCircuitBreakInstances = includeCircuitBreakInstances;
    }

    public Map<String, String> getRouterMetadata(String routerType) {
        if (this.routerMetadata == null) {
            return Collections.emptyMap();
        }
        Map<String, String> metadata = this.routerMetadata.get(routerType);
        if (metadata == null || metadata.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(metadata);
    }

    public void setRouterArguments(Map<String, Set<RouteArgument>> routerArguments) {
        Map<String, Map<String, String>> routerMetadata = this.routerMetadata;
        routerArguments.forEach((s, arguments) -> {
            routerMetadata.computeIfAbsent((String)s, key -> new HashMap());
            Map labels = (Map)routerMetadata.get(s);
            arguments.forEach(routeArgument -> routeArgument.toLabel(labels));
        });
    }

    public String getSubsetName() {
        return this.subsetName;
    }

    public void setSubsetName(String subsetName) {
        this.subsetName = subsetName;
    }

    public Map<String, ModelProto.MatchString> getSubsetMetadata() {
        return this.subsetMetadata;
    }

    public void setSubsetMetadata(Map<String, ModelProto.MatchString> subsetMetadata) {
        this.subsetMetadata = subsetMetadata;
    }

    private static boolean isEmptyService(ServiceInfo serviceInfo) {
        if (Objects.isNull(serviceInfo)) {
            return true;
        }
        return StringUtils.isBlank(serviceInfo.getNamespace()) && StringUtils.isBlank(serviceInfo.getService());
    }

    private static boolean isEmptyService(ServiceConfig serviceConfig) {
        if (Objects.isNull(serviceConfig)) {
            return true;
        }
        return StringUtils.isBlank(serviceConfig.getNamespace()) && StringUtils.isBlank(serviceConfig.getName());
    }
}

