/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class TraceableContext {
    protected AtomicLong receiveTime = new AtomicLong();
    protected AtomicLong sendTime = new AtomicLong();
    protected Map<String, String> traceInfoMap = new ConcurrentHashMap<String, String>();

    public long getReceiveTime() {
        return this.receiveTime.get();
    }

    public void setReceiveTime(long receiveTime) {
        this.receiveTime.compareAndSet(0L, receiveTime);
    }

    public long getSendTime() {
        return this.sendTime.get();
    }

    public void setSendTime(long sendTime) {
        this.sendTime.compareAndSet(0L, sendTime);
    }

    public void addTraceInfo(String key, String value) {
        this.traceInfoMap.put(key, value);
    }

    public String getTraceInfo(String key) {
        return this.traceInfoMap.get(key);
    }

    public Map<String, String> getTraceInfoMap() {
        return this.traceInfoMap;
    }

    public String toString() {
        return "send: " + this.sendTime + ", receive: " + this.receiveTime + ", info: " + JSON.toJSONString(this.traceInfoMap);
    }
}

