/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.kubernetes;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.kubernetes.KubernetesRegistryHelper;
import com.alipay.sofa.rpc.registry.kubernetes.KubernetesRegistryProviderWatcher;
import com.alipay.sofa.rpc.registry.kubernetes.utils.KubernetesClientUtils;
import com.alipay.sofa.rpc.registry.kubernetes.utils.KubernetesConfigUtils;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Extension(value="kubernetes")
public class KubernetesRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesRegistry.class);
    private KubernetesClient kubernetesClient;
    private String currentHostname;
    private String namespace;
    private KubernetesRegistryProviderWatcher kubernetesRegistryProviderWatcher;
    private final ConcurrentMap<ConsumerConfig, SharedIndexInformer<Pod>> consumerListeners = new ConcurrentHashMap<ConsumerConfig, SharedIndexInformer<Pod>>(64);

    public KubernetesRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public synchronized void init() {
        Config config = KubernetesConfigUtils.buildKubernetesConfig(this.registryConfig);
        if (this.kubernetesClient == null) {
            this.kubernetesClient = KubernetesClientUtils.buildKubernetesClient(config);
        }
        if (this.kubernetesRegistryProviderWatcher == null) {
            this.kubernetesRegistryProviderWatcher = new KubernetesRegistryProviderWatcher();
        }
        this.currentHostname = System.getenv("HOSTNAME");
        this.namespace = config.getNamespace();
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (config.isRegister()) {
            PodResource podResource = (PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withName(this.currentHostname);
            List<ServerConfig> serverConfigs = config.getServer();
            if (CommonUtils.isNotEmpty(serverConfigs)) {
                for (ServerConfig serverConfig : serverConfigs) {
                    String dataId = KubernetesRegistryHelper.buildDataId(config, serverConfig.getProtocol());
                    String url = KubernetesRegistryHelper.convertToUrl((Pod)podResource.get(), serverConfig, config);
                    podResource.edit(pod -> ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder(pod).editOrNewMetadata().addToAnnotations(dataId, url)).addToLabels(dataId, "")).endMetadata()).build());
                }
            }
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (config.isRegister()) {
            PodResource podResource = (PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withName(this.currentHostname);
            List<ServerConfig> serverConfigs = config.getServer();
            if (CommonUtils.isNotEmpty(serverConfigs)) {
                for (ServerConfig serverConfig : serverConfigs) {
                    String dataId = KubernetesRegistryHelper.buildDataId(config, serverConfig.getProtocol());
                    podResource.edit(pod -> ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder(pod).editOrNewMetadata().removeFromAnnotations(dataId)).removeFromLabels(dataId)).endMetadata()).build());
                }
            }
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(config.getAppName(), "Batch unregister error", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(final ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return null;
        }
        if (config.isSubscribe()) {
            ProviderInfoListener providerInfoListener = config.getProviderInfoListener();
            this.kubernetesRegistryProviderWatcher.addProviderListener(config, providerInfoListener);
            String dataId = KubernetesRegistryHelper.buildDataId(config, config.getProtocol());
            FilterWatchListDeletable podPodListPodResourceFilterWatchListDeletable = (FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withLabel(dataId);
            SharedIndexInformer inform = podPodListPodResourceFilterWatchListDeletable.inform((ResourceEventHandler)new ResourceEventHandler<Pod>(){

                public void onAdd(Pod pod) {
                    KubernetesRegistry.this.kubernetesRegistryProviderWatcher.updateProviders(config, KubernetesRegistry.this.getPods());
                }

                public void onUpdate(Pod pod, Pod t1) {
                    KubernetesRegistry.this.kubernetesRegistryProviderWatcher.updateProviders(config, KubernetesRegistry.this.getPods());
                }

                public void onDelete(Pod pod, boolean b) {
                    KubernetesRegistry.this.kubernetesRegistryProviderWatcher.updateProviders(config, KubernetesRegistry.this.getPods());
                }
            });
            this.consumerListeners.put(config, (SharedIndexInformer<Pod>)inform);
            inform.start();
            List pods = ((PodList)podPodListPodResourceFilterWatchListDeletable.list()).getItems();
            List<ProviderInfo> providerInfos = KubernetesRegistryHelper.convertPodsToProviders(pods, config);
            return Collections.singletonList(new ProviderGroup().addAll(providerInfos));
        }
        return null;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        SharedIndexInformer informer;
        if (config.isSubscribe() && null != (informer = (SharedIndexInformer)this.consumerListeners.remove(config))) {
            informer.stop();
        }
        this.kubernetesRegistryProviderWatcher.removeProviderListener(config);
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            try {
                this.unSubscribe(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(config.getAppName(), "Batch unSubscribe error", e);
            }
        }
    }

    @Override
    public void destroy() {
        this.consumerListeners.forEach((k, v) -> this.unSubscribe((ConsumerConfig)k));
        this.kubernetesClient.close();
    }

    private List<Pod> getPods() {
        return ((PodList)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).list()).getItems();
    }

    public void setCurrentHostname(String currentHostname) {
        this.currentHostname = currentHostname;
    }

    public ConcurrentMap<ConsumerConfig, SharedIndexInformer<Pod>> getConsumerListeners() {
        return this.consumerListeners;
    }
}

