/*
 * Decompiled with CFR 0.152.
 */
package io.fury.type;

import com.google.common.reflect.TypeToken;
import io.fury.resolver.ClassResolver;
import io.fury.serializer.Serializer;
import io.fury.type.TypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.function.Predicate;

public class GenericType {
    static final Predicate<Type> defaultFinalPredicate = type -> {
        if (type.getClass() == Class.class) {
            return Modifier.isFinal(((Class)type).getModifiers());
        }
        return Modifier.isFinal(TypeUtils.getRawType(type).getModifiers());
    };
    final TypeToken<?> typeToken;
    final Class<?> cls;
    final GenericType[] typeParameters;
    final int typeParametersCount;
    final GenericType typeParameter0;
    final GenericType typeParameter1;
    final boolean hasGenericParameters;
    final boolean isFinal;
    Serializer<?> serializer;
    private Boolean trackingRef;

    public GenericType(TypeToken<?> typeToken, boolean isFinal, GenericType ... typeParameters) {
        this.typeToken = typeToken;
        this.cls = TypeUtils.getRawType(typeToken);
        this.typeParameters = typeParameters;
        this.typeParametersCount = typeParameters.length;
        this.hasGenericParameters = typeParameters.length > 0;
        this.isFinal = isFinal;
        this.typeParameter0 = typeParameters.length > 0 ? typeParameters[0] : null;
        this.typeParameter1 = typeParameters.length > 1 ? typeParameters[1] : null;
    }

    public static GenericType build(TypeToken<?> type) {
        return GenericType.build(type.getType());
    }

    public static GenericType build(Type type) {
        return GenericType.build(type, defaultFinalPredicate);
    }

    public static GenericType build(TypeToken<?> context, Type type) {
        return GenericType.build(context, type, defaultFinalPredicate);
    }

    public static GenericType build(Class<?> context, Type type) {
        return GenericType.build(context, type, defaultFinalPredicate);
    }

    public static GenericType build(Class<?> context, Type type, Predicate<Type> finalPredicate) {
        return GenericType.build(TypeToken.of(context), type, finalPredicate);
    }

    public static GenericType build(TypeToken<?> context, Type type, Predicate<Type> finalPredicate) {
        return GenericType.build(context.resolveType(type).getType(), finalPredicate);
    }

    public static GenericType build(Type type, Predicate<Type> finalPredicate) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList<GenericType> list = new ArrayList<GenericType>();
            for (Type t : actualTypeArguments) {
                GenericType build = GenericType.build(t, finalPredicate);
                list.add(build);
            }
            GenericType[] genericTypes = list.toArray(new GenericType[0]);
            return new GenericType(TypeToken.of((Type)type), finalPredicate.test(type), genericTypes);
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return new GenericType(TypeToken.of((Type)type), finalPredicate.test(type), GenericType.build(componentType));
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type typeVariableBound = typeVariable.getBounds()[0];
            return new GenericType(TypeToken.of((Type)typeVariableBound), finalPredicate.test(type), new GenericType[0]);
        }
        if (type instanceof WildcardType) {
            Type upperBound = ((WildcardType)type).getUpperBounds()[0];
            if (upperBound instanceof ParameterizedType) {
                return GenericType.build(upperBound);
            }
            return new GenericType(TypeToken.of((Type)upperBound), finalPredicate.test(type), new GenericType[0]);
        }
        return new GenericType(TypeToken.of((Type)type), finalPredicate.test(type), new GenericType[0]);
    }

    public TypeToken<?> getTypeToken() {
        return this.typeToken;
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public GenericType[] getTypeParameters() {
        return this.typeParameters;
    }

    public int getTypeParametersCount() {
        return this.typeParametersCount;
    }

    public GenericType getTypeParameter0() {
        return this.typeParameter0;
    }

    public GenericType getTypeParameter1() {
        return this.typeParameter1;
    }

    public Serializer<?> getSerializer(ClassResolver classResolver) {
        Serializer<?> serializer = this.serializer;
        if (serializer == null) {
            this.serializer = serializer = classResolver.getSerializer(this.cls);
        }
        return serializer;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Serializer<?> getSerializerOrNull(ClassResolver classResolver) {
        if (this.isFinal) {
            return this.getSerializer(classResolver);
        }
        return null;
    }

    public boolean trackingRef(ClassResolver classResolver) {
        Boolean trackingRef = this.trackingRef;
        if (trackingRef == null) {
            trackingRef = this.trackingRef = Boolean.valueOf(classResolver.needToWriteRef(this.cls));
        }
        return trackingRef;
    }

    public boolean hasGenericParameters() {
        return this.hasGenericParameters;
    }

    public String toString() {
        return "GenericType{" + this.typeToken.toString() + '}';
    }
}

