/*
 * Decompiled with CFR 0.152.
 */
package io.fury.config;

import io.fury.config.CompatibleMode;
import io.fury.config.FuryBuilder;
import io.fury.config.Language;
import io.fury.config.LongEncoding;
import io.fury.serializer.Serializer;
import io.fury.util.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Config
implements Serializable {
    private final Language language;
    private final boolean trackingRef;
    private final boolean basicTypesRefIgnored;
    private final boolean stringRefIgnored;
    private final boolean timeRefIgnored;
    private final boolean codeGenEnabled;
    private final boolean checkClassVersion;
    private final CompatibleMode compatibleMode;
    private final boolean checkJdkClassSerializable;
    private final Class<? extends Serializer> defaultJDKStreamSerializerType;
    private final boolean compressString;
    private final boolean compressInt;
    private final boolean compressLong;
    private final LongEncoding longEncoding;
    private final boolean requireClassRegistration;
    private final boolean suppressClassRegistrationWarnings;
    private final boolean registerGuavaTypes;
    private final boolean shareMetaContext;
    private final boolean asyncCompilationEnabled;
    private final boolean deserializeUnexistedClass;
    private final boolean scalaOptimizationEnabled;
    private transient int configHash;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ConcurrentMap<Config, Integer> configIdMap = new ConcurrentHashMap<Config, Integer>();

    public Config(FuryBuilder builder) {
        this.language = builder.language;
        this.trackingRef = builder.trackingRef;
        this.basicTypesRefIgnored = !this.trackingRef || builder.basicTypesRefIgnored;
        this.stringRefIgnored = !this.trackingRef || builder.stringRefIgnored;
        this.timeRefIgnored = !this.trackingRef || builder.timeRefIgnored;
        this.compressString = builder.compressString;
        this.compressInt = builder.compressInt;
        this.longEncoding = builder.longEncoding;
        this.compressLong = this.longEncoding != LongEncoding.LE_RAW_BYTES;
        this.requireClassRegistration = builder.requireClassRegistration;
        this.suppressClassRegistrationWarnings = builder.suppressClassRegistrationWarnings;
        this.registerGuavaTypes = builder.registerGuavaTypes;
        this.codeGenEnabled = builder.codeGenEnabled;
        this.checkClassVersion = builder.checkClassVersion;
        this.compatibleMode = builder.compatibleMode;
        this.checkJdkClassSerializable = builder.checkJdkClassSerializable;
        this.defaultJDKStreamSerializerType = builder.defaultJDKStreamSerializerType;
        this.shareMetaContext = builder.shareMetaContext;
        this.deserializeUnexistedClass = builder.deserializeUnexistedClass;
        if (this.deserializeUnexistedClass) {
            Preconditions.checkArgument(this.shareMetaContext || this.compatibleMode == CompatibleMode.COMPATIBLE);
        }
        this.asyncCompilationEnabled = builder.asyncCompilationEnabled;
        this.scalaOptimizationEnabled = builder.scalaOptimizationEnabled;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean trackingRef() {
        return this.trackingRef;
    }

    public boolean isBasicTypesRefIgnored() {
        return this.basicTypesRefIgnored;
    }

    public boolean isStringRefIgnored() {
        return this.stringRefIgnored;
    }

    public boolean isTimeRefIgnored() {
        return this.timeRefIgnored;
    }

    public boolean checkClassVersion() {
        return this.checkClassVersion;
    }

    public CompatibleMode getCompatibleMode() {
        return this.compatibleMode;
    }

    public boolean checkJdkClassSerializable() {
        return this.checkJdkClassSerializable;
    }

    public boolean compressString() {
        return this.compressString;
    }

    public boolean compressInt() {
        return this.compressInt;
    }

    public boolean compressLong() {
        return this.compressLong;
    }

    public LongEncoding longEncoding() {
        return this.longEncoding;
    }

    public boolean requireClassRegistration() {
        return this.requireClassRegistration;
    }

    public boolean suppressClassRegistrationWarnings() {
        return this.suppressClassRegistrationWarnings;
    }

    public boolean registerGuavaTypes() {
        return this.registerGuavaTypes;
    }

    public Class<? extends Serializer> getDefaultJDKStreamSerializerType() {
        return this.defaultJDKStreamSerializerType;
    }

    public boolean shareMetaContext() {
        return this.shareMetaContext;
    }

    public boolean deserializeUnexistedClass() {
        return this.deserializeUnexistedClass;
    }

    public boolean isCodeGenEnabled() {
        return this.codeGenEnabled;
    }

    public boolean isAsyncCompilationEnabled() {
        return this.asyncCompilationEnabled;
    }

    public boolean isScalaOptimizationEnabled() {
        return this.scalaOptimizationEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.trackingRef == config.trackingRef && this.basicTypesRefIgnored == config.basicTypesRefIgnored && this.stringRefIgnored == config.stringRefIgnored && this.timeRefIgnored == config.timeRefIgnored && this.codeGenEnabled == config.codeGenEnabled && this.checkClassVersion == config.checkClassVersion && this.checkJdkClassSerializable == config.checkJdkClassSerializable && this.compressString == config.compressString && this.compressInt == config.compressInt && this.compressLong == config.compressLong && this.requireClassRegistration == config.requireClassRegistration && this.suppressClassRegistrationWarnings == config.suppressClassRegistrationWarnings && this.registerGuavaTypes == config.registerGuavaTypes && this.shareMetaContext == config.shareMetaContext && this.asyncCompilationEnabled == config.asyncCompilationEnabled && this.deserializeUnexistedClass == config.deserializeUnexistedClass && this.scalaOptimizationEnabled == config.scalaOptimizationEnabled && this.language == config.language && this.compatibleMode == config.compatibleMode && Objects.equals(this.defaultJDKStreamSerializerType, config.defaultJDKStreamSerializerType) && this.longEncoding == config.longEncoding;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.trackingRef, this.basicTypesRefIgnored, this.stringRefIgnored, this.timeRefIgnored, this.codeGenEnabled, this.checkClassVersion, this.compatibleMode, this.checkJdkClassSerializable, this.defaultJDKStreamSerializerType, this.compressString, this.compressInt, this.compressLong, this.longEncoding, this.requireClassRegistration, this.suppressClassRegistrationWarnings, this.registerGuavaTypes, this.shareMetaContext, this.asyncCompilationEnabled, this.deserializeUnexistedClass, this.scalaOptimizationEnabled});
    }

    public int getConfigHash() {
        if (this.configHash == 0) {
            this.configHash = configIdMap.computeIfAbsent(this, k -> counter.incrementAndGet());
        }
        return this.configHash;
    }
}

