/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.Tracer;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.codec.IpLiteral;
import brave.internal.handler.NoopAwareSpanHandler;
import brave.internal.handler.OrphanTracker;
import brave.internal.recorder.PendingSpans;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Tracing
implements Closeable {
    static final AtomicReference<Tracing> CURRENT = new AtomicReference();

    public static Builder newBuilder() {
        return new Builder();
    }

    public abstract Tracer tracer();

    public abstract Propagation<String> propagation();

    public abstract Sampler sampler();

    public abstract CurrentTraceContext currentTraceContext();

    public final Clock clock(TraceContext context) {
        return this.tracer().pendingSpans.getOrCreate(null, context, false).clock();
    }

    @Nullable
    public static Tracing current() {
        return CURRENT.get();
    }

    @Nullable
    public static Tracer currentTracer() {
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.tracer() : null;
    }

    public abstract boolean isNoop();

    public abstract void setNoop(boolean var1);

    @Override
    public abstract void close();

    Tracing() {
    }

    static final class Default
    extends Tracing {
        final Tracer tracer;
        final Propagation.Factory propagationFactory;
        final Propagation<String> stringPropagation;
        final CurrentTraceContext currentTraceContext;
        final Sampler sampler;
        final Clock clock;
        final AtomicBoolean noop;

        Default(Builder builder) {
            LinkedHashSet<SpanHandler> spanHandlers;
            this.clock = builder.clock != null ? builder.clock : Platform.get().clock();
            this.propagationFactory = builder.propagationFactory;
            this.stringPropagation = builder.propagationFactory.get();
            this.currentTraceContext = builder.currentTraceContext;
            this.sampler = builder.sampler;
            this.noop = new AtomicBoolean();
            MutableSpan defaultSpan = new MutableSpan(builder.defaultSpan);
            if (defaultSpan.localIp() == null) {
                defaultSpan.localIp(Platform.get().linkLocalIp());
            }
            if ((spanHandlers = new LinkedHashSet<SpanHandler>(builder.spanHandlers)).isEmpty()) {
                spanHandlers.add(new LogSpanHandler());
            }
            if (builder.trackOrphans) {
                spanHandlers.add(OrphanTracker.newBuilder().defaultSpan(defaultSpan).clock(this.clock).build());
            }
            SpanHandler spanHandler = NoopAwareSpanHandler.create(spanHandlers.toArray(new SpanHandler[0]), this.noop);
            this.tracer = new Tracer(builder.propagationFactory, spanHandler, new PendingSpans(defaultSpan, this.clock, spanHandler, this.noop), builder.sampler, builder.currentTraceContext, builder.traceId128Bit || this.propagationFactory.requires128BitTraceId(), builder.supportsJoin && this.propagationFactory.supportsJoin(), builder.alwaysSampleLocal, this.noop);
            CURRENT.compareAndSet(null, this);
        }

        @Override
        public Tracer tracer() {
            return this.tracer;
        }

        @Override
        public Propagation<String> propagation() {
            return this.stringPropagation;
        }

        @Override
        public Sampler sampler() {
            return this.sampler;
        }

        @Override
        public CurrentTraceContext currentTraceContext() {
            return this.currentTraceContext;
        }

        @Override
        public boolean isNoop() {
            return this.noop.get();
        }

        @Override
        public void setNoop(boolean noop) {
            this.noop.set(noop);
        }

        public String toString() {
            return this.tracer.toString();
        }

        @Override
        public void close() {
            CURRENT.compareAndSet(this, null);
        }
    }

    static final class LogSpanHandler
    extends SpanHandler {
        final Logger logger = Logger.getLogger(Tracer.class.getName());

        LogSpanHandler() {
        }

        @Override
        public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
            if (!this.logger.isLoggable(Level.INFO)) {
                return false;
            }
            this.logger.info(span.toString());
            return true;
        }

        public String toString() {
            return "LogSpanHandler{name=" + this.logger.getName() + "}";
        }
    }

    public static final class Builder {
        final MutableSpan defaultSpan = new MutableSpan();
        Clock clock;
        Sampler sampler = Sampler.ALWAYS_SAMPLE;
        CurrentTraceContext currentTraceContext = CurrentTraceContext.Default.inheritable();
        boolean traceId128Bit = false;
        boolean supportsJoin = true;
        boolean alwaysSampleLocal = false;
        boolean trackOrphans = false;
        Propagation.Factory propagationFactory = B3Propagation.FACTORY;
        Set<SpanHandler> spanHandlers = new LinkedHashSet<SpanHandler>();

        Builder() {
            this.defaultSpan.localServiceName("unknown");
        }

        public Set<SpanHandler> spanHandlers() {
            return Collections.unmodifiableSet(new LinkedHashSet<SpanHandler>(this.spanHandlers));
        }

        public Builder clearSpanHandlers() {
            this.spanHandlers.clear();
            return this;
        }

        public Builder localServiceName(String localServiceName) {
            if (localServiceName == null || localServiceName.isEmpty()) {
                throw new IllegalArgumentException(localServiceName + " is not a valid serviceName");
            }
            this.defaultSpan.localServiceName(localServiceName);
            return this;
        }

        public Builder localIp(String localIp) {
            String maybeIp = IpLiteral.ipOrNull(localIp);
            if (maybeIp == null) {
                throw new IllegalArgumentException(localIp + " is not a valid IP");
            }
            this.defaultSpan.localIp(maybeIp);
            return this;
        }

        public Builder localPort(int localPort) {
            if (localPort > 65535) {
                throw new IllegalArgumentException("invalid localPort " + localPort);
            }
            if (localPort < 0) {
                localPort = 0;
            }
            this.defaultSpan.localPort(localPort);
            return this;
        }

        public Builder clock(Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock == null");
            }
            this.clock = clock;
            return this;
        }

        public Builder sampler(Sampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.sampler = sampler;
            return this;
        }

        public Builder currentTraceContext(CurrentTraceContext currentTraceContext) {
            if (currentTraceContext == null) {
                throw new NullPointerException("currentTraceContext == null");
            }
            this.currentTraceContext = currentTraceContext;
            return this;
        }

        public Builder propagationFactory(Propagation.Factory propagationFactory) {
            if (propagationFactory == null) {
                throw new NullPointerException("propagationFactory == null");
            }
            this.propagationFactory = propagationFactory;
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.traceId128Bit = traceId128Bit;
            return this;
        }

        public Builder supportsJoin(boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
            return this;
        }

        public Builder addSpanHandler(SpanHandler spanHandler) {
            if (spanHandler == null) {
                throw new NullPointerException("spanHandler == null");
            }
            if (spanHandler == SpanHandler.NOOP) {
                return this;
            }
            if (!this.spanHandlers.add(spanHandler)) {
                Platform.get().log("Please check configuration as %s was added twice", spanHandler, null);
            }
            return this;
        }

        public Builder alwaysSampleLocal() {
            this.alwaysSampleLocal = true;
            return this;
        }

        public Builder trackOrphans() {
            this.trackOrphans = true;
            return this;
        }

        public Tracing build() {
            return new Default(this);
        }
    }
}

