/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.stat;

import com.qq.tars.client.Communicator;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.stat.ProxyStat;
import com.qq.tars.support.stat.ProxyStatBody;
import com.qq.tars.support.stat.ProxyStatHead;
import com.qq.tars.support.stat.prx.StatFPrx;
import com.qq.tars.support.stat.prx.StatMicMsgBody;
import com.qq.tars.support.stat.prx.StatMicMsgHead;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public final class StatHelper {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private static final int BATCH_REPORTS = 10;
    private final Communicator communicator;

    public StatHelper(Communicator communicator) {
        this.communicator = communicator;
    }

    private StatFPrx getPrx() {
        StatFPrx prx = null;
        String stat = this.communicator.getCommunicatorConfig().getStat();
        if (!StringUtils.isEmpty(stat)) {
            prx = this.communicator.stringToProxy(StatFPrx.class, this.communicator.getCommunicatorConfig().getStat());
        }
        return prx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(ProxyStat proxyStat, boolean bFromClient) {
        StatFPrx statFProxy = this.getPrx();
        if (statFProxy == null) {
            logger.info("no config stat obj to report");
            return;
        }
        if (proxyStat.isEmpty()) {
            logger.info("no stat need to report");
            return;
        }
        long start = System.currentTimeMillis();
        int i = 0;
        int errorCount = 0;
        int successCount = 0;
        try {
            HashMap<StatMicMsgHead, StatMicMsgBody> reportMap = new HashMap<StatMicMsgHead, StatMicMsgBody>();
            for (Map.Entry<ProxyStatHead, ProxyStatBody> statHead : proxyStat.getStats().entrySet()) {
                ProxyStatHead head = statHead.getKey();
                ProxyStatBody body = statHead.getValue();
                HashMap<Integer, Integer> intervalCount = new HashMap<Integer, Integer>();
                for (Map.Entry<Integer, AtomicInteger> interval : body.intervalCount.entrySet()) {
                    intervalCount.put(interval.getKey(), interval.getValue().get());
                }
                StatMicMsgBody mbody = new StatMicMsgBody(body.getCount(), body.getTimeoutCount(), body.getExecCount(), intervalCount, body.getTotalRspTime(), body.getMaxRspTime(), body.getMinRspTime());
                body.clear();
                StatMicMsgHead mHead = new StatMicMsgHead(head.getMasterName(), head.getSlaveName(), head.getInterfaceName(), head.getMasterIp(), head.getSlaveIp(), head.getSlavePort(), head.getReturnValue(), head.getSlaveSetName(), head.getSlaveSetArea(), head.getSlaveSetID(), head.getTafVersion());
                reportMap.put(mHead, mbody);
                logger.info("report call|" + statHead.getKey().masterName + "|" + statHead.getKey().slaveIp + ":" + statHead.getKey().slavePort + "|" + statHead.getKey().slaveName + "." + statHead.getKey().interfaceName + "_" + statHead.getKey().getReturnValue() + "(" + statHead.getKey().slaveSetName + "." + statHead.getKey().slaveSetArea + "." + statHead.getKey().slaveSetID + "):" + mbody.count + "_" + mbody.execCount + "_" + mbody.timeoutCount + "_" + mbody.totalRspTime + "_" + mbody.maxRspTime + "_" + mbody.minRspTime);
                if (++i % 10 != 0) continue;
                try {
                    statFProxy.promise_reportMicMsg(reportMap, bFromClient);
                }
                catch (Exception e) {
                    logger.error("error occurred on report proxy stat", (Throwable)e);
                    ++errorCount;
                }
                reportMap = new HashMap();
            }
            if (reportMap.size() > 0) {
                try {
                    statFProxy.promise_reportMicMsg(reportMap, bFromClient);
                    ++successCount;
                }
                catch (Exception e) {
                    ++errorCount;
                    logger.error("error occurred on report proxy stat", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("error occurred on report proxy stat", (Throwable)e);
        }
        finally {
            logger.info("report success:" + successCount + " fail:" + errorCount + " costTime:" + (System.currentTimeMillis() - start));
        }
    }
}

