/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.common.support;

import java.util.Objects;

public class Endpoint {
    private final String type;
    private final String host;
    private final int port;
    private final int timeout;
    private final int grid;
    private final int qos;
    private final String setDivision;
    private int hash;
    public static final Endpoint VOID_ENDPOINT = new Endpoint("tcp", "0.0.0.0", 0, 0, 0, 0, null);

    public Endpoint(String type, String host, int port, int timeout, int grid, int qos, String setDivision) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.grid = grid;
        this.qos = qos;
        this.setDivision = setDivision;
    }

    public String type() {
        return this.type;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int timeout() {
        return this.timeout;
    }

    public int grid() {
        return this.grid;
    }

    public int qos() {
        return this.qos;
    }

    public String setDivision() {
        return this.setDivision;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 1;
            h = 31 * h + this.type.hashCode();
            h = 31 * h + this.host.hashCode();
            this.hash = h = 31 * h + this.port;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.port != other.port) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.host, other.host);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toLowerCase());
        sb.append(" -h ").append(this.host);
        sb.append(" -p ").append(this.port);
        if (this.timeout > 0) {
            sb.append(" -t ").append(this.timeout);
        }
        if (this.grid > 0) {
            sb.append(" -g ").append(this.grid);
        }
        if (this.qos > 0) {
            sb.append(" -q ").append(this.qos);
        }
        if (this.setDivision != null && !this.setDivision.trim().isEmpty()) {
            sb.append(" -s ").append(this.setDivision);
        }
        return sb.toString();
    }

    public static Endpoint parseString(String node) {
        String type = null;
        String host = null;
        int port = 0;
        int timeout = 3000;
        int grid = 0;
        int qos = 0;
        String setDivision = null;
        String[] fields = node.split("\\s+");
        if ("tcp".equalsIgnoreCase(fields[0])) {
            type = "tcp";
        } else if ("udp".equalsIgnoreCase(fields[0])) {
            type = "udp";
        } else {
            return null;
        }
        int i = 0;
        while (i < fields.length) {
            if ("-h".equals(fields[i]) && i + 1 < fields.length) {
                host = fields[i + 1];
                i += 2;
                continue;
            }
            if ("-p".equals(fields[i]) && i + 1 < fields.length) {
                port = Integer.parseInt(fields[i + 1]);
                i += 2;
                continue;
            }
            if ("-t".equals(fields[i]) && i + 1 < fields.length) {
                timeout = Integer.parseInt(fields[i + 1]);
                i += 2;
                continue;
            }
            if ("-g".equals(fields[i]) && i + 1 < fields.length) {
                grid = Integer.parseInt(fields[i + 1]);
                i += 2;
                continue;
            }
            if ("-q".equals(fields[i]) && i + 1 < fields.length) {
                qos = Integer.parseInt(fields[i + 1]);
                i += 2;
                continue;
            }
            if ("-s".equals(fields[i]) && i + 1 < fields.length) {
                setDivision = fields[i + 1];
                i += 2;
                continue;
            }
            ++i;
        }
        if (host == null || host.isEmpty()) {
            return null;
        }
        if (host.equals("*")) {
            host = "0.0.0.0";
        }
        if (port < 0 || port > 65535) {
            return null;
        }
        if (timeout <= 0) {
            return null;
        }
        if (grid < 0) {
            return null;
        }
        return new Endpoint(type, host, port, timeout, grid, qos, setDivision);
    }
}

