/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc.tars;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.cluster.ServantInvokerAliveChecker;
import com.qq.tars.client.rpc.tars.TarsCallbackFilterChain;
import com.qq.tars.client.rpc.tars.TarsInvoker;
import com.qq.tars.common.Filter;
import com.qq.tars.common.FilterKind;
import com.qq.tars.common.util.DyeingSwitch;
import com.qq.tars.context.DistributedContextManager;
import com.qq.tars.net.client.Callback;
import com.qq.tars.rpc.exc.TimeoutException;
import com.qq.tars.rpc.protocol.tars.TarsServantRequest;
import com.qq.tars.rpc.protocol.tars.TarsServantResponse;
import com.qq.tars.server.core.AppContextManager;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.stat.InvokeStatHelper;
import java.util.List;
import org.slf4j.Logger;

public class TarsCallbackWrapper
implements Callback<TarsServantResponse> {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final String objName;
    private final ServantProxyConfig config;
    private final String methodName;
    private final String remoteIp;
    private final int remotePort;
    private final long bornTime;
    private final TarsServantRequest request;
    private final TarsInvoker invoker;
    private final Callback<TarsServantResponse> callback;
    private List<Filter> filters;

    public TarsCallbackWrapper(ServantProxyConfig config, String methodName, String remoteIp, int remotePort, long bornTime, TarsServantRequest request, Callback<TarsServantResponse> callback, TarsInvoker invoker) {
        this.callback = callback;
        this.config = config;
        this.objName = config.getSimpleObjectName();
        this.methodName = methodName;
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
        this.bornTime = bornTime;
        this.request = request;
        this.filters = AppContextManager.getInstance().getAppContext() == null ? null : AppContextManager.getInstance().getAppContext().getFilters(FilterKind.CALLBACK);
        this.invoker = invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted(TarsServantResponse response) {
        int ret = response.getRet() == 0 ? 0 : 1;
        boolean available = ServantInvokerAliveChecker.isAlive(this.invoker.getUrl(), this.config, ret);
        this.invoker.setAvailable(available);
        try {
            this.beforeCallback();
            TarsCallbackFilterChain filterChain = new TarsCallbackFilterChain(this.filters, this.objName, FilterKind.CALLBACK, this.callback, 0);
            filterChain.doFilter(this.request, response);
        }
        catch (Throwable ex) {
            ret = 1;
            logger.error("error occurred on callback completed", ex);
        }
        finally {
            this.afterCallback();
            InvokeStatHelper.getInstance().addProxyStat(this.objName).addInvokeTimeByClient(this.config.getModuleName(), this.config.getSlaveName(), this.config.getSlaveSetName(), this.config.getSlaveSetArea(), this.config.getSlaveSetID(), this.methodName, this.remoteIp, this.remotePort, ret, System.currentTimeMillis() - this.bornTime);
        }
    }

    public void onException(Throwable e) {
        try {
            if (this.callback != null) {
                this.callback.onException(e);
            }
        }
        catch (Throwable ex) {
            logger.error("error occurred on callback exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExpired() {
        int ret = 2;
        this.invoker.setAvailable(ServantInvokerAliveChecker.isAlive(this.invoker.getUrl(), this.config, ret));
        try {
            this.beforeCallback();
            TarsCallbackFilterChain filterChain = new TarsCallbackFilterChain(this.filters, this.objName, FilterKind.CALLBACK, this.callback, 1);
            TarsServantResponse response = new TarsServantResponse(this.request.getIoSession());
            response.setRequest(this.request);
            response.setTicketNumber(this.request.getTicketNumber());
            response.setCause(new TimeoutException("async call timeout"));
            filterChain.doFilter(this.request, response);
        }
        catch (Throwable ex) {
            logger.error("error occurred on callback expired", ex);
        }
        finally {
            this.afterCallback();
            InvokeStatHelper.getInstance().addProxyStat(this.objName).addInvokeTimeByClient(this.config.getModuleName(), this.config.getSlaveName(), this.config.getSlaveSetName(), this.config.getSlaveSetArea(), this.config.getSlaveSetID(), this.methodName, this.remoteIp, this.remotePort, ret, System.currentTimeMillis() - this.bornTime);
        }
    }

    private void beforeCallback() {
        if (this.isDyeingReq()) {
            DyeingSwitch.enableUnactiveDyeing(this.request.getStatus().get("STATUS_DYED_KEY"), this.request.getStatus().get("STATUS_DYED_FILENAME"));
        }
    }

    private void afterCallback() {
        DistributedContextManager.releaseDistributedContext();
    }

    private boolean isDyeingReq() {
        return (this.request.getMessageType() & 4) == 4;
    }
}

