/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.rpc.ServantClient;
import com.qq.tars.client.support.ClientPoolManager;
import com.qq.tars.client.util.ParseTools;
import com.qq.tars.common.support.ScheduledExecutorManager;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.protocol.ProtocolFactory;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.ProtocolInvoker;
import com.qq.tars.rpc.common.Url;
import com.qq.tars.rpc.common.util.concurrent.ConcurrentHashSet;
import com.qq.tars.rpc.exc.ClientException;
import com.qq.tars.support.log.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class ServantProtocolInvoker<T>
implements ProtocolInvoker<T> {
    private static final Logger logger = LoggerFactory.getClientLogger();
    protected final Class<T> api;
    protected final ServantProxyConfig servantProxyConfig;
    protected final ThreadPoolExecutor threadPoolExecutor;
    protected final ProtocolFactory protocolFactory;
    protected volatile SelectorManager selectorManager = null;
    protected volatile ConcurrentHashSet<Invoker<T>> allInvoker = new ConcurrentHashSet();

    public ServantProtocolInvoker(Class<T> api, ServantProxyConfig config, ProtocolFactory protocolFactory, ThreadPoolExecutor threadPoolExecutor) {
        this.api = api;
        this.servantProxyConfig = config;
        this.threadPoolExecutor = threadPoolExecutor;
        this.protocolFactory = protocolFactory;
        this.allInvoker = this.initInvoker();
    }

    @Override
    public abstract Invoker<T> create(Class<T> var1, Url var2) throws Exception;

    @Override
    public Collection<Invoker<T>> getInvokers() {
        return Collections.unmodifiableCollection(this.allInvoker);
    }

    @Override
    public void destroy() {
        this.destroy(this.allInvoker);
        this.selectorManager.stop();
    }

    @Override
    public void refresh() {
        logger.info("try to refresh " + this.servantProxyConfig.getSimpleObjectName());
        ArrayList<Invoker<T>> invokers = new ArrayList<Invoker<T>>(this.allInvoker);
        this.allInvoker = this.initInvoker();
        ScheduledExecutorManager.getInstance().schedule(() -> this.destroy(invokers), (long)Math.max(this.servantProxyConfig.getAsyncTimeout(), this.servantProxyConfig.getSyncTimeout()), TimeUnit.MILLISECONDS);
    }

    protected ServantClient[] getClients(Url url) throws IOException {
        int connections = url.getParameter("connections", 4);
        ServantClient[] clients = new ServantClient[connections];
        for (int i = 0; i < clients.length; ++i) {
            clients[i] = this.initClient(url);
        }
        return clients;
    }

    protected ServantClient initClient(Url url) {
        ServantClient client = null;
        try {
            boolean tcpNoDelay = url.getParameter("tcpNoDelay", false);
            long connectTimeout = url.getParameter("connectTimeout", 3000);
            long syncTimeout = url.getParameter("syncTimeout", 3000);
            long asyncTimeout = url.getParameter("asyncTimeout", 3000);
            boolean udpMode = url.getParameter("udpMode", false);
            if (this.selectorManager == null) {
                this.selectorManager = ClientPoolManager.getSelectorManager(this.protocolFactory, this.threadPoolExecutor, true, udpMode, this.servantProxyConfig);
            }
            client = new ServantClient(url.getHost(), url.getPort(), this.selectorManager, udpMode);
            client.setConnectTimeout(connectTimeout);
            client.setSyncTimeout(syncTimeout);
            client.setAsyncTimeout(asyncTimeout);
            client.setTcpNoDelay(tcpNoDelay);
        }
        catch (Throwable e) {
            throw new ClientException(this.servantProxyConfig.getSimpleObjectName(), "Fail to create client|" + url.toIdentityString() + "|" + e.getLocalizedMessage(), e);
        }
        return client;
    }

    protected ConcurrentHashSet<Invoker<T>> initInvoker() {
        try {
            logger.info("try to init invoker|conf={}" + this.servantProxyConfig.toString());
            List<Url> list = ParseTools.parse(this.servantProxyConfig);
            ConcurrentHashSet<Invoker<T>> needRefreshInvokers = new ConcurrentHashSet<Invoker<T>>();
            for (Url url : list) {
                try {
                    boolean active = url.getParameter("active", false);
                    if (active) {
                        logger.info("try to init invoker|active={} |{}", (Object)active, (Object)url.toIdentityString());
                        needRefreshInvokers.add(this.create(this.api, url));
                        continue;
                    }
                    logger.info("inactive invoker can't to init|active={}|{}", (Object)active, (Object)url.toIdentityString());
                }
                catch (Throwable e) {
                    logger.error("error occurred on init invoker|" + url.toIdentityString(), e);
                }
            }
            return needRefreshInvokers;
        }
        catch (Throwable t) {
            logger.error("error occurred on init invoker|" + this.servantProxyConfig.getObjectName(), t);
            return (ConcurrentHashSet)Collections.EMPTY_SET;
        }
    }

    private void destroy(Collection<Invoker<T>> invokers) {
        for (Invoker<T> invoker : invokers) {
            if (invoker == null) continue;
            logger.info("destroy reference|" + invoker);
            try {
                this.allInvoker.remove(invoker);
                invoker.destroy();
            }
            catch (Throwable t) {
                logger.error("error occurred on destroy invoker|" + invoker, t);
            }
        }
    }
}

