/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.LogBase;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.util.PidUtil;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class MetricWriter {
    private static final String CHARSET = SentinelConfig.charset();
    public static final String METRIC_BASE_DIR = LogBase.getLogBaseDir();
    public static final String METRIC_FILE = "metrics.log";
    public static final String METRIC_FILE_INDEX_SUFFIX = ".idx";
    public static final Comparator<String> METRIC_FILE_NAME_CMP = new MetricFileNameComparator();
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long timeSecondBase;
    private String baseDir;
    private String baseFileName;
    private File curMetricFile;
    private File curMetricIndexFile;
    private FileOutputStream outMetric;
    private DataOutputStream outIndex;
    private BufferedOutputStream outMetricBuf;
    private long singleFileSize;
    private int totalFileCount;
    private boolean append = false;
    private final int pid = PidUtil.getPid();
    private long lastSecond = -1L;

    public MetricWriter(long singleFileSize) {
        this(singleFileSize, 6);
    }

    public MetricWriter(long singleFileSize, int totalFileCount) {
        if (singleFileSize <= 0L || totalFileCount <= 0) {
            throw new IllegalArgumentException();
        }
        RecordLog.info("[MetricWriter] Creating new MetricWriter, singleFileSize={}, totalFileCount={}", singleFileSize, totalFileCount);
        this.baseDir = METRIC_BASE_DIR;
        File dir = new File(this.baseDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        long time = System.currentTimeMillis();
        this.lastSecond = time / 1000L;
        this.singleFileSize = singleFileSize;
        this.totalFileCount = totalFileCount;
        try {
            this.timeSecondBase = this.df.parse("1970-01-01 00:00:00").getTime() / 1000L;
        }
        catch (Exception e) {
            RecordLog.warn("[MetricWriter] Create new MetricWriter error", e);
        }
    }

    public synchronized void write(long time, List<MetricNode> nodes) throws Exception {
        long second;
        if (nodes == null) {
            return;
        }
        for (MetricNode node : nodes) {
            node.setTimestamp(time);
        }
        String appName = SentinelConfig.getAppName();
        if (appName == null) {
            appName = "";
        }
        if (this.curMetricFile == null) {
            this.baseFileName = MetricWriter.formMetricFileName(appName, this.pid);
            this.closeAndNewFile(this.nextFileNameOfDay(time));
        }
        if (!this.curMetricFile.exists() || !this.curMetricIndexFile.exists()) {
            this.closeAndNewFile(this.nextFileNameOfDay(time));
        }
        if ((second = time / 1000L) >= this.lastSecond) {
            if (second == this.lastSecond) {
                for (MetricNode node : nodes) {
                    this.outMetricBuf.write(node.toFatString().getBytes(CHARSET));
                }
                this.outMetricBuf.flush();
                if (!this.validSize()) {
                    this.closeAndNewFile(this.nextFileNameOfDay(time));
                }
            } else {
                this.writeIndex(second, this.outMetric.getChannel().position());
                if (this.isNewDay(this.lastSecond, second)) {
                    this.closeAndNewFile(this.nextFileNameOfDay(time));
                    for (MetricNode node : nodes) {
                        this.outMetricBuf.write(node.toFatString().getBytes(CHARSET));
                    }
                    this.outMetricBuf.flush();
                    if (!this.validSize()) {
                        this.closeAndNewFile(this.nextFileNameOfDay(time));
                    }
                } else {
                    for (MetricNode node : nodes) {
                        this.outMetricBuf.write(node.toFatString().getBytes(CHARSET));
                    }
                    this.outMetricBuf.flush();
                    if (!this.validSize()) {
                        this.closeAndNewFile(this.nextFileNameOfDay(time));
                    }
                }
                this.lastSecond = second;
            }
        }
    }

    public synchronized void close() throws Exception {
        if (this.outMetricBuf != null) {
            this.outMetricBuf.close();
        }
        if (this.outIndex != null) {
            this.outIndex.close();
        }
    }

    private void writeIndex(long time, long offset) throws Exception {
        this.outIndex.writeLong(time);
        this.outIndex.writeLong(offset);
        this.outIndex.flush();
    }

    private String nextFileNameOfDay(long time) {
        ArrayList<String> list = new ArrayList<String>();
        File baseFile = new File(this.baseDir);
        SimpleDateFormat fileNameDf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = fileNameDf.format(new Date(time));
        String fileNameModel = this.baseFileName + "." + dateStr;
        for (File file : baseFile.listFiles()) {
            String fileName = file.getName();
            if (!fileName.contains(fileNameModel) || fileName.endsWith(METRIC_FILE_INDEX_SUFFIX) || fileName.endsWith(".lck")) continue;
            list.add(file.getAbsolutePath());
        }
        Collections.sort(list, METRIC_FILE_NAME_CMP);
        if (list.isEmpty()) {
            return this.baseDir + fileNameModel;
        }
        String last = (String)list.get(list.size() - 1);
        int n = 0;
        String[] strs = last.split("\\.");
        if (strs.length > 0 && strs[strs.length - 1].matches("[0-9]{1,10}")) {
            n = Integer.parseInt(strs[strs.length - 1]);
        }
        return this.baseDir + fileNameModel + "." + (n + 1);
    }

    static List<String> listMetricFiles(String baseDir, String baseFileName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        File baseFile = new File(baseDir);
        File[] files = baseFile.listFiles();
        if (files == null) {
            return list;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!file.isFile() || !MetricWriter.fileNameMatches(fileName, baseFileName) || fileName.endsWith(METRIC_FILE_INDEX_SUFFIX) || fileName.endsWith(".lck")) continue;
            list.add(file.getAbsolutePath());
        }
        Collections.sort(list, METRIC_FILE_NAME_CMP);
        return list;
    }

    public static boolean fileNameMatches(String fileName, String baseFileName) {
        if (fileName.startsWith(baseFileName)) {
            String part = fileName.substring(baseFileName.length());
            return part.matches("\\.[0-9]{4}-[0-9]{2}-[0-9]{2}(\\.[0-9]*)?");
        }
        return false;
    }

    private void removeMoreFiles() throws Exception {
        List<String> list = MetricWriter.listMetricFiles(this.baseDir, this.baseFileName);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size() - this.totalFileCount + 1; ++i) {
            String fileName = list.get(i);
            String indexFile = MetricWriter.formIndexFileName(fileName);
            new File(fileName).delete();
            RecordLog.info("[MetricWriter] Removing metric file: {}", fileName);
            new File(indexFile).delete();
            RecordLog.info("[MetricWriter] Removing metric index file: {}", indexFile);
        }
    }

    private void closeAndNewFile(String fileName) throws Exception {
        this.removeMoreFiles();
        if (this.outMetricBuf != null) {
            this.outMetricBuf.close();
        }
        if (this.outIndex != null) {
            this.outIndex.close();
        }
        this.outMetric = new FileOutputStream(fileName, this.append);
        this.outMetricBuf = new BufferedOutputStream(this.outMetric);
        this.curMetricFile = new File(fileName);
        String idxFile = MetricWriter.formIndexFileName(fileName);
        this.curMetricIndexFile = new File(idxFile);
        this.outIndex = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(idxFile, this.append)));
        RecordLog.info("[MetricWriter] New metric file created: {}", fileName);
        RecordLog.info("[MetricWriter] New metric index file created: {}", idxFile);
    }

    private boolean validSize() throws Exception {
        long size = this.outMetric.getChannel().size();
        return size < this.singleFileSize;
    }

    private boolean isNewDay(long lastSecond, long second) {
        long newDay = (second - this.timeSecondBase) / 86400L;
        long lastDay = (lastSecond - this.timeSecondBase) / 86400L;
        return newDay > lastDay;
    }

    public static String formMetricFileName(String appName, int pid) {
        if (appName == null) {
            appName = "";
        }
        String dot = ".";
        String separator = "-";
        if (appName.contains(".")) {
            appName = appName.replace(".", "-");
        }
        String name = appName + "-" + METRIC_FILE;
        if (LogBase.isLogNameUsePid()) {
            name = name + ".pid" + pid;
        }
        return name;
    }

    public static String formIndexFileName(String metricFileName) {
        return metricFileName + METRIC_FILE_INDEX_SUFFIX;
    }

    private static final class MetricFileNameComparator
    implements Comparator<String> {
        private final String pid = "pid";

        private MetricFileNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int t;
            String name1 = new File(o1).getName();
            String name2 = new File(o2).getName();
            String dateStr1 = name1.split("\\.")[2];
            String dateStr2 = name2.split("\\.")[2];
            if (dateStr1.startsWith("pid")) {
                dateStr1 = name1.split("\\.")[3];
                dateStr2 = name2.split("\\.")[3];
            }
            if ((t = dateStr1.compareTo(dateStr2)) != 0) {
                return t;
            }
            t = name1.length() - name2.length();
            if (t != 0) {
                return t;
            }
            return name1.compareTo(name2);
        }
    }
}

