/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.web.loader.PluginJarParser;
import org.apache.shenyu.web.loader.ShenyuPluginClassLoader;

public final class ShenyuPluginClassLoaderHolder {
    private static final ShenyuPluginClassLoaderHolder HOLDER = new ShenyuPluginClassLoaderHolder();
    private final Map<String, ShenyuPluginClassLoader> pluginCache = new ConcurrentHashMap<String, ShenyuPluginClassLoader>();

    private ShenyuPluginClassLoaderHolder() {
    }

    public static ShenyuPluginClassLoaderHolder getSingleton() {
        return HOLDER;
    }

    public ShenyuPluginClassLoader createPluginClassLoader(PluginJarParser.PluginJar pluginJar) {
        ShenyuPluginClassLoader shenyuPluginClassLoader = new ShenyuPluginClassLoader(pluginJar);
        String jarKey = Optional.ofNullable(pluginJar.getAbsolutePath()).orElse(pluginJar.getJarKey());
        if (this.pluginCache.containsKey(jarKey)) {
            this.pluginCache.remove(jarKey).close();
        }
        this.pluginCache.put(jarKey, shenyuPluginClassLoader);
        return shenyuPluginClassLoader;
    }

    public void removePluginClassLoader(String jarKey) {
        if (this.pluginCache.containsKey(jarKey)) {
            this.pluginCache.remove(jarKey).close();
        }
    }
}

