/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.core;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeDataSyncService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeDataSyncService.class);
    private final ChangeData changeData;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;
    private final List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers;
    private final List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers;
    private final ShenyuConfig shenyuConfig;

    public AbstractNodeDataSyncService(ChangeData changeData, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers, ShenyuConfig shenyuConfig) {
        this.changeData = changeData;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.proxySelectorDataSubscribers = proxySelectorDataSubscribers;
        this.discoveryUpstreamDataSubscribers = discoveryUpstreamDataSubscribers;
        this.shenyuConfig = shenyuConfig;
    }

    protected void startWatch() {
        try {
            String namespaceId = this.shenyuConfig.getNamespace();
            List<String> pluginNames = this.getConfigListOnWatch(namespaceId + "." + this.changeData.getPluginDataId() + ".list", updateData -> {
                List changedPluginNames = GsonUtils.getInstance().fromList(updateData, String.class);
                this.watcherPlugin(changedPluginNames, namespaceId);
            });
            this.watcherPlugin(pluginNames, namespaceId);
            this.watchCommonList(namespaceId + "." + this.changeData.getAuthDataId() + ".", this::cacheAuthData, this::unCacheAuthData);
            this.watchCommonList(namespaceId + "." + this.changeData.getMetaDataId() + ".", this::cacheMetaData, this::unCacheMetaData);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private List<String> getConfigListOnWatch(String key, Consumer<String> updateHandler) {
        String serviceConfig = this.getServiceConfig(key, updateHandler, null);
        return GsonUtils.getInstance().fromList(serviceConfig, String.class);
    }

    protected abstract String getServiceConfig(String var1, Consumer<String> var2, Consumer<String> var3);

    private String getConfigOnWatch(String key, Consumer<String> updateHandler, Consumer<String> deleteHandler) {
        return this.getServiceConfig(key, updateHandler, deleteHandler);
    }

    private void removeListener(String removeKey) {
        LOG.info("AbstractNodeDataSyncService sync remove listener key:{}", (Object)removeKey);
        this.doRemoveListener(removeKey);
    }

    protected abstract void doRemoveListener(String var1);

    private void watcherPlugin(List<String> pluginNames, String namespaceId) {
        if (ObjectUtils.isEmpty(pluginNames)) {
            return;
        }
        pluginNames.forEach(pluginName -> {
            String pluginData = this.getConfigOnWatch(namespaceId + "." + this.changeData.getPluginDataId() + "." + pluginName, this::cachePluginData, this::unCachePluginData);
            this.cachePluginData(pluginData);
            String pluginPath = namespaceId + "." + this.changeData.getSelectorDataId() + "." + pluginName + ".list";
            List<String> selectorIds = this.getConfigListOnWatch(pluginPath, updateData -> {
                List changedSelectorIds = GsonUtils.getInstance().fromList(updateData, String.class);
                this.watcherSelector((String)pluginName, changedSelectorIds, namespaceId);
            });
            this.watcherSelector((String)pluginName, selectorIds, namespaceId);
            this.watchCommonList(namespaceId + ".proxy.selector." + pluginName + ".", this::cacheProxySelectorData, this::unCacheProxySelectorData);
            this.watchCommonList(namespaceId + ".discovery." + pluginName + ".", this::cacheDiscoveryUpstreamData, this::unCacheDiscoveryUpstreamData);
        });
    }

    private void watchCommonList(String keyPrefix, Consumer<String> updateHandler, Consumer<String> deleteHandler) {
        List<String> keyIds = this.getConfigListOnWatch(keyPrefix + "list", updateData -> {
            List changedIds = GsonUtils.getInstance().fromList(updateData, String.class);
            this.watcherCommonData(changedIds, keyPrefix, updateHandler, deleteHandler);
        });
        this.watcherCommonData(keyIds, keyPrefix, updateHandler, deleteHandler);
    }

    private void watcherCommonData(List<String> keys, String keyPrefix, Consumer<String> updateHandler, Consumer<String> deleteHandler) {
        if (ObjectUtils.isEmpty(keys)) {
            return;
        }
        keys.forEach(key -> {
            String keyData = this.getConfigOnWatch(keyPrefix + key, updateHandler, deleteHandler);
            updateHandler.accept(keyData);
        });
    }

    private void watcherSelector(String pluginName, List<String> selectorIds, String namespaceId) {
        if (ObjectUtils.isEmpty(selectorIds)) {
            return;
        }
        selectorIds.forEach(selectorId -> {
            String selectorData = this.getConfigOnWatch(namespaceId + "." + this.changeData.getSelectorDataId() + "." + pluginName + "." + selectorId, this::cacheSelectorData, this::unCacheSelectorData);
            this.cacheSelectorData(selectorData);
            List<String> ruleIds = this.getConfigListOnWatch(namespaceId + "." + this.changeData.getRuleDataId() + "." + pluginName + "." + selectorId + ".list", updateData -> {
                List upSelectorIds = GsonUtils.getInstance().fromList(updateData, String.class);
                this.watcherRule((String)selectorId, upSelectorIds, pluginName, namespaceId);
            });
            this.watcherRule((String)selectorId, ruleIds, pluginName, namespaceId);
        });
    }

    private void watcherRule(String selectorId, List<String> ruleIds, String pluginName, String namespaceId) {
        if (ObjectUtils.isEmpty(ruleIds)) {
            return;
        }
        ruleIds.forEach(ruleId -> {
            String ruleDataStr = this.getConfigOnWatch(namespaceId + "." + this.changeData.getRuleDataId() + "." + pluginName + "." + selectorId + "." + ruleId, this::cacheRuleData, this::unCacheRuleData);
            this.cacheRuleData(ruleDataStr);
        });
    }

    protected void cachePluginData(String dataString) {
        PluginData pluginData = (PluginData)GsonUtils.getInstance().fromJson(dataString, PluginData.class);
        Optional.ofNullable(pluginData).flatMap(data -> Optional.ofNullable(this.pluginDataSubscriber)).ifPresent(e -> e.onSubscribe(pluginData));
    }

    protected void unCachePluginData(String pluginName) {
        PluginData data = new PluginData();
        data.setName(pluginName);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(data));
    }

    protected void cacheSelectorData(String dataString) {
        SelectorData selectorData = (SelectorData)GsonUtils.getInstance().fromJson(dataString, SelectorData.class);
        Optional.ofNullable(selectorData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe((SelectorData)data)));
    }

    protected void unCacheSelectorData(String removeKey) {
        SelectorData selectorData = new SelectorData();
        String[] ruleKeys = StringUtils.split((String)removeKey, (String)".");
        selectorData.setPluginName(ruleKeys[2]);
        selectorData.setId(ruleKeys[3]);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData));
        this.removeListener(removeKey);
    }

    protected void cacheRuleData(String dataString) {
        RuleData ruleData = (RuleData)GsonUtils.getInstance().fromJson(dataString, RuleData.class);
        Optional.ofNullable(ruleData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe((RuleData)data)));
    }

    protected void unCacheRuleData(String removeKey) {
        RuleData ruleData = new RuleData();
        String[] ruleKeys = StringUtils.split((String)removeKey, (String)".");
        ruleData.setPluginName(ruleKeys[2]);
        ruleData.setSelectorId(ruleKeys[3]);
        ruleData.setId(ruleKeys[4]);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData));
        this.removeListener(removeKey);
    }

    protected void cacheAuthData(String dataString) {
        AppAuthData appAuthData = (AppAuthData)GsonUtils.getInstance().fromJson(dataString, AppAuthData.class);
        Optional.ofNullable(appAuthData).ifPresent(data -> this.authDataSubscribers.forEach(e -> e.onSubscribe((AppAuthData)data)));
    }

    protected void unCacheAuthData(String removeKey) {
        AppAuthData appAuthData = new AppAuthData();
        String[] ruleKeys = StringUtils.split((String)removeKey, (String)".");
        appAuthData.setAppKey(ruleKeys[1]);
        this.authDataSubscribers.forEach(e -> e.unSubscribe(appAuthData));
        this.removeListener(removeKey);
    }

    protected void cacheMetaData(String dataString) {
        MetaData metaData = (MetaData)GsonUtils.getInstance().fromJson(dataString, MetaData.class);
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.onSubscribe(metaData)));
    }

    protected void unCacheMetaData(String removeKey) {
        MetaData metaData = new MetaData();
        String[] ruleKeys = StringUtils.split((String)removeKey, (String)".");
        metaData.setId(ruleKeys[1]);
        this.metaDataSubscribers.forEach(e -> e.unSubscribe(metaData));
        this.removeListener(removeKey);
    }

    protected void cacheProxySelectorData(String dataString) {
        ProxySelectorData proxySelectorData = (ProxySelectorData)GsonUtils.getInstance().fromJson(dataString, ProxySelectorData.class);
        Optional.ofNullable(proxySelectorData).ifPresent(data -> this.proxySelectorDataSubscribers.forEach(e -> e.onSubscribe((ProxySelectorData)data)));
    }

    protected void unCacheProxySelectorData(String removeKey) {
        ProxySelectorData proxySelectorData = new ProxySelectorData();
        String[] proxySelectorKeys = StringUtils.split((String)removeKey, (String)".");
        proxySelectorData.setPluginName(proxySelectorKeys[2]);
        proxySelectorData.setName(proxySelectorKeys[3]);
        this.proxySelectorDataSubscribers.forEach(e -> e.unSubscribe(proxySelectorData));
        this.removeListener(removeKey);
    }

    protected void cacheDiscoveryUpstreamData(String dataString) {
        DiscoverySyncData discoverySyncData = (DiscoverySyncData)GsonUtils.getInstance().fromJson(dataString, DiscoverySyncData.class);
        Optional.ofNullable(discoverySyncData).ifPresent(data -> this.discoveryUpstreamDataSubscribers.forEach(e -> e.onSubscribe((DiscoverySyncData)data)));
    }

    protected void unCacheDiscoveryUpstreamData(String removeKey) {
        DiscoverySyncData proxySelectorData = new DiscoverySyncData();
        String[] proxySelectorKeys = StringUtils.split((String)removeKey, (String)".");
        proxySelectorData.setPluginName(proxySelectorKeys[2]);
        proxySelectorData.setSelectorId(proxySelectorKeys[3]);
        this.discoveryUpstreamDataSubscribers.forEach(e -> e.unSubscribe(proxySelectorData));
        this.removeListener(removeKey);
    }

    public static class ChangeData {
        private final String pluginDataId;
        private final String selectorDataId;
        private final String ruleDataId;
        private final String authDataId;
        private final String metaDataId;
        private final String proxySelectorDataId;
        private final String discoveryDataId;

        public ChangeData(String pluginDataId, String selectorDataId, String ruleDataId, String authDataId, String metaDataId, String proxySelectorDataId, String discoveryDataId) {
            this.pluginDataId = pluginDataId;
            this.selectorDataId = selectorDataId;
            this.ruleDataId = ruleDataId;
            this.authDataId = authDataId;
            this.metaDataId = metaDataId;
            this.proxySelectorDataId = proxySelectorDataId;
            this.discoveryDataId = discoveryDataId;
        }

        public String getPluginDataId() {
            return this.pluginDataId;
        }

        public String getSelectorDataId() {
            return this.selectorDataId;
        }

        public String getRuleDataId() {
            return this.ruleDataId;
        }

        public String getAuthDataId() {
            return this.authDataId;
        }

        public String getMetaDataId() {
            return this.metaDataId;
        }

        public String getProxySelectorDataId() {
            return this.proxySelectorDataId;
        }

        public String getDiscoveryDataId() {
            return this.discoveryDataId;
        }
    }
}

