/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCompositeConfiguration
extends ConcurrentMapConfiguration
implements AggregatedConfiguration,
ConfigurationListener,
Cloneable {
    private Map<String, AbstractConfiguration> namedConfigurations = new ConcurrentHashMap<String, AbstractConfiguration>();
    private List<AbstractConfiguration> configList = new CopyOnWriteArrayList<AbstractConfiguration>();
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentCompositeConfiguration.class);
    public static final int EVENT_CONFIGURATION_SOURCE_CHANGED = 10001;
    private volatile boolean propagateEventToParent = true;
    private AbstractConfiguration overrideProperties;
    private AbstractConfiguration containerConfiguration;
    private volatile boolean containerConfigurationChanged = true;
    private ConfigurationListener eventPropagater = new ConfigurationListener(){

        public void configurationChanged(ConfigurationEvent configurationEvent) {
            if (!configurationEvent.isBeforeUpdate() && ConcurrentCompositeConfiguration.this.propagateEventToParent) {
                int n = configurationEvent.getType();
                String string = configurationEvent.getPropertyName();
                Object object = configurationEvent.getPropertyValue();
                Object object2 = null;
                switch (n) {
                    case 4: 
                    case 11: 
                    case 10001: {
                        ConcurrentCompositeConfiguration.this.fireEvent(n, string, object, false);
                        break;
                    }
                    case 1: 
                    case 3: {
                        Configuration configuration = ConcurrentCompositeConfiguration.this.getSource(string);
                        if (configuration != configurationEvent.getSource()) break;
                        ConcurrentCompositeConfiguration.this.fireEvent(n, string, object, false);
                        break;
                    }
                    case 2: {
                        object2 = ConcurrentCompositeConfiguration.this.getProperty(string);
                        if (object2 == null) {
                            ConcurrentCompositeConfiguration.this.fireEvent(n, string, object, false);
                            break;
                        }
                        ConcurrentCompositeConfiguration.this.fireEvent(3, string, object2, false);
                        break;
                    }
                }
            }
        }
    };

    public ConcurrentCompositeConfiguration() {
        this.clear();
    }

    public ConcurrentCompositeConfiguration(AbstractConfiguration abstractConfiguration) {
        this.configList.clear();
        this.containerConfiguration = abstractConfiguration;
        this.configList.add(abstractConfiguration);
    }

    public ConcurrentCompositeConfiguration(AbstractConfiguration abstractConfiguration, Collection<? extends AbstractConfiguration> collection) {
        this(abstractConfiguration);
        if (collection != null) {
            for (AbstractConfiguration abstractConfiguration2 : collection) {
                this.addConfiguration(abstractConfiguration2);
            }
        }
    }

    public void configurationChanged(ConfigurationEvent configurationEvent) {
    }

    public void invalidate() {
    }

    @Override
    public final void addConfiguration(AbstractConfiguration abstractConfiguration) {
        this.addConfiguration(abstractConfiguration, null);
    }

    @Override
    public void addConfiguration(AbstractConfiguration abstractConfiguration, String string) {
        if (this.containerConfigurationChanged) {
            this.addConfigurationAtIndex(abstractConfiguration, string, this.configList.size());
        } else {
            this.addConfigurationAtIndex(abstractConfiguration, string, this.configList.indexOf(this.containerConfiguration));
        }
    }

    @Override
    public List<AbstractConfiguration> getConfigurations() {
        return Collections.unmodifiableList(this.configList);
    }

    @Override
    public List<String> getConfigurationNameList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.configList.size());
        for (AbstractConfiguration abstractConfiguration : this.configList) {
            boolean bl = false;
            for (String string : this.namedConfigurations.keySet()) {
                if (abstractConfiguration != this.namedConfigurations.get(string)) continue;
                bl = true;
                arrayList.add(string);
                break;
            }
            if (bl) continue;
            arrayList.add(null);
        }
        return arrayList;
    }

    public int getIndexOfConfiguration(AbstractConfiguration abstractConfiguration) {
        return this.configList.indexOf(abstractConfiguration);
    }

    public int getIndexOfContainerConfiguration() {
        return this.configList.indexOf(this.containerConfiguration);
    }

    private void checkIndex(int n) {
        if (n < 0 || n > this.configList.size()) {
            throw new IndexOutOfBoundsException(n + " is out of bounds of the size of configuration list " + this.configList.size());
        }
    }

    public void setContainerConfiguration(AbstractConfiguration abstractConfiguration, String string, int n) throws IndexOutOfBoundsException {
        if (!this.configList.contains(abstractConfiguration)) {
            this.checkIndex(n);
            this.containerConfigurationChanged = true;
            this.containerConfiguration = abstractConfiguration;
            this.addConfigurationAtIndex(abstractConfiguration, string, n);
        } else {
            logger.warn(abstractConfiguration + " is not added as it already exits");
        }
    }

    public void setContainerConfigurationIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.configList.size()) {
            throw new IndexOutOfBoundsException("Cannot change to the new index " + n + " in the list of size " + this.configList.size());
        }
        if (n == this.configList.indexOf(this.containerConfiguration)) {
            return;
        }
        this.containerConfigurationChanged = true;
        this.configList.remove(this.containerConfiguration);
        this.configList.add(n, this.containerConfiguration);
    }

    public void addConfigurationAtIndex(AbstractConfiguration abstractConfiguration, String string, int n) throws IndexOutOfBoundsException {
        if (!this.configList.contains(abstractConfiguration)) {
            this.checkIndex(n);
            this.configList.add(n, abstractConfiguration);
            if (string != null) {
                this.namedConfigurations.put(string, abstractConfiguration);
            }
            abstractConfiguration.addConfigurationListener(this.eventPropagater);
            this.fireEvent(10001, null, null, false);
        } else {
            logger.warn(abstractConfiguration + " is not added as it already exits");
        }
    }

    public void addConfigurationAtFront(AbstractConfiguration abstractConfiguration, String string) {
        this.addConfigurationAtIndex(abstractConfiguration, string, 0);
    }

    @Override
    public boolean removeConfiguration(Configuration configuration) {
        if (!configuration.equals(this.containerConfiguration)) {
            return this.configList.remove((AbstractConfiguration)configuration);
        }
        return false;
    }

    public AbstractConfiguration removeConfigurationAt(int n) {
        AbstractConfiguration abstractConfiguration = this.configList.remove(n);
        String string = null;
        for (String string2 : this.namedConfigurations.keySet()) {
            if (this.namedConfigurations.get(string2) != abstractConfiguration) continue;
            string = string2;
            break;
        }
        if (string != null) {
            this.namedConfigurations.remove(string);
        }
        return abstractConfiguration;
    }

    @Override
    public Configuration removeConfiguration(String string) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration != null) {
            this.removeConfiguration(configuration);
        }
        return configuration;
    }

    @Override
    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    @Override
    public final void clear() {
        this.fireEvent(4, null, null, true);
        this.configList.clear();
        this.namedConfigurations.clear();
        this.containerConfiguration = new ConcurrentMapConfiguration();
        this.containerConfiguration.setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        this.containerConfiguration.setListDelimiter(this.getListDelimiter());
        this.containerConfiguration.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        this.containerConfiguration.addConfigurationListener(this.eventPropagater);
        this.configList.add(this.containerConfiguration);
        this.overrideProperties = new ConcurrentMapConfiguration();
        this.overrideProperties.setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        this.overrideProperties.setListDelimiter(this.getListDelimiter());
        this.overrideProperties.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        this.overrideProperties.addConfigurationListener(this.eventPropagater);
        this.fireEvent(4, null, null, false);
        this.containerConfigurationChanged = false;
        this.invalidate();
    }

    public void setOverrideProperty(String string, Object object) {
        this.overrideProperties.setProperty(string, object);
    }

    public void clearOverrideProperty(String string) {
        this.overrideProperties.clearProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.containerConfiguration.setProperty(string, object);
    }

    @Override
    public void addProperty(String string, Object object) {
        this.containerConfiguration.addProperty(string, object);
    }

    public void clearProperty(String string) {
        this.containerConfiguration.clearProperty(string);
    }

    @Override
    public Object getProperty(String string) {
        if (this.overrideProperties.containsKey(string)) {
            return this.overrideProperties.getProperty(string);
        }
        AbstractConfiguration abstractConfiguration = null;
        for (AbstractConfiguration abstractConfiguration2 : this.configList) {
            if (!abstractConfiguration2.containsKey(string)) continue;
            abstractConfiguration = abstractConfiguration2;
            break;
        }
        if (abstractConfiguration != null) {
            return abstractConfiguration.getProperty(string);
        }
        return null;
    }

    @Override
    public Iterator<String> getKeys() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator<AbstractConfiguration> iterator = this.overrideProperties.getKeys();
        while (iterator.hasNext()) {
            linkedHashSet.add(iterator.next());
        }
        for (AbstractConfiguration abstractConfiguration : this.configList) {
            Iterator iterator2 = abstractConfiguration.getKeys();
            while (iterator2.hasNext()) {
                linkedHashSet.add(iterator2.next());
            }
        }
        return linkedHashSet.iterator();
    }

    public Iterator<String> getKeys(String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator<AbstractConfiguration> iterator = this.overrideProperties.getKeys(string);
        while (iterator.hasNext()) {
            linkedHashSet.add(iterator.next());
        }
        for (AbstractConfiguration abstractConfiguration : this.configList) {
            Iterator iterator2 = abstractConfiguration.getKeys(string);
            while (iterator2.hasNext()) {
                linkedHashSet.add(iterator2.next());
            }
        }
        return linkedHashSet.iterator();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    @Override
    public boolean isEmpty() {
        if (this.overrideProperties.isEmpty()) {
            return false;
        }
        for (AbstractConfiguration abstractConfiguration : this.configList) {
            if (abstractConfiguration.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(String string) {
        if (this.overrideProperties.containsKey(string)) {
            return true;
        }
        for (AbstractConfiguration abstractConfiguration : this.configList) {
            if (!abstractConfiguration.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    public List getList(String string, List list) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<AbstractConfiguration> iterator = this.configList.iterator();
        if (this.overrideProperties.containsKey(string)) {
            ConcurrentCompositeConfiguration.appendListProperty(arrayList, (Configuration)this.overrideProperties, string);
        }
        while (iterator.hasNext() && arrayList.isEmpty()) {
            object = (Configuration)iterator.next();
            if (object == this.containerConfiguration && !this.containerConfigurationChanged || !object.containsKey(string)) continue;
            ConcurrentCompositeConfiguration.appendListProperty(arrayList, (Configuration)object, string);
        }
        if (arrayList.isEmpty()) {
            ConcurrentCompositeConfiguration.appendListProperty(arrayList, (Configuration)this.containerConfiguration, string);
        }
        if (arrayList.isEmpty()) {
            return list;
        }
        object = arrayList.listIterator();
        while (object.hasNext()) {
            object.set(this.interpolate(object.next()));
        }
        return arrayList;
    }

    public String[] getStringArray(String string) {
        List list = this.getList(string);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(list.get(i));
        }
        return stringArray;
    }

    @Override
    public Configuration getConfiguration(int n) {
        return (Configuration)this.configList.get(n);
    }

    @Override
    public Configuration getConfiguration(String string) {
        return (Configuration)this.namedConfigurations.get(string);
    }

    public Configuration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public Object clone() {
        try {
            ConcurrentCompositeConfiguration concurrentCompositeConfiguration = (ConcurrentCompositeConfiguration)super.clone();
            concurrentCompositeConfiguration.clearConfigurationListeners();
            concurrentCompositeConfiguration.configList = new LinkedList<AbstractConfiguration>();
            concurrentCompositeConfiguration.containerConfiguration = (AbstractConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)this.getContainerConfiguration());
            concurrentCompositeConfiguration.configList.add(concurrentCompositeConfiguration.containerConfiguration);
            for (AbstractConfiguration abstractConfiguration : this.configList) {
                if (abstractConfiguration == this.getContainerConfiguration()) continue;
                concurrentCompositeConfiguration.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)abstractConfiguration));
            }
            return concurrentCompositeConfiguration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConfigurationRuntimeException((Throwable)cloneNotSupportedException);
        }
    }

    public void setDelimiterParsingDisabled(boolean bl) {
        this.containerConfiguration.setDelimiterParsingDisabled(bl);
        super.setDelimiterParsingDisabled(bl);
    }

    public void setListDelimiter(char c) {
        this.containerConfiguration.setListDelimiter(c);
        super.setListDelimiter(c);
    }

    public Configuration getSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        if (this.overrideProperties.containsKey(string)) {
            return this.overrideProperties;
        }
        for (AbstractConfiguration abstractConfiguration : this.configList) {
            if (!abstractConfiguration.containsKey(string)) continue;
            return abstractConfiguration;
        }
        return null;
    }

    private static void appendListProperty(List<Object> list, Configuration configuration, String string) {
        Object object = configuration.getProperty(string);
        if (object != null) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                list.addAll(collection);
            } else {
                list.add(object);
            }
        }
    }

    public final boolean isPropagateEventFromSubConfigurations() {
        return this.propagateEventToParent;
    }

    public final void setPropagateEventFromSubConfigurations(boolean bl) {
        this.propagateEventToParent = bl;
    }
}

