/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.content.Media;
import org.springframework.ai.content.MediaContent;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AssistantMessage
extends AbstractMessage
implements MediaContent {
    private final List<ToolCall> toolCalls;
    protected final List<Media> media;

    public AssistantMessage(String content) {
        this(content, Map.of());
    }

    public AssistantMessage(String content, Map<String, Object> properties) {
        this(content, properties, List.of());
    }

    public AssistantMessage(String content, Map<String, Object> properties, List<ToolCall> toolCalls) {
        this(content, properties, toolCalls, List.of());
    }

    public AssistantMessage(String content, Map<String, Object> properties, List<ToolCall> toolCalls, List<Media> media) {
        super(MessageType.ASSISTANT, content, properties);
        Assert.notNull(toolCalls, (String)"Tool calls must not be null");
        Assert.notNull(media, (String)"Media must not be null");
        this.toolCalls = toolCalls;
        this.media = media;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean hasToolCalls() {
        return !CollectionUtils.isEmpty(this.toolCalls);
    }

    public List<Media> getMedia() {
        return this.media;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssistantMessage)) {
            return false;
        }
        AssistantMessage that = (AssistantMessage)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.toolCalls, that.toolCalls) && Objects.equals(this.media, that.media);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toolCalls, this.media);
    }

    public String toString() {
        return "AssistantMessage [messageType=" + String.valueOf((Object)this.messageType) + ", toolCalls=" + String.valueOf(this.toolCalls) + ", textContent=" + this.textContent + ", metadata=" + String.valueOf(this.metadata) + "]";
    }

    public record ToolCall(String id, String type, String name, String arguments) {
    }
}

