/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.transport;

import com.ecwid.consul.transport.AbstractHttpTransport;
import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.transport.TransportException;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public final class DefaultHttpsTransport
extends AbstractHttpTransport {
    private final HttpClient httpClient;

    public DefaultHttpsTransport(TLSConfig tlsConfig) {
        try {
            KeyStore clientStore = KeyStore.getInstance(tlsConfig.getKeyStoreInstanceType().name());
            clientStore.load(new FileInputStream(tlsConfig.getCertificatePath()), tlsConfig.getCertificatePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientStore, tlsConfig.getCertificatePassword().toCharArray());
            KeyManager[] kms = kmf.getKeyManagers();
            KeyStore trustStore = KeyStore.getInstance(TLSConfig.KeyStoreInstanceType.JKS.name());
            trustStore.load(new FileInputStream(tlsConfig.getKeyStorePath()), tlsConfig.getKeyStorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            sslContext.init(kms, tms, new SecureRandom());
            SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslContext);
            Registry registry = RegistryBuilder.create().register("https", (Object)factory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
            connectionManager.setMaxTotal(1000);
            connectionManager.setDefaultMaxPerRoute(500);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(600000).build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
            this.httpClient = httpClientBuilder.build();
        }
        catch (GeneralSecurityException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    public DefaultHttpsTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    protected HttpClient getHttpClient() {
        return this.httpClient;
    }
}

