/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.util;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.huaweicloud.lts.producer.util.NetworkUtils;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static void assertArgumentNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException(argumentName + " cannot be null");
        }
    }

    public static void assertArgumentNotNullOrEmpty(String argument, String argumentName) {
        Utils.assertArgumentNotNull(argument, argumentName);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(argumentName + " cannot be empty");
        }
    }

    public static String generateProducerHash(int instanceId) {
        String ip = NetworkUtils.getLocalMachineIP();
        if (ip == null) {
            LOGGER.warn("Failed to get local machine ip, set ip to 127.0.0.1");
            ip = "127.0.0.1";
        }
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String input = ip + "-" + name + "-" + instanceId;
        return Hashing.farmHashFingerprint64().hashString((CharSequence)input, Charsets.US_ASCII).toString();
    }

    public static String generatePackageId(String producerHash, AtomicLong batchId) {
        return producerHash + "-" + Long.toHexString(batchId.getAndIncrement());
    }

    public static String getOrEmpty(Map<String, String> map, String key) {
        return map.containsKey(key) ? map.get(key) : "";
    }

    public static List<String> getStrList(String inputString, int length) {
        int size = inputString.length() / length;
        if (inputString.length() % length != 0) {
            ++size;
        }
        return Utils.getStrList(inputString, length, size);
    }

    private static List<String> getStrList(String inputString, int length, int size) {
        ArrayList<String> list = new ArrayList<String>();
        for (int index = 0; index < size; ++index) {
            String childStr = Utils.substring(inputString, index * length, (index + 1) * length);
            list.add(childStr);
        }
        return list;
    }

    private static String substring(String str, int f, int t) {
        if (f > str.length()) {
            return null;
        }
        if (t > str.length()) {
            return str.substring(f);
        }
        return str.substring(f, t);
    }
}

