/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix.lang.infix.antlr;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.netflix.infix.NumericValuePredicate;
import com.netflix.infix.PathValueEventFilter;
import com.netflix.infix.Predicates;
import com.netflix.infix.lang.infix.antlr.NumberTreeNode;
import com.netflix.infix.lang.infix.antlr.PredicateBaseTreeNode;
import com.netflix.infix.lang.infix.antlr.PredicateTranslatable;
import com.netflix.infix.lang.infix.antlr.TreeNodeUtil;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;

public class NumericInTreeNode
extends PredicateBaseTreeNode
implements PredicateTranslatable {
    @Override
    public Predicate<Object> translate() {
        final String xpath = TreeNodeUtil.getXPath(this.getChild(0));
        List children = this.getChildren();
        return Predicates.or(Lists.transform(children.subList(1, children.size()), (Function)new Function<Object, Predicate<Object>>(){

            public Predicate<Object> apply(Object node) {
                Number value = ((NumberTreeNode)node).getValue();
                return new PathValueEventFilter<Object>(xpath, new NumericValuePredicate(value, "="));
            }
        }));
    }

    public NumericInTreeNode(Token t) {
        super(t);
    }

    public NumericInTreeNode(NumericInTreeNode node) {
        super(node);
    }

    public Tree dupNode() {
        return new NumericInTreeNode(this);
    }
}

