/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.Objects;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionUtil.class);
    private static final ThreadLocal<UserInfo> LOCAL_VISITOR = new InheritableThreadLocal<UserInfo>();

    private SessionUtil() {
    }

    public static String visitorName() {
        return SessionUtil.visitor().getUserName();
    }

    public static String visitorId() {
        return SessionUtil.visitor().getUserId();
    }

    public static UserInfo visitor() {
        try {
            UserInfo userInfo = LOCAL_VISITOR.get();
            if (Objects.isNull(userInfo)) {
                SessionUtil.setLocalVisitorFromAuth();
            }
            return LOCAL_VISITOR.get();
        }
        catch (Exception e) {
            LOG.warn("get user info error ,not found, used default user ,it unknown");
            return SessionUtil.defaultUser();
        }
    }

    public static void setLocalVisitor(UserInfo userInfo) {
        LOCAL_VISITOR.set(userInfo);
    }

    public static void setLocalVisitorFromAuth() {
        UserInfo userInfo = JwtUtils.getUserInfo();
        LOCAL_VISITOR.set(Objects.isNull(userInfo) ? SessionUtil.defaultUser() : userInfo);
    }

    public static void clean() {
        LOCAL_VISITOR.remove();
    }

    public static boolean isAdmin() {
        return "admin".equals(SessionUtil.visitorName());
    }

    private static UserInfo defaultUser() {
        return UserInfo.builder().userId("-1").userName("unknown").build();
    }
}

