/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.common.constant.ResourceTypeConstants;

public class PermissionMenuVO
implements Serializable {
    private static final long serialVersionUID = 8260199815923117085L;
    private List<MenuInfo> menu;
    private List<AuthPerm> currentAuth;
    private List<AuthPerm> allAuth;

    public PermissionMenuVO() {
    }

    public PermissionMenuVO(List<MenuInfo> menu, List<AuthPerm> currentAuth, List<AuthPerm> allAuth) {
        this.menu = menu;
        this.currentAuth = currentAuth;
        this.allAuth = allAuth;
    }

    public List<MenuInfo> getMenu() {
        return this.menu;
    }

    public void setMenu(List<MenuInfo> menu) {
        this.menu = menu;
    }

    public List<AuthPerm> getCurrentAuth() {
        return this.currentAuth;
    }

    public void setCurrentAuth(List<AuthPerm> currentAuth) {
        this.currentAuth = currentAuth;
    }

    public List<AuthPerm> getAllAuth() {
        return this.allAuth;
    }

    public void setAllAuth(List<AuthPerm> allAuth) {
        this.allAuth = allAuth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PermissionMenuVO)) {
            return false;
        }
        PermissionMenuVO that = (PermissionMenuVO)o;
        return Objects.equals(this.menu, that.menu) && Objects.equals(this.currentAuth, that.currentAuth) && Objects.equals(this.allAuth, that.allAuth);
    }

    public int hashCode() {
        return Objects.hash(this.menu, this.currentAuth, this.allAuth);
    }

    public String toString() {
        return "PermissionMenuVO{menu=" + this.menu + ", currentAuth=" + this.currentAuth + ", allAuth=" + this.allAuth + "}";
    }

    public static class Meta {
        private String icon;
        private String title;

        public Meta() {
        }

        public Meta(String icon, String title) {
            this.icon = icon;
            this.title = title;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta meta = (Meta)o;
            return Objects.equals(this.icon, meta.icon) && Objects.equals(this.title, meta.title);
        }

        public int hashCode() {
            return Objects.hash(this.icon, this.title);
        }

        public String toString() {
            return "Meta{icon='" + this.icon + "', title='" + this.title + "'}";
        }
    }

    public static class AuthPerm {
        private String perms;
        private String description;
        private String icon;

        public AuthPerm() {
        }

        public AuthPerm(String perms, String description, String icon) {
            this.perms = perms;
            this.description = description;
            this.icon = icon;
        }

        public String getPerms() {
            return this.perms;
        }

        public void setPerms(String perms) {
            this.perms = perms;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public static AuthPerm buildAuthPerm(ResourceVO resourceVO) {
            return Optional.ofNullable(resourceVO).map(item -> new AuthPerm(resourceVO.getPerms(), resourceVO.getTitle(), resourceVO.getIcon())).orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AuthPerm)) {
                return false;
            }
            AuthPerm authPerm = (AuthPerm)o;
            return Objects.equals(this.perms, authPerm.perms) && Objects.equals(this.description, authPerm.description) && Objects.equals(this.icon, authPerm.icon);
        }

        public int hashCode() {
            return Objects.hash(this.perms, this.description, this.icon);
        }

        public String toString() {
            return "AuthPerm{perms='" + this.perms + "', description='" + this.description + "', icon='" + this.icon + "'}";
        }
    }

    public static class MenuInfo {
        private String id;
        private String name;
        private String url;
        private String component;
        private Meta meta;
        private List<MenuInfo> children;
        private Integer sort;

        public MenuInfo() {
        }

        public MenuInfo(String id, String name, String url, String component, Meta meta, List<MenuInfo> children, Integer sort) {
            this.id = id;
            this.name = name;
            this.url = url;
            this.component = component;
            this.meta = meta;
            this.children = children;
            this.sort = sort;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }

        public Meta getMeta() {
            return this.meta;
        }

        public void setMeta(Meta meta) {
            this.meta = meta;
        }

        public List<MenuInfo> getChildren() {
            return this.children;
        }

        public void setChildren(List<MenuInfo> children) {
            this.children = children;
        }

        public Integer getSort() {
            return this.sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public static MenuInfoBuilder builder() {
            return new MenuInfoBuilder();
        }

        public static MenuInfo buildMenuInfo(ResourceVO resourceVO) {
            return Optional.ofNullable(resourceVO).map(item -> {
                MenuInfo menuInfo = null;
                if (!resourceVO.getResourceType().equals(ResourceTypeConstants.MENU_TYPE_2)) {
                    menuInfo = MenuInfo.builder().id(item.getId()).name(item.getName()).url(item.getUrl()).component(item.getComponent()).meta(new Meta(item.getIcon(), item.getTitle())).sort(item.getSort()).build();
                    if (item.getIsLeaf().equals(Boolean.FALSE)) {
                        menuInfo.setChildren(new ArrayList<MenuInfo>());
                    }
                }
                return menuInfo;
            }).orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MenuInfo)) {
                return false;
            }
            MenuInfo menuInfo = (MenuInfo)o;
            return Objects.equals(this.id, menuInfo.id) && Objects.equals(this.name, menuInfo.name) && Objects.equals(this.url, menuInfo.url) && Objects.equals(this.component, menuInfo.component) && Objects.equals(this.meta, menuInfo.meta) && Objects.equals(this.children, menuInfo.children) && Objects.equals(this.sort, menuInfo.sort);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.url, this.component, this.meta, this.children, this.sort);
        }

        public String toString() {
            return "MenuInfo{id='" + this.id + "', name='" + this.name + "', url='" + this.url + "', component='" + this.component + "', meta=" + this.meta + ", children=" + this.children + ", sort=" + this.sort + "}";
        }

        public static final class MenuInfoBuilder {
            private String id;
            private String name;
            private String url;
            private String component;
            private Meta meta;
            private List<MenuInfo> children;
            private Integer sort;

            private MenuInfoBuilder() {
            }

            public MenuInfoBuilder id(String id) {
                this.id = id;
                return this;
            }

            public MenuInfoBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MenuInfoBuilder url(String url) {
                this.url = url;
                return this;
            }

            public MenuInfoBuilder component(String component) {
                this.component = component;
                return this;
            }

            public MenuInfoBuilder meta(Meta meta) {
                this.meta = meta;
                return this;
            }

            public MenuInfoBuilder children(List<MenuInfo> children) {
                this.children = children;
                return this;
            }

            public MenuInfoBuilder sort(Integer sort) {
                this.sort = sort;
                return this;
            }

            public MenuInfo build() {
                MenuInfo menuInfo = new MenuInfo(this.id, this.name, this.url, this.component, this.meta, this.children, this.sort);
                return menuInfo;
            }
        }
    }
}

