/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ApiDTO;
import org.apache.shenyu.common.utils.UUIDUtils;

public class ApiDO {
    private String id;
    private String contextPath;
    private String apiPath;
    private Integer httpMethod;
    private String consume;
    private String produce;
    private String version;
    private String rpcType;
    private Integer state;
    private String ext;
    private String apiOwner;
    private String apiDesc;
    private Integer apiSource;
    private String document;
    private String documentMd5;
    private Date dateCreated;
    private Date dateUpdated;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public Integer getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(Integer httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getConsume() {
        return this.consume;
    }

    public void setConsume(String consume) {
        this.consume = consume;
    }

    public String getProduce() {
        return this.produce;
    }

    public void setProduce(String produce) {
        this.produce = produce;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRpcType() {
        return this.rpcType;
    }

    public void setRpcType(String rpcType) {
        this.rpcType = rpcType;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public String getApiOwner() {
        return this.apiOwner;
    }

    public void setApiOwner(String apiOwner) {
        this.apiOwner = apiOwner;
    }

    public String getApiDesc() {
        return this.apiDesc;
    }

    public void setApiDesc(String apiDesc) {
        this.apiDesc = apiDesc;
    }

    public Integer getApiSource() {
        return this.apiSource;
    }

    public void setApiSource(Integer apiSource) {
        this.apiSource = apiSource;
    }

    public String getDocument() {
        return this.document;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public String getDocumentMd5() {
        return this.documentMd5;
    }

    public void setDocumentMd5(String documentMd5) {
        this.documentMd5 = documentMd5;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public static ApiDOBuilder builder() {
        return new ApiDOBuilder();
    }

    public static ApiDO buildApiDO(ApiDTO apiDTO) {
        return Optional.ofNullable(apiDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ApiDO apiDO = ApiDO.builder().contextPath(item.getContextPath()).apiPath(item.getApiPath()).httpMethod(item.getHttpMethod()).consume(item.getConsume()).produce(item.getProduce()).version(item.getVersion()).rpcType(item.getRpcType()).state(item.getState()).ext(item.getExt()).apiOwner(item.getApiOwner()).apiDesc(item.getApiDesc()).apiSource(item.getApiSource()).document(item.getDocument()).documentMd5(DigestUtils.md5Hex((String)item.getDocument())).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                apiDO.setId(UUIDUtils.getInstance().generateShortUuid());
                apiDO.setDateCreated(currentTime);
            } else {
                apiDO.setId(item.getId());
            }
            return apiDO;
        }).orElse(null);
    }

    public static final class ApiDOBuilder {
        private String id;
        private String contextPath;
        private String apiPath;
        private Integer httpMethod;
        private String consume;
        private String produce;
        private String version;
        private String rpcType;
        private Integer state;
        private String ext;
        private String apiOwner;
        private String apiDesc;
        private Integer apiSource;
        private String document;
        private String documentMd5;
        private Date dateCreated;
        private Date dateUpdated;

        private ApiDOBuilder() {
        }

        public ApiDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ApiDOBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public ApiDOBuilder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public ApiDOBuilder httpMethod(Integer httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public ApiDOBuilder consume(String consume) {
            this.consume = consume;
            return this;
        }

        public ApiDOBuilder produce(String produce) {
            this.produce = produce;
            return this;
        }

        public ApiDOBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ApiDOBuilder rpcType(String rpcType) {
            this.rpcType = rpcType;
            return this;
        }

        public ApiDOBuilder state(Integer state) {
            this.state = state;
            return this;
        }

        public ApiDOBuilder ext(String ext) {
            this.ext = ext;
            return this;
        }

        public ApiDOBuilder apiOwner(String apiOwner) {
            this.apiOwner = apiOwner;
            return this;
        }

        public ApiDOBuilder apiDesc(String apiDesc) {
            this.apiDesc = apiDesc;
            return this;
        }

        public ApiDOBuilder apiSource(Integer apiSource) {
            this.apiSource = apiSource;
            return this;
        }

        public ApiDOBuilder document(String document) {
            this.document = document;
            return this;
        }

        public ApiDOBuilder documentMd5(String documentMd5) {
            this.documentMd5 = documentMd5;
            return this;
        }

        public ApiDOBuilder dateCreated(Date dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public ApiDOBuilder dateUpdated(Date dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public ApiDO build() {
            ApiDO apiDO = new ApiDO();
            apiDO.setId(this.id);
            apiDO.setContextPath(this.contextPath);
            apiDO.setApiPath(this.apiPath);
            apiDO.setHttpMethod(this.httpMethod);
            apiDO.setConsume(this.consume);
            apiDO.setProduce(this.produce);
            apiDO.setVersion(this.version);
            apiDO.setRpcType(this.rpcType);
            apiDO.setState(this.state);
            apiDO.setExt(this.ext);
            apiDO.setApiOwner(this.apiOwner);
            apiDO.setApiDesc(this.apiDesc);
            apiDO.setApiSource(this.apiSource);
            apiDO.setDocument(this.document);
            apiDO.setDocumentMd5(this.documentMd5);
            apiDO.setDateCreated(this.dateCreated);
            apiDO.setDateUpdated(this.dateUpdated);
            return apiDO;
        }
    }
}

