/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver.aws;

import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AwsEndpoint
extends DefaultEndpoint {
    protected final String zone;
    protected final String region;

    public AwsEndpoint(String serviceURI, String region, String zone) {
        super(serviceURI);
        this.region = region;
        this.zone = zone;
    }

    public AwsEndpoint(String hostName, int port, boolean isSecure, String relativeUri, String region, String zone) {
        super(hostName, port, isSecure, relativeUri);
        this.region = region;
        this.zone = zone;
    }

    public String getRegion() {
        return this.region;
    }

    public String getZone() {
        return this.zone;
    }

    public static List<AwsEndpoint> createForServerList(List<String> hostNames, int port, boolean isSecure, String relativeUri, String region, String zone) {
        if (hostNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AwsEndpoint> awsEndpoints = new ArrayList<AwsEndpoint>(hostNames.size());
        for (String hostName : hostNames) {
            awsEndpoints.add(new AwsEndpoint(hostName, port, isSecure, relativeUri, region, zone));
        }
        return awsEndpoints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwsEndpoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AwsEndpoint that = (AwsEndpoint)o;
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        return !(this.zone != null ? !this.zone.equals(that.zone) : that.zone != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.zone != null ? this.zone.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AwsEndpoint{ serviceUrl='" + this.serviceUrl + '\'' + ", region='" + this.region + '\'' + ", zone='" + this.zone + '\'' + '}';
    }
}

