/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.ratelimiter.ServiceRateLimiter;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.ratelimit.client.sync.RemoteSyncTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RateLimitExtension
extends Destroyable {
    private final Extensions extensions;
    private final Map<String, ServiceRateLimiter> rateLimiters = new HashMap<String, ServiceRateLimiter>();
    private ServiceRateLimiter defaultRateLimiter;
    private final ScheduledExecutorService syncExecutor;
    private final ScheduledExecutorService windowExpireExecutor;
    private final Map<String, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap();
    private static final int EXPIRE_INTERVAL_SECOND = 5;

    public RateLimitExtension(Extensions extensions) {
        this.extensions = extensions;
        Collection<Plugin> plugins = extensions.getPlugins().getPlugins(PluginTypes.SERVICE_LIMITER.getBaseType());
        for (Plugin plugin : plugins) {
            if (plugin.getName().equals("reject")) {
                this.defaultRateLimiter = (ServiceRateLimiter)plugin;
            }
            this.rateLimiters.put(plugin.getName(), (ServiceRateLimiter)plugin);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("rateLimit-sync"));
        executor.setMaximumPoolSize(1);
        ScheduledThreadPoolExecutor expireExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("rateLimit-expire"));
        expireExecutor.setMaximumPoolSize(1);
        this.syncExecutor = executor;
        this.windowExpireExecutor = expireExecutor;
    }

    public ServiceRateLimiter getDefaultRateLimiter() {
        return this.defaultRateLimiter;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ServiceRateLimiter getRateLimiter(String name) {
        return this.rateLimiters.get(name);
    }

    public void submitSyncTask(RemoteSyncTask task) {
        ScheduledFuture<?> scheduledFuture = this.syncExecutor.scheduleWithFixedDelay(task, 0L, RateLimitExtension.getTaskDelayInterval(), TimeUnit.MILLISECONDS);
        this.scheduledTasks.put(task.getWindow().getUniqueKey(), scheduledFuture);
    }

    public void submitExpireJob(Runnable task) {
        this.windowExpireExecutor.scheduleWithFixedDelay(task, 5L, 5L, TimeUnit.SECONDS);
    }

    private static long getTaskDelayInterval() {
        Random random = new Random();
        return 30L + (long)random.nextInt(10);
    }

    public void stopSyncTask(String uniqueKey) {
        ScheduledFuture<?> future = this.scheduledTasks.remove(uniqueKey);
        if (null != future) {
            future.cancel(true);
        }
    }

    @Override
    protected void doDestroy() {
        ThreadPoolUtils.waitAndStopThreadPools(new ExecutorService[]{this.syncExecutor, this.windowExpireExecutor});
    }
}

