/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Iterator;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.consumer.MicroserviceInstancePing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SimpleMicroserviceInstancePing
implements MicroserviceInstancePing {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMicroserviceInstancePing.class);

    @Override
    public int getOrder() {
        return 100;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean ping(MicroserviceInstance instance) {
        if (CollectionUtils.isEmpty(instance.getEndpoints())) return false;
        Iterator<String> iterator = instance.getEndpoints().iterator();
        while (iterator.hasNext()) {
            String endpoint = iterator.next();
            IpPort ipPort = NetUtils.parseIpPortFromURI((String)endpoint);
            try (Socket s = new Socket();){
                s.connect(new InetSocketAddress(ipPort.getHostOrIp(), ipPort.getPort()), 3000);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOGGER.warn("ping instance {} endpoint {} failed", (Object)instance.getInstanceId(), (Object)endpoint);
            }
        }
        return false;
    }
}

