/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig;

import java.time.Duration;
import org.apache.servicecomb.config.DynamicProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="zero-config-model")
public class Config {
    private DynamicProperties dynamicProperties;

    @Autowired
    public Config setDynamicProperties(DynamicProperties dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
        return this;
    }

    public boolean isLocal() {
        return this.isEnabled() && "local".equals(this.getMode());
    }

    public boolean isMulticast() {
        return this.isEnabled() && "multicast".equals(this.getMode());
    }

    public boolean isEnabled() {
        return this.dynamicProperties.getBooleanProperty("servicecomb.service.zero-config.enabled", true);
    }

    public String getMode() {
        return this.dynamicProperties.getStringProperty("servicecomb.service.zero-config.mode", "multicast");
    }

    public String getMulticastAddress() {
        return this.dynamicProperties.getStringProperty("servicecomb.service.zero-config.multicast.address", "0.0.0.0:6666");
    }

    public String getMulticastGroup() {
        return this.dynamicProperties.getStringProperty("servicecomb.service.zero-config.multicast.group", "225.6.7.8");
    }

    public Duration getHeartbeatInterval() {
        String interval = this.dynamicProperties.getStringProperty("servicecomb.service.zero-config.heartbeat.interval", "30s");
        return this.toDuration(interval);
    }

    public Duration getCheckDeadInstancesInterval() {
        int lostTimes = this.dynamicProperties.getIntProperty("servicecomb.service.zero-config.heartbeat.lost-times", 3);
        return this.getHeartbeatInterval().multipliedBy(lostTimes);
    }

    public Duration getPullInterval() {
        String interval = this.dynamicProperties.getStringProperty("servicecomb.service.zero-config.pull-interval", "3s");
        return this.toDuration(interval);
    }

    private Duration toDuration(String interval) {
        return Duration.parse("PT" + interval);
    }
}

