/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.elasticsearch.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchClient.class);
    private static final String ELASTICSEARCH_INDEX_API_ENDPOINT = "/_all";
    private String elasticsearchUrl;
    private String userName;

    public ElasticsearchClient(String serviceName, Map<String, String> configs) {
        super(serviceName, configs, "elasticsearch-client");
        this.elasticsearchUrl = configs.get("elasticsearch.url");
        this.userName = configs.get("username");
        if (StringUtils.isEmpty((String)this.elasticsearchUrl)) {
            LOG.error("No value found for configuration 'elasticsearch.url'. Elasticsearch resource lookup will fail.");
        }
        if (StringUtils.isEmpty((String)this.userName)) {
            LOG.error("No value found for configuration 'username'. Elasticsearch resource lookup will fail.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Elasticsearch client is build with url: [" + this.elasticsearchUrl + "], user: [" + this.userName + "].");
        }
    }

    public List<String> getIndexList(final String indexMatching, final List<String> existingIndices) {
        Subject subj;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get elasticsearch index list for indexMatching: " + indexMatching + ", existingIndices: " + existingIndices);
        }
        if ((subj = this.getLoginSubject()) == null) {
            return Collections.emptyList();
        }
        List<String> ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                ClientResponse response;
                Map index2detailMap;
                String indexApi = null;
                if (StringUtils.isNotEmpty((String)indexMatching)) {
                    indexApi = '/' + indexMatching;
                    if (!indexApi.endsWith("*")) {
                        indexApi = indexApi + "*";
                    }
                } else {
                    indexApi = ElasticsearchClient.ELASTICSEARCH_INDEX_API_ENDPOINT;
                }
                if (MapUtils.isEmpty((Map)(index2detailMap = (Map)ElasticsearchClient.this.getElasticsearchResourceResponse(response = ElasticsearchClient.getClientResponse(ElasticsearchClient.this.elasticsearchUrl, indexApi, ElasticsearchClient.this.userName), new TypeToken<HashMap<String, Object>>(){}.getType())))) {
                    return Collections.emptyList();
                }
                Set indexResponses = index2detailMap.keySet();
                if (CollectionUtils.isEmpty(indexResponses)) {
                    return Collections.emptyList();
                }
                return ElasticsearchClient.filterResourceFromResponse(indexMatching, existingIndices, new ArrayList(indexResponses));
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get elasticsearch index list result: " + ret);
        }
        return ret;
    }

    private static ClientResponse getClientResponse(String elasticsearchUrl, String elasticsearchApi, String userName) {
        Object[] elasticsearchUrls = elasticsearchUrl.trim().split("[,;]");
        if (ArrayUtils.isEmpty((Object[])elasticsearchUrls)) {
            return null;
        }
        ClientResponse response = null;
        Client client = Client.create();
        for (Object currentUrl : elasticsearchUrls) {
            if (StringUtils.isBlank((String)currentUrl)) continue;
            String url = ((String)currentUrl).trim() + elasticsearchApi;
            try {
                response = ElasticsearchClient.getClientResponse(url, client, userName);
                if (response == null) continue;
                if (response.getStatus() == 200) break;
                response.close();
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting elasticsearch response, elasticsearchUrl: " + url;
                LOG.error(msgDesc, t);
            }
        }
        client.destroy();
        return response;
    }

    private static ClientResponse getClientResponse(String url, Client client, String userName) {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getClientResponse():calling " + url);
        }
        if ((response = (ClientResponse)((WebResource.Builder)client.resource(url).accept(new String[]{"application/json"}).header("userName", (Object)userName)).get(ClientResponse.class)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getClientResponse():response.getStatus()= " + response.getStatus());
            }
            if (response.getStatus() != 200) {
                LOG.warn("getClientResponse():response.getStatus()= " + response.getStatus() + " for URL " + url + ", failed to get elasticsearch resource list, response= " + (String)response.getEntity(String.class));
            }
        }
        return response;
    }

    private <T> T getElasticsearchResourceResponse(ClientResponse response, Type type) {
        Object resource;
        block8: {
            resource = null;
            try {
                if (response != null && response.getStatus() == 200) {
                    String jsonString = (String)response.getEntity(String.class);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    resource = gson.fromJson(jsonString, type);
                    break block8;
                }
                String msgDesc = "Unable to get a valid response for expected mime type : [application/json], elasticsearchUrl: " + this.elasticsearchUrl + " - got null response.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                throw hdpException;
            }
            catch (HadoopException he) {
                throw he;
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting elasticsearch resource response, elasticsearchUrl: " + this.elasticsearchUrl;
                HadoopException hdpException = new HadoopException(msgDesc, t);
                LOG.error(msgDesc, t);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                throw hdpException;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return (T)resource;
    }

    private static List<String> filterResourceFromResponse(String resourceMatching, List<String> existingResources, List<String> resourceResponses) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String resourceResponse : resourceResponses) {
            if (CollectionUtils.isNotEmpty(existingResources) && existingResources.contains(resourceResponse) || !StringUtils.isEmpty((String)resourceMatching) && !resourceMatching.startsWith("*") && !resourceResponse.toLowerCase().startsWith(resourceMatching.toLowerCase())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("filterResourceFromResponse(): Adding elasticsearch resource " + resourceResponse);
            }
            resources.add(resourceResponse);
        }
        return resources;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        ElasticsearchClient elasticsearchClient = ElasticsearchClient.getElasticsearchClient(serviceName, configs);
        List<String> indexList = elasticsearchClient.getIndexList(null, null);
        boolean connectivityStatus = false;
        if (CollectionUtils.isNotEmpty(indexList)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionTest list size " + indexList.size() + " elasticsearch indices.");
            }
            connectivityStatus = true;
        }
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any elasticsearch indices using given parameters.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info."), null, null, responseData);
        }
        return responseData;
    }

    public static ElasticsearchClient getElasticsearchClient(String serviceName, Map<String, String> configs) {
        ElasticsearchClient elasticsearchClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting elasticsearchClient for datasource: " + serviceName);
        }
        if (MapUtils.isEmpty(configs)) {
            String msgDesc = "Could not connect elasticsearch as connection configMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
            throw hdpException;
        }
        elasticsearchClient = new ElasticsearchClient(serviceName, configs);
        return elasticsearchClient;
    }
}

